[comment {-*- tcl -*- doctools manpage}]
[manpage_begin json n 1.1.1]
[copyright {2006 ActiveState Software Inc., 2009 Thomas Maeder, Glue Software Engineering AG}]
[moddesc   {JSON}]
[titledesc {JSON parser}]
[category  {CGI programming}]
[require Tcl 8.4]
[require json [opt 1.1.1]]
[keywords json javascript {data exchange} {exchange format}]
[description]
[para]

The [package json] package provides a simple Tcl-only library for parsing the
JSON [uri http://www.json.org/] data exchange format as specified in RFC 4627
[uri http://www.ietf.org/rfc/rfc4627.txt].

There is some ambiguity in parsing JSON because JSON has type information that
is not maintained by the Tcl conversion.  The [package json] package returns
data as a Tcl [cmd dict].  Either the [package dict] package or Tcl 8.5 is
required for use.

[section COMMANDS]

[list_begin definitions]

[call [cmd ::json::json2dict] [arg txt]]

Parse JSON formatted text [arg txt] into a Tcl dict and return the value.

[list_end]
[para]

[section EXAMPLES]
[para]

An example of a JSON array converted to Tcl.  A JSON array is returned as a
single item with multiple elements.

[para]
[example {[
    {
       "precision": "zip",
       "Latitude":  37.7668,
       "Longitude": -122.3959,
       "Address":   "",
       "City":      "SAN FRANCISCO",
       "State":     "CA",
       "Zip":       "94107",
       "Country":   "US"
    },
    {
       "precision": "zip",
       "Latitude":  37.371991,
       "Longitude": -122.026020,
       "Address":   "",
       "City":      "SUNNYVALE",
       "State":     "CA",
       "Zip":       "94085",
       "Country":   "US"
    }
]
=>
{Country US Latitude 37.7668 precision zip State CA City {SAN FRANCISCO} Address {} Zip 94107 Longitude -122.3959} {Country US Latitude 37.371991 precision zip State CA City SUNNYVALE Address {} Zip 94085 Longitude -122.026020}
}]
[para]

An example of a JSON object converted to Tcl.  A JSON object is returned as a
multi-element list (a dict).

[para]
[example {{
    "Image": {
        "Width":  800,
        "Height": 600,
        "Title":  "View from 15th Floor",
        "Thumbnail": {
            "Url":    "http://www.example.com/image/481989943",
            "Height": 125,
            "Width":  "100"
        },
        "IDs": [116, 943, 234, 38793]
    }
}
=>
Image {IDs {116 943 234 38793} Thumbnail {Width 100 Height 125 Url http://www.example.com/image/481989943} Width 800 Height 600 Title {View from 15th Floor}}
}]

[vset CATEGORY json]
[include ../doctools2base/include/feedback.inc]
[manpage_end]
