'\"
'\" Copyright (c) 2008 Donal K. Fellows
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
.so man.macros
.TH zlib n 8.6 Tcl "Tcl Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
zlib \- compression and decompression operations
.SH SYNOPSIS
.nf
\fBzlib \fIsubcommand arg ...\fR
.fi
.BE
.SH DESCRIPTION
.PP
The \fBzlib\fR command provides access to the compression and check-summing
facilities of the Zlib library by Jean-loup Gailly and Mark Adler. It has the
following subcommands.
.SS "COMPRESSION SUBCOMMANDS"
.TP
\fBzlib compress\fI string\fR ?\fIlevel\fR?
.
Returns the zlib-format compressed binary data of the binary string in
\fIstring\fR. If present, \fIlevel\fR gives the compression level to use (from
0, which is uncompressed, to 9, maximally compressed).
.TP
\fBzlib decompress\fI string\fR ?\fIbufferSize\fR?
.
Returns the uncompressed version of the raw compressed binary data in
\fIstring\fR. If present, \fIbufferSize\fR is a hint as to what size of buffer
is to be used to receive the data.
.TP
\fBzlib deflate\fI string\fR ?\fIlevel\fR?
.
Returns the raw compressed binary data of the binary string in \fIstring\fR.
If present, \fIlevel\fR gives the compression level to use (from 0, which is
uncompressed, to 9, maximally compressed).
.TP
\fBzlib gunzip\fI string\fR ?\fB\-headerVar \fIvarName\fR?
.
Return the uncompressed contents of binary string \fIstring\fR, which must
have been in gzip format. If \fB\-headerVar\fR is given, store a dictionary
describing the contents of the gzip header in the variable called
\fIvarName\fR. The keys of the dictionary that may be present are:
.RS
.TP
\fBcomment\fR
.
The comment field from the header, if present.
.TP
\fBcrc\fR
.
A boolean value describing whether a CRC of the header is computed.
.TP
\fBfilename\fR
.
The filename field from the header, if present.
.TP
\fBos\fR
.
The operating system type code field from the header (if not the
QW unknown
value). See RFC 1952 for the meaning of these codes.
.TP
\fBsize\fR
.
The size of the uncompressed data.
.TP
\fBtime\fR
.
The time field from the header if non-zero, expected to be time that the file
named by the \fBfilename\fR field was modified. Suitable for use with
\fBclock format\fR.
.TP
\fBtype\fR
.
The type of the uncompressed data (\fBbinary\fR or \fBtext\fR) if known.
.RE
.TP
\fBzlib gzip\fI string\fR ?\fB\-level \fIlevel\fR? ?\fB\-header \fIdict\fR? 
.
Return the compressed contents of binary string \fIstring\fR in gzip format.
If \fB\-level\fR is given, \fIlevel\fR gives the compression level to use
(from 0, which is uncompressed, to 9, maximally compressed). If \fB\-header\fR
is given, \fIdict\fR is a dictionary containing values used for the gzip
header. The following keys may be defined:
.RS
.TP
\fBcomment\fR
.
Add the given comment to the header of the gzip-format data.
.TP
\fBcrc\fR
.
A boolean saying whether to compute a CRC of the header. Note that if the data
is to be interchanged with the \fBgzip\fR program, a header CRC should
\fInot\fR be computed.
.TP
\fBfilename\fR
.
The name of the file that the data to be compressed came from.
.TP
\fBos\fR
.
The operating system type code, which should be one of the values described in
RFC 1952.
.TP
\fBtime\fR
.
The time that the file named in the \fBfilename\fR key was last modified. This
will be in the same as is returned by \fBclock seconds\fR or \fBfile mtime\fR.
.TP
\fBtype\fR
.
The type of the data being compressed, being \fBbinary\fR or \fBtext\fR.
.RE
.TP
\fBzlib inflate\fI string\fR ?\fIbufferSize\fR?
.
Returns the uncompressed version of the raw compressed binary data in
\fIstring\fR. If present, \fIbufferSize\fR is a hint as to what size of buffer
is to be used to receive the data.
.SS "CHANNEL SUBCOMMAND"
.TP
\fBzlib push\fI mode channel\fR ?\fIoptions ...\fR?
.
Pushes a compressing or decompressing transformation onto the channel
\fIchannel\fR.
The transformation can be removed again with \fBchan pop\fR.
The \fImode\fR argument determines what type of transformation
is pushed; the following are supported:
.RS
.TP
\fBcompress\fR
.
The transformation will be a compressing transformation that produces
zlib-format data on \fIchannel\fR, which must be writable.
.TP
\fBdecompress\fR
.
The transformation will be a decompressing transformation that reads
zlib-format data from \fIchannel\fR, which must be readable.
.TP
\fBdeflate\fR
.
The transformation will be a compressing transformation that produces raw
compressed data on \fIchannel\fR, which must be writable.
.TP
\fBgunzip\fR
.
The transformation will be a decompressing transformation that reads
gzip-format data from \fIchannel\fR, which must be readable.
.TP
\fBgzip\fR
.
The transformation will be a compressing transformation that produces
gzip-format data on \fIchannel\fR, which must be writable.
.TP
\fBinflate\fR
.
The transformation will be a decompressing transformation that reads raw
compressed data from \fIchannel\fR, which must be readable.
.PP
The following options may be set when creating a transformation via
the
.QW "\fIoptions ...\fR"
to the \fBzlib push\fR command:
.TP
\fB\-header\fI dictionary\fR
.
Passes a description of the gzip header to create, in the same format that
\fBzlib gzip\fR understands.
.TP
\fB\-level\fI compressionLevel\fR
.
How hard to compress the data. Must be an integer from 0 (uncompressed) to 9
(maximally compressed).
'\".TP
'\"\fB\-limit\fI readaheadLimit\fR
'\".
'\"The maximum number of bytes ahead to read.
'\"\fITODO: not yet implemented!\fR
.PP
Both compressing and decompressing channel transformations add extra
configuration options that may be accessed through \fBchan configure\fR. Each
option is either a read-only or a write-only option. The options are:
.TP
\fB\-flush\fI type\fR
.
This write-only operation flushes the current state of the compressor to the
underlying channel. It is only valid for compressing transformations. The
\fItype\fR must be either \fBsync\fR or \fBfull\fR for a normal flush or an
expensive flush respectively. Flushing degrades the compression ratio, but
makes it easier for a decompressor to recover more of the file in the case of
data corruption.
.TP
\fB\-checksum\fR
.
This read-only option, valid for both compressing and decompressing
transforms, gets the current checksum for the uncompressed data that the
compression engine has seen so far. The compression algorithm depends on what
format is being produced or consumed.
.TP
\fB\-header\fR
.
This read-only option, only valid for decompressing transforms that are
processing gzip-format data, returns the dictionary describing the header read
off the data stream.
.RE
.SS "STREAMING SUBCOMMAND"
.TP
\fBzlib stream\fI mode\fR ?\fIlevel\fR?
.
Creates a streaming compression or decompression command based on the
\fImode\fR, and return the name of the command. For a description of how that
command works, see \fBSTREAMING INSTANCE COMMAND\fR below. The following modes
are supported:
.RS
.TP
\fBzlib stream compress\fR ?\fIlevel\fR?
.
The stream will be a compressing stream that produces zlib-format output,
using compression level \fIlevel\fR (if specified) which will be an integer
from 0 to 9.
.TP
\fBzlib stream decompress\fR
.
The stream will be a decompressing stream that takes zlib-format input and
produces uncompressed output.
.TP
\fBzlib stream deflate\fR ?\fIlevel\fR?
.
The stream will be a compressing stream that produces raw output, using
compression level \fIlevel\fR (if specified) which will be an integer from 0
to 9.
.TP
\fBzlib stream gunzip\fR
.
The stream will be a decompressing stream that takes gzip-format input and
produces uncompressed output.
.TP
\fBzlib stream gzip\fR ?\fIlevel\fR?
.
The stream will be a compressing stream that produces gzip-format output,
using compression level \fIlevel\fR (if specified) which will be an integer
from 0 to 9.
'\" TODO: Header dictionary!
.TP
\fBzlib stream inflate\fR
.
The stream will be a decompressing stream that takes raw compressed input and
produces uncompressed output.
.RE
.SS "CHECKSUMMING SUBCOMMANDS"
.TP
\fBzlib adler32\fI string\fR ?\fIinitValue\fR?
.
Compute a checksum of binary string \fIstring\fR using the Adler-32 algorithm.
If given, \fIinitValue\fR is used to initialize the checksum engine.
.TP
\fBzlib crc32\fI string\fR ?\fIinitValue\fR?
.
Compute a checksum of binary string \fIstring\fR using the CRC-32 algorithm.
If given, \fIinitValue\fR is used to initialize the checksum engine.
.SH "STREAMING INSTANCE COMMAND"
.PP
Streaming compression instance commands are produced by the \fBzlib stream\fR
command. They are used by calling their \fBput\fR subcommand one or more times
to load data in, and their \fBget\fR subcommand one or more times to extract
the transformed data.
.PP
The full set of subcommands supported by a streaming instance command,
\fIstream\fR, is as follows:
.TP
\fIstream \fBadd\fR ?\fIoption\fR? \fIdata\fR
.
A short-cut for
.QW "\fIstream \fBput \fIoption data\fR"
followed by
.QW "\fIstream \fBget\fR" .
.TP
\fIstream \fBchecksum\fR
.
Returns the checksum of the uncompressed data seen so far by this stream.
.TP
\fIstream \fBclose\fR
.
Deletes this stream and frees up all resources associated with it.
.TP
\fIstream \fBeof\fR
.
Returns a boolean indicating whether the end of the stream (as determined by
the compressed data itself) has been reached. Not all formats support
detection of the end of the stream.
.TP
\fIstream \fBfinalize\fR
.
A short-cut for
.QW "\fIstream \fBput \-finalize {}\fR" .
.TP
\fIstream \fBflush\fR
.
A short-cut for
.QW "\fIstream \fBput \-flush {}\fR" .
.TP
\fIstream \fBfullflush\fR
.
A short-cut for
.QW "\fIstream \fBput \-fullflush {}\fR" .
.TP
\fIstream \fBget \fR?\fIcount\fR?
.
Return up to \fIcount\fR bytes from \fIstream\fR's internal buffers with the
transformation applied. If \fIcount\fR is omitted, the entire contents of the
buffers are returned.
.TP
\fIstream \fBput\fR ?\fIoption\fR? \fIdata\fR
.
Append the contents of the binary string \fIdata\fR to \fIstream\fR's internal
buffers while applying the transformation. If present, \fIoption\fR must be
one of the following (or an unambiguous prefix) which are used to modify the
way in which the transformation is applied:
.RS
.TP
\fB\-finalize\fR
.
Mark the stream as finished, ensuring that all bytes have been wholly
compressed or decompressed. For gzip streams, this also ensures that the
footer is written to the stream. The stream will need to be reset before
having more data written to it after this, though data can still be read out
of the stream with the \fBget\fR subcommand.
.TP
\fB\-flush\fR
.
Ensure that a decompressor consuming the bytes that the current (compressing)
stream is producing will be able to produce all the bytes that have been
compressed so far, at some performance penalty.
.TP
\fB\-fullflush\fR
.
Ensure that not only can a decompressor handle all the bytes produced so far
(as with \fB\-flush\fR above) but also that it can restart from this point if
it detects that the stream is partially corrupt. This incurs a substantial
performance penalty.
.RE
.TP
\fIstream \fBreset\fR
.
Puts any stream, including those that have been finalized or that have reached
eof, back into a state where it can process more data. Throws away all
internally buffered data.
.SH EXAMPLES
.PP
To compress a Tcl string, it should be first converted to a particular charset
encoding since the \fBzlib\fR command always operates on binary strings.
.PP
.CS
set binData [encoding convertto utf-8 $string]
set compData [\fBzlib compress\fR $binData]
.CE
.PP
When converting back, it is also important to reverse the charset encoding:
.PP
.CS
set binData [\fBzlib decompress\fR $compData]
set string [encoding convertfrom utf-8 $binData]
.CE
.PP
The compression operation from above can also be done with streams, which is
especially helpful when you want to accumulate the data by stages:
.PP
.CS
set strm [\fBzlib stream\fR compress]
$\fIstrm \fBput\fR [encoding convertto utf-8 $string]
# ...
$\fIstrm \fBfinalize\fR
set compData [$\fIstrm \fBget\fR]
$\fIstrm \fBclose\fR
.CE
.SH "SEE ALSO"
binary(n), chan(n), encoding(n), Tcl_ZlibDeflate(3), RFC1950 \- RFC1952
.SH "KEYWORDS"
compress, decompress, deflate, gzip, inflate
'\" Local Variables:
'\" mode: nroff
'\" End:
