'\"
'\" Copyright (c) 2007 Donal K. Fellows
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\"
.so man.macros
.TH copy n 0.1 TclOO "TclOO Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
oo::copy \- create copies of objects and classes
.SH SYNOPSIS
.nf
package require TclOO

\fBoo::copy\fI sourceObject \fR?\fItargetObject\fR?
.fi
.BE
.SH DESCRIPTION
.PP
The \fBoo::copy\fR command creates a copy of an object or class. It takes the
name of the object or class to be copied, \fIsourceObject\fR, and optionally
the name of the object or class to create, \fItargetObject\fR, which will be
resolved relative to the current namespace if not an absolute qualified name.
If \fItargetObject\fR is omitted, a new name is chosen. The copied object will
be of the same class as the source object, and will have all its per-object
methods copied. If it is a class, it will also have all the class methods in
the class copied, but it will not have any of its instances copied. The
contents of the source object's private namespace \fIwill not\fR be copied; it
is up to the caller to do this. The result of this command will be the
fully-qualified name of the new object or class.
.SH EXAMPLES
.PP
This example creates an object, copies it, modifies the source object, and
then demonstrates that the copied object is indeed a copy.
.PP
.CS
oo::object create src
oo::objdefine src method msg {} {puts foo}
\fBoo::copy\fR src dst
oo::objdefine src method msg {} {puts bar}
src msg              \fI\(-> prints "bar"\fR
dst msg              \fI\(-> prints "foo"\fR
.CE
.SH "SEE ALSO"
oo::class(n), oo::define(n), oo::object(n)
.SH KEYWORDS
clone, copy, duplication, object
.\" Local variables:
.\" mode: nroff
.\" fill-column: 78
.\" End:
