/*----- PROTECTED REGION ID(DataBaseClass.cpp) ENABLED START -----*/
static const char *RcsId      = "$Id: DataBaseClass.cpp 16170 2011-03-21 15:49:11Z pascal_verdier $";
static const char *TagName    = "$Name: Database-Release-4.12 $";
static const char *CvsPath    = "$Source:  $";
static const char *SvnPath    = "$HeadURL:  $";
static const char *HttpServer = "http://www.esrf.eu/computing/cs/tango/tango_doc/ds_doc/";
//=============================================================================
//
// file :        DataBaseClass.cpp
//
// description : C++ source for the DataBaseClass. A singleton
//               class derived from DeviceClass. It implements the
//               command list and all properties and methods required
//               by the name once per process.
//
// project :     TANGO.
//
// $Author: pascal_verdier $
//
// Copyright (C) :      2004,2005,2006,2007,2008,2009,2010
//						European Synchrotron Radiation Facility
//                      BP 220, Grenoble 38043
//                      FRANCE
//
// This file is part of Tango.
//
// Tango is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// Tango is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with Tango.  If not, see <http://www.gnu.org/licenses/>.
//
// $Revision: 16170 $
// $Date: 2011-03-21 16:49:11 +0100 (Mon, 21 Mar 2011) $
//
// $HeadURL:$
//
//=============================================================================
//                This file is generated by POGO
//        (Program Obviously used to Generate tango Object)
//=============================================================================


#include <tango.h>
#include <DataBase.h>
#include <DataBaseClass.h>

/*----- PROTECTED REGION END -----*/

//-------------------------------------------------------------------
/**
 *	Create DataBaseClass singleton and
 *	return it in a C function for Python usage
 */
//-------------------------------------------------------------------
extern "C" {
#ifdef _TG_WINDOWS_

__declspec(dllexport)

#endif

	Tango::DeviceClass *_create_DataBase_class(const char *name) {
		return DataBase_ns::DataBaseClass::init(name);
	}
}


namespace DataBase_ns
{


//===================================================================
//	Initialize pointer for singleton pattern
//===================================================================
DataBaseClass *DataBaseClass::_instance = NULL;

//--------------------------------------------------------
/**
 * method : 		DataBaseClass::DataBaseClass(string &s)
 * description : 	constructor for the DataBaseClass
 *
 * @param s	The class name
 */
//--------------------------------------------------------
DataBaseClass::DataBaseClass(string &s):DeviceClass(s)
{
	cout2 << "Entering DataBaseClass constructor" << endl;
	set_default_property();
	get_class_property();
	write_class_property();

	/*----- PROTECTED REGION ID(DataBase::Class::constructor) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::Class::constructor

	cout2 << "Leaving DataBaseClass constructor" << endl;
}


//--------------------------------------------------------
/**
 * method : 		DataBaseClass::~DataBaseClass()
 * description : 	destructor for the DataBaseClass
 */
//--------------------------------------------------------
DataBaseClass::~DataBaseClass()
{
	/*----- PROTECTED REGION ID(DataBase::Class::destructor) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::Class::destructor

	_instance = NULL;
}


//--------------------------------------------------------
/**
 * method : 		DataBaseClass::init
 * description : 	Create the object if not already done.
 *                  Otherwise, just return a pointer to the object
 *
 * @param	name	The class name
 */
//--------------------------------------------------------
DataBaseClass *DataBaseClass::init(const char *name)
{
	if (_instance == NULL)
	{
		try
		{
			string s(name);
			_instance = new DataBaseClass(s);
		}
		catch (bad_alloc)
		{
			throw;
		}		
	}		
	return _instance;
}

//--------------------------------------------------------
/**
 * method : 		DataBaseClass::instance
 * description : 	Check if object already created,
 *                  and return a pointer to the object
 */
//--------------------------------------------------------
DataBaseClass *DataBaseClass::instance()
{
	if (_instance == NULL)
	{
		cerr << "Class is not initialised !!" << endl;
		exit(-1);
	}
	return _instance;
}




//===================================================================
//	Command execution method calls
//===================================================================
//--------------------------------------------------------
/**
 * method : 		DbAddDeviceClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbAddDeviceClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbAddDeviceClass::execute(): arrived" << endl;

	const Tango::DevVarStringArray	*argin;
	extract(in_any, argin);
	((static_cast<DataBase *>(device))->db_add_device(argin));
	return new CORBA::Any();
}
//--------------------------------------------------------
/**
 * method : 		DbAddServerClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbAddServerClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbAddServerClass::execute(): arrived" << endl;

	const Tango::DevVarStringArray	*argin;
	extract(in_any, argin);
	((static_cast<DataBase *>(device))->db_add_server(argin));
	return new CORBA::Any();
}
//--------------------------------------------------------
/**
 * method : 		DbDeleteAttributeAliasClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbDeleteAttributeAliasClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbDeleteAttributeAliasClass::execute(): arrived" << endl;

	Tango::DevString	argin;
	extract(in_any, argin);
	((static_cast<DataBase *>(device))->db_delete_attribute_alias(argin));
	return new CORBA::Any();
}
//--------------------------------------------------------
/**
 * method : 		DbDeleteClassAttributeClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbDeleteClassAttributeClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbDeleteClassAttributeClass::execute(): arrived" << endl;

	const Tango::DevVarStringArray	*argin;
	extract(in_any, argin);
	((static_cast<DataBase *>(device))->db_delete_class_attribute(argin));
	return new CORBA::Any();
}
//--------------------------------------------------------
/**
 * method : 		DbDeleteClassAttributePropertyClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbDeleteClassAttributePropertyClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbDeleteClassAttributePropertyClass::execute(): arrived" << endl;

	const Tango::DevVarStringArray	*argin;
	extract(in_any, argin);
	((static_cast<DataBase *>(device))->db_delete_class_attribute_property(argin));
	return new CORBA::Any();
}
//--------------------------------------------------------
/**
 * method : 		DbDeleteClassPropertyClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbDeleteClassPropertyClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbDeleteClassPropertyClass::execute(): arrived" << endl;

	const Tango::DevVarStringArray	*argin;
	extract(in_any, argin);
	((static_cast<DataBase *>(device))->db_delete_class_property(argin));
	return new CORBA::Any();
}
//--------------------------------------------------------
/**
 * method : 		DbDeleteDeviceClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbDeleteDeviceClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbDeleteDeviceClass::execute(): arrived" << endl;

	Tango::DevString	argin;
	extract(in_any, argin);
	((static_cast<DataBase *>(device))->db_delete_device(argin));
	return new CORBA::Any();
}
//--------------------------------------------------------
/**
 * method : 		DbDeleteDeviceAliasClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbDeleteDeviceAliasClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbDeleteDeviceAliasClass::execute(): arrived" << endl;

	Tango::DevString	argin;
	extract(in_any, argin);
	((static_cast<DataBase *>(device))->db_delete_device_alias(argin));
	return new CORBA::Any();
}
//--------------------------------------------------------
/**
 * method : 		DbDeleteDeviceAttributeClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbDeleteDeviceAttributeClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbDeleteDeviceAttributeClass::execute(): arrived" << endl;

	const Tango::DevVarStringArray	*argin;
	extract(in_any, argin);
	((static_cast<DataBase *>(device))->db_delete_device_attribute(argin));
	return new CORBA::Any();
}
//--------------------------------------------------------
/**
 * method : 		DbDeleteDeviceAttributePropertyClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbDeleteDeviceAttributePropertyClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbDeleteDeviceAttributePropertyClass::execute(): arrived" << endl;

	const Tango::DevVarStringArray	*argin;
	extract(in_any, argin);
	((static_cast<DataBase *>(device))->db_delete_device_attribute_property(argin));
	return new CORBA::Any();
}
//--------------------------------------------------------
/**
 * method : 		DbDeleteDevicePropertyClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbDeleteDevicePropertyClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbDeleteDevicePropertyClass::execute(): arrived" << endl;

	const Tango::DevVarStringArray	*argin;
	extract(in_any, argin);
	((static_cast<DataBase *>(device))->db_delete_device_property(argin));
	return new CORBA::Any();
}
//--------------------------------------------------------
/**
 * method : 		DbDeletePropertyClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbDeletePropertyClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbDeletePropertyClass::execute(): arrived" << endl;

	const Tango::DevVarStringArray	*argin;
	extract(in_any, argin);
	((static_cast<DataBase *>(device))->db_delete_property(argin));
	return new CORBA::Any();
}
//--------------------------------------------------------
/**
 * method : 		DbDeleteServerClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbDeleteServerClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbDeleteServerClass::execute(): arrived" << endl;

	Tango::DevString	argin;
	extract(in_any, argin);
	((static_cast<DataBase *>(device))->db_delete_server(argin));
	return new CORBA::Any();
}
//--------------------------------------------------------
/**
 * method : 		DbDeleteServerInfoClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbDeleteServerInfoClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbDeleteServerInfoClass::execute(): arrived" << endl;

	Tango::DevString	argin;
	extract(in_any, argin);
	((static_cast<DataBase *>(device))->db_delete_server_info(argin));
	return new CORBA::Any();
}
//--------------------------------------------------------
/**
 * method : 		DbExportDeviceClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbExportDeviceClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbExportDeviceClass::execute(): arrived" << endl;

	const Tango::DevVarStringArray	*argin;
	extract(in_any, argin);
	((static_cast<DataBase *>(device))->db_export_device(argin));
	return new CORBA::Any();
}
//--------------------------------------------------------
/**
 * method : 		DbExportEventClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbExportEventClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbExportEventClass::execute(): arrived" << endl;

	const Tango::DevVarStringArray	*argin;
	extract(in_any, argin);
	((static_cast<DataBase *>(device))->db_export_event(argin));
	return new CORBA::Any();
}
//--------------------------------------------------------
/**
 * method : 		DbGetAliasDeviceClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetAliasDeviceClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetAliasDeviceClass::execute(): arrived" << endl;

	Tango::DevString	argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_alias_device(argin));
}
//--------------------------------------------------------
/**
 * method : 		DbGetAttributeAliasClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetAttributeAliasClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetAttributeAliasClass::execute(): arrived" << endl;

	Tango::DevString	argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_attribute_alias(argin));
}
//--------------------------------------------------------
/**
 * method : 		DbGetAttributeAliasListClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetAttributeAliasListClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetAttributeAliasListClass::execute(): arrived" << endl;

	Tango::DevString	argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_attribute_alias_list(argin));
}
//--------------------------------------------------------
/**
 * method : 		DbGetClassAttributeListClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetClassAttributeListClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetClassAttributeListClass::execute(): arrived" << endl;

	const Tango::DevVarStringArray	*argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_class_attribute_list(argin));
}
//--------------------------------------------------------
/**
 * method : 		DbGetClassAttributePropertyClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetClassAttributePropertyClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetClassAttributePropertyClass::execute(): arrived" << endl;

	const Tango::DevVarStringArray	*argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_class_attribute_property(argin));
}
//--------------------------------------------------------
/**
 * method : 		DbGetClassAttributeProperty2Class::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetClassAttributeProperty2Class::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetClassAttributeProperty2Class::execute(): arrived" << endl;

	const Tango::DevVarStringArray	*argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_class_attribute_property2(argin));
}
//--------------------------------------------------------
/**
 * method : 		DbGetClassAttributePropertyHistClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetClassAttributePropertyHistClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetClassAttributePropertyHistClass::execute(): arrived" << endl;

	const Tango::DevVarStringArray	*argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_class_attribute_property_hist(argin));
}
//--------------------------------------------------------
/**
 * method : 		DbGetClassForDeviceClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetClassForDeviceClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetClassForDeviceClass::execute(): arrived" << endl;

	Tango::DevString	argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_class_for_device(argin));
}
//--------------------------------------------------------
/**
 * method : 		DbGetClassInheritanceForDeviceClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetClassInheritanceForDeviceClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetClassInheritanceForDeviceClass::execute(): arrived" << endl;

	Tango::DevString	argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_class_inheritance_for_device(argin));
}
//--------------------------------------------------------
/**
 * method : 		DbGetClassListClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetClassListClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetClassListClass::execute(): arrived" << endl;

	Tango::DevString	argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_class_list(argin));
}
//--------------------------------------------------------
/**
 * method : 		DbGetClassPropertyClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetClassPropertyClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetClassPropertyClass::execute(): arrived" << endl;

	const Tango::DevVarStringArray	*argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_class_property(argin));
}
//--------------------------------------------------------
/**
 * method : 		DbGetClassPropertyHistClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetClassPropertyHistClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetClassPropertyHistClass::execute(): arrived" << endl;

	const Tango::DevVarStringArray	*argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_class_property_hist(argin));
}
//--------------------------------------------------------
/**
 * method : 		DbGetClassPropertyListClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetClassPropertyListClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetClassPropertyListClass::execute(): arrived" << endl;

	Tango::DevString	argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_class_property_list(argin));
}
//--------------------------------------------------------
/**
 * method : 		DbGetDeviceAliasClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetDeviceAliasClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetDeviceAliasClass::execute(): arrived" << endl;

	Tango::DevString	argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_device_alias(argin));
}
//--------------------------------------------------------
/**
 * method : 		DbGetDeviceAliasListClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetDeviceAliasListClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetDeviceAliasListClass::execute(): arrived" << endl;

	Tango::DevString	argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_device_alias_list(argin));
}
//--------------------------------------------------------
/**
 * method : 		DbGetDeviceAttributeListClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetDeviceAttributeListClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetDeviceAttributeListClass::execute(): arrived" << endl;

	const Tango::DevVarStringArray	*argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_device_attribute_list(argin));
}
//--------------------------------------------------------
/**
 * method : 		DbGetDeviceAttributePropertyClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetDeviceAttributePropertyClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetDeviceAttributePropertyClass::execute(): arrived" << endl;

	const Tango::DevVarStringArray	*argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_device_attribute_property(argin));
}
//--------------------------------------------------------
/**
 * method : 		DbGetDeviceAttributeProperty2Class::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetDeviceAttributeProperty2Class::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetDeviceAttributeProperty2Class::execute(): arrived" << endl;

	const Tango::DevVarStringArray	*argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_device_attribute_property2(argin));
}
//--------------------------------------------------------
/**
 * method : 		DbGetDeviceAttributePropertyHistClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetDeviceAttributePropertyHistClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetDeviceAttributePropertyHistClass::execute(): arrived" << endl;

	const Tango::DevVarStringArray	*argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_device_attribute_property_hist(argin));
}
//--------------------------------------------------------
/**
 * method : 		DbGetDeviceClassListClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetDeviceClassListClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetDeviceClassListClass::execute(): arrived" << endl;

	Tango::DevString	argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_device_class_list(argin));
}
//--------------------------------------------------------
/**
 * method : 		DbGetDeviceDomainListClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetDeviceDomainListClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetDeviceDomainListClass::execute(): arrived" << endl;

	Tango::DevString	argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_device_domain_list(argin));
}
//--------------------------------------------------------
/**
 * method : 		DbGetDeviceExportedListClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetDeviceExportedListClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetDeviceExportedListClass::execute(): arrived" << endl;

	Tango::DevString	argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_device_exported_list(argin));
}
//--------------------------------------------------------
/**
 * method : 		DbGetDeviceFamilyListClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetDeviceFamilyListClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetDeviceFamilyListClass::execute(): arrived" << endl;

	Tango::DevString	argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_device_family_list(argin));
}
//--------------------------------------------------------
/**
 * method : 		DbGetDeviceInfoClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetDeviceInfoClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetDeviceInfoClass::execute(): arrived" << endl;

	Tango::DevString	argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_device_info(argin));
}
//--------------------------------------------------------
/**
 * method : 		DbGetDeviceListClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetDeviceListClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetDeviceListClass::execute(): arrived" << endl;

	const Tango::DevVarStringArray	*argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_device_list(argin));
}
//--------------------------------------------------------
/**
 * method : 		DbGetDeviceWideListClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetDeviceWideListClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetDeviceWideListClass::execute(): arrived" << endl;

	Tango::DevString	argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_device_wide_list(argin));
}
//--------------------------------------------------------
/**
 * method : 		DbGetDeviceMemberListClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetDeviceMemberListClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetDeviceMemberListClass::execute(): arrived" << endl;

	Tango::DevString	argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_device_member_list(argin));
}
//--------------------------------------------------------
/**
 * method : 		DbGetDevicePropertyClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetDevicePropertyClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetDevicePropertyClass::execute(): arrived" << endl;

	const Tango::DevVarStringArray	*argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_device_property(argin));
}
//--------------------------------------------------------
/**
 * method : 		DbGetDevicePropertyHistClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetDevicePropertyHistClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetDevicePropertyHistClass::execute(): arrived" << endl;

	const Tango::DevVarStringArray	*argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_device_property_hist(argin));
}
//--------------------------------------------------------
/**
 * method : 		DbGetDevicePropertyListClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetDevicePropertyListClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetDevicePropertyListClass::execute(): arrived" << endl;

	const Tango::DevVarStringArray	*argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_device_property_list(argin));
}
//--------------------------------------------------------
/**
 * method : 		DbGetDeviceServerClassListClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetDeviceServerClassListClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetDeviceServerClassListClass::execute(): arrived" << endl;

	Tango::DevString	argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_device_server_class_list(argin));
}
//--------------------------------------------------------
/**
 * method : 		DbGetExportdDeviceListForClassClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetExportdDeviceListForClassClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetExportdDeviceListForClassClass::execute(): arrived" << endl;

	Tango::DevString	argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_exportd_device_list_for_class(argin));
}
//--------------------------------------------------------
/**
 * method : 		DbGetHostListClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetHostListClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetHostListClass::execute(): arrived" << endl;

	Tango::DevString	argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_host_list(argin));
}
//--------------------------------------------------------
/**
 * method : 		DbGetHostServerListClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetHostServerListClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetHostServerListClass::execute(): arrived" << endl;

	Tango::DevString	argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_host_server_list(argin));
}
//--------------------------------------------------------
/**
 * method : 		DbGetHostServersInfoClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetHostServersInfoClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetHostServersInfoClass::execute(): arrived" << endl;

	Tango::DevString	argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_host_servers_info(argin));
}
//--------------------------------------------------------
/**
 * method : 		DbGetInstanceNameListClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetInstanceNameListClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetInstanceNameListClass::execute(): arrived" << endl;

	Tango::DevString	argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_instance_name_list(argin));
}
//--------------------------------------------------------
/**
 * method : 		DbGetObjectListClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetObjectListClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetObjectListClass::execute(): arrived" << endl;

	Tango::DevString	argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_object_list(argin));
}
//--------------------------------------------------------
/**
 * method : 		DbGetPropertyClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetPropertyClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetPropertyClass::execute(): arrived" << endl;

	const Tango::DevVarStringArray	*argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_property(argin));
}
//--------------------------------------------------------
/**
 * method : 		DbGetPropertyHistClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetPropertyHistClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetPropertyHistClass::execute(): arrived" << endl;

	const Tango::DevVarStringArray	*argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_property_hist(argin));
}
//--------------------------------------------------------
/**
 * method : 		DbGetPropertyListClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetPropertyListClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetPropertyListClass::execute(): arrived" << endl;

	const Tango::DevVarStringArray	*argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_property_list(argin));
}
//--------------------------------------------------------
/**
 * method : 		DbGetServerInfoClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetServerInfoClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetServerInfoClass::execute(): arrived" << endl;

	Tango::DevString	argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_server_info(argin));
}
//--------------------------------------------------------
/**
 * method : 		DbGetServerListClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetServerListClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetServerListClass::execute(): arrived" << endl;

	Tango::DevString	argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_server_list(argin));
}
//--------------------------------------------------------
/**
 * method : 		DbGetServerNameListClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetServerNameListClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetServerNameListClass::execute(): arrived" << endl;

	Tango::DevString	argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_server_name_list(argin));
}
//--------------------------------------------------------
/**
 * method : 		DbImportDeviceClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbImportDeviceClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbImportDeviceClass::execute(): arrived" << endl;

	Tango::DevString	argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_import_device(argin));
}
//--------------------------------------------------------
/**
 * method : 		DbImportEventClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbImportEventClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbImportEventClass::execute(): arrived" << endl;

	Tango::DevString	argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_import_event(argin));
}
//--------------------------------------------------------
/**
 * method : 		DbInfoClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbInfoClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbInfoClass::execute(): arrived" << endl;

	
	return insert((static_cast<DataBase *>(device))->db_info());
}
//--------------------------------------------------------
/**
 * method : 		DbPutAttributeAliasClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbPutAttributeAliasClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbPutAttributeAliasClass::execute(): arrived" << endl;

	const Tango::DevVarStringArray	*argin;
	extract(in_any, argin);
	((static_cast<DataBase *>(device))->db_put_attribute_alias(argin));
	return new CORBA::Any();
}
//--------------------------------------------------------
/**
 * method : 		DbPutClassAttributePropertyClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbPutClassAttributePropertyClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbPutClassAttributePropertyClass::execute(): arrived" << endl;

	const Tango::DevVarStringArray	*argin;
	extract(in_any, argin);
	((static_cast<DataBase *>(device))->db_put_class_attribute_property(argin));
	return new CORBA::Any();
}
//--------------------------------------------------------
/**
 * method : 		DbPutClassAttributeProperty2Class::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbPutClassAttributeProperty2Class::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbPutClassAttributeProperty2Class::execute(): arrived" << endl;

	const Tango::DevVarStringArray	*argin;
	extract(in_any, argin);
	((static_cast<DataBase *>(device))->db_put_class_attribute_property2(argin));
	return new CORBA::Any();
}
//--------------------------------------------------------
/**
 * method : 		DbPutClassPropertyClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbPutClassPropertyClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbPutClassPropertyClass::execute(): arrived" << endl;

	const Tango::DevVarStringArray	*argin;
	extract(in_any, argin);
	((static_cast<DataBase *>(device))->db_put_class_property(argin));
	return new CORBA::Any();
}
//--------------------------------------------------------
/**
 * method : 		DbPutDeviceAliasClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbPutDeviceAliasClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbPutDeviceAliasClass::execute(): arrived" << endl;

	const Tango::DevVarStringArray	*argin;
	extract(in_any, argin);
	((static_cast<DataBase *>(device))->db_put_device_alias(argin));
	return new CORBA::Any();
}
//--------------------------------------------------------
/**
 * method : 		DbPutDeviceAttributePropertyClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbPutDeviceAttributePropertyClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbPutDeviceAttributePropertyClass::execute(): arrived" << endl;

	const Tango::DevVarStringArray	*argin;
	extract(in_any, argin);
	((static_cast<DataBase *>(device))->db_put_device_attribute_property(argin));
	return new CORBA::Any();
}
//--------------------------------------------------------
/**
 * method : 		DbPutDeviceAttributeProperty2Class::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbPutDeviceAttributeProperty2Class::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbPutDeviceAttributeProperty2Class::execute(): arrived" << endl;

	const Tango::DevVarStringArray	*argin;
	extract(in_any, argin);
	((static_cast<DataBase *>(device))->db_put_device_attribute_property2(argin));
	return new CORBA::Any();
}
//--------------------------------------------------------
/**
 * method : 		DbPutDevicePropertyClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbPutDevicePropertyClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbPutDevicePropertyClass::execute(): arrived" << endl;

	const Tango::DevVarStringArray	*argin;
	extract(in_any, argin);
	((static_cast<DataBase *>(device))->db_put_device_property(argin));
	return new CORBA::Any();
}
//--------------------------------------------------------
/**
 * method : 		DbPutPropertyClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbPutPropertyClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbPutPropertyClass::execute(): arrived" << endl;

	const Tango::DevVarStringArray	*argin;
	extract(in_any, argin);
	((static_cast<DataBase *>(device))->db_put_property(argin));
	return new CORBA::Any();
}
//--------------------------------------------------------
/**
 * method : 		DbPutServerInfoClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbPutServerInfoClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbPutServerInfoClass::execute(): arrived" << endl;

	const Tango::DevVarStringArray	*argin;
	extract(in_any, argin);
	((static_cast<DataBase *>(device))->db_put_server_info(argin));
	return new CORBA::Any();
}
//--------------------------------------------------------
/**
 * method : 		DbUnExportDeviceClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbUnExportDeviceClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbUnExportDeviceClass::execute(): arrived" << endl;

	Tango::DevString	argin;
	extract(in_any, argin);
	((static_cast<DataBase *>(device))->db_un_export_device(argin));
	return new CORBA::Any();
}
//--------------------------------------------------------
/**
 * method : 		DbUnExportEventClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbUnExportEventClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbUnExportEventClass::execute(): arrived" << endl;

	Tango::DevString	argin;
	extract(in_any, argin);
	((static_cast<DataBase *>(device))->db_un_export_event(argin));
	return new CORBA::Any();
}
//--------------------------------------------------------
/**
 * method : 		DbUnExportServerClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbUnExportServerClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbUnExportServerClass::execute(): arrived" << endl;

	Tango::DevString	argin;
	extract(in_any, argin);
	((static_cast<DataBase *>(device))->db_un_export_server(argin));
	return new CORBA::Any();
}
//--------------------------------------------------------
/**
 * method : 		ResetTimingValuesClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *ResetTimingValuesClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "ResetTimingValuesClass::execute(): arrived" << endl;

	
	((static_cast<DataBase *>(device))->reset_timing_values());
	return new CORBA::Any();
}
//--------------------------------------------------------
/**
 * method : 		DbGetDataForServerCacheClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbGetDataForServerCacheClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbGetDataForServerCacheClass::execute(): arrived" << endl;

	const Tango::DevVarStringArray	*argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_get_data_for_server_cache(argin));
}
//--------------------------------------------------------
/**
 * method : 		DbDeleteAllDeviceAttributePropertyClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbDeleteAllDeviceAttributePropertyClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbDeleteAllDeviceAttributePropertyClass::execute(): arrived" << endl;

	const Tango::DevVarStringArray	*argin;
	extract(in_any, argin);
	((static_cast<DataBase *>(device))->db_delete_all_device_attribute_property(argin));
	return new CORBA::Any();
}
//--------------------------------------------------------
/**
 * method : 		DbMySqlSelectClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DbMySqlSelectClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "DbMySqlSelectClass::execute(): arrived" << endl;

	Tango::DevString	argin;
	extract(in_any, argin);
	return insert((static_cast<DataBase *>(device))->db_my_sql_select(argin));
}




//===================================================================
//	Properties management
//===================================================================

//--------------------------------------------------------
/**
 * method : 		DataBaseClass::get_class_property
 * description : 	Get the class property for specified name.
 *
 * @param	name  The property name
 */
//--------------------------------------------------------
Tango::DbDatum DataBaseClass::get_class_property(string &prop_name)
{
	for (unsigned int i=0 ; i<cl_prop.size() ; i++)
		if (cl_prop[i].name == prop_name)
			return cl_prop[i];
	//	if not found, returns  an empty DbDatum
	return Tango::DbDatum(prop_name);
}


//--------------------------------------------------------
/**
 *	Method      : DataBase::DataBaseClass::get_default_device_property()()
 *	Description : Return the default value for device property.
 */
//--------------------------------------------------------
Tango::DbDatum DataBaseClass::get_default_device_property(string &prop_name)
{
	for (unsigned int i=0 ; i<dev_def_prop.size() ; i++)
		if (dev_def_prop[i].name == prop_name)
			return dev_def_prop[i];
	//	if not found, return  an empty DbDatum
	return Tango::DbDatum(prop_name);
}


//--------------------------------------------------------
/**
 *	Method      : DataBase::DataBaseClass::get_default_class_property()()
 *	Description : Return the default value for class property.
 */
//--------------------------------------------------------
Tango::DbDatum DataBaseClass::get_default_class_property(string &prop_name)
{
	for (unsigned int i=0 ; i<cl_def_prop.size() ; i++)
		if (cl_def_prop[i].name == prop_name)
			return cl_def_prop[i];
	//	if not found, return  an empty DbDatum
	return Tango::DbDatum(prop_name);
}


//--------------------------------------------------------
/**
 *	Method      : DataBase::DataBaseClass::get_class_property()
 *	Description : //	Add your own code to initialize
 */
//--------------------------------------------------------
void DataBaseClass::get_class_property()
{
}


//--------------------------------------------------------
/**
 *	Method      : DataBase::DataBaseClass::set_default_property()
 *	Description : Set default property (class and device) for wizard.
 *	              For each property, add to wizard property name and description.
 *	              If default value has been set, add it to wizard property and.
 *	              store it in a DbDatum.
 */
//--------------------------------------------------------
void DataBaseClass::set_default_property()
{
	string	prop_name;
	string	prop_desc;
	string	prop_def;
	vector<string>	vect_data;
	
	//	Set Default Class Properties

	//	Set Default Device Properties
}


//--------------------------------------------------------
/**
 *	Method      : DataBase::DataBaseClass::write_class_property()
 *	Description : Set class description fields as property in database
 */
//--------------------------------------------------------
void DataBaseClass::write_class_property()
{
	//	First time, check if database used
	if (Tango::Util::_UseDb == false)
		return;

	Tango::DbData	data;
	string	classname = get_name();
	string	header;
	string::size_type	start, end;

	//	Put title
	Tango::DbDatum	title("ProjectTitle");
	string	str_title("TANGO");
	title << str_title;
	data.push_back(title);

	//	Put Description
	Tango::DbDatum	description("Description");
	vector<string>	str_desc;
	str_desc.push_back("This class manage the TANGO database.");
	description << str_desc;
	data.push_back(description);
		
	//	put cvs or svn location
	string	filename("DataBase");
	filename += "Class.cpp";
	
	// check for cvs information
	string	src_path(CvsPath);
	start = src_path.find("/");
	if (start!=string::npos)
	{
		end   = src_path.find(filename);
		if (end>start)
		{
			string	strloc = src_path.substr(start, end-start);
			//	Check if specific repository
			start = strloc.find("/cvsroot/");
			if (start!=string::npos && start>0)
			{
				string	repository = strloc.substr(0, start);
				if (repository.find("/segfs/")!=string::npos)
					strloc = "ESRF:" + strloc.substr(start, strloc.length()-start);
			}
			Tango::DbDatum	cvs_loc("cvs_location");
			cvs_loc << strloc;
			data.push_back(cvs_loc);
		}
	}
	// check for svn information
	else
	{
		string	src_path(SvnPath);
		start = src_path.find("://");
		if (start!=string::npos)
		{
			end = src_path.find(filename);
			if (end>start)
			{
				header = "$HeadURL: ";
				start = header.length();
				string	strloc = src_path.substr(start, (end-start));
				
				Tango::DbDatum	svn_loc("svn_location");
				svn_loc << strloc;
				data.push_back(svn_loc);
			}
		}
	}

	//	Get CVS or SVN revision tag
	
	// CVS tag
	string	tagname(TagName);
	header = "$Name: ";
	start = header.length();
	string	endstr(" $");
	
	end   = tagname.find(endstr);
	if (end!=string::npos && end>start)
	{
		string	strtag = tagname.substr(start, end-start);
		Tango::DbDatum	cvs_tag("cvs_tag");
		cvs_tag << strtag;
		data.push_back(cvs_tag);
	}
	
	// SVN tag
	string	svnpath(SvnPath);
	header = "$HeadURL: ";
	start = header.length();
	
	end   = svnpath.find(endstr);
	if (end!=string::npos && end>start)
	{
		string	strloc = svnpath.substr(start, end-start);
		
		string tagstr ("/tags/");
		start = strloc.find(tagstr);
		if ( start!=string::npos )
		{
			start = start + tagstr.length();
			end   = strloc.find(filename);
			string	strtag = strloc.substr(start, end-start-1);
			
			Tango::DbDatum	svn_tag("svn_tag");
			svn_tag << strtag;
			data.push_back(svn_tag);
		}
	}

	//	Get URL location
	string	httpServ(HttpServer);
	if (httpServ.length()>0)
	{
		Tango::DbDatum	db_doc_url("doc_url");
		db_doc_url << httpServ;
		data.push_back(db_doc_url);
	}

	//  Put inheritance
	Tango::DbDatum	inher_datum("InheritedFrom");
	vector<string> inheritance;
	inheritance.push_back("Device_4Impl");
	inher_datum << inheritance;
	data.push_back(inher_datum);

	//	Call database and and values
	get_db_class()->put_property(data);
}




//===================================================================
//	Factory methods
//===================================================================


//--------------------------------------------------------
/**
 * method : 		DataBaseClass::device_factory
 * description : 	Create the device object(s)
 *                  and store them in the device list
 *
 * @param	*devlist_ptr	The device name list
 */
//--------------------------------------------------------
void DataBaseClass::device_factory(const Tango::DevVarStringArray *devlist_ptr)
{

	device_list.push_back(new DataBase(this, DataBase::db_name.c_str(),
                                    	"TANGO database device server"));
	export_device(device_list[0],"database");
}


//--------------------------------------------------------
/**
 *	Method      : DataBase::DataBaseClass::attribute_factory()
 *	Description : Create the attribute object(s)
 *	              and store them in the attribute list
 */
//--------------------------------------------------------
void DataBaseClass::attribute_factory(vector<Tango::Attr *> &att_list)
{
	/*----- PROTECTED REGION ID(DataBase::Class::attribute_factory_before) ENABLED START -----*/

	//	Add your own code

	/*----- PROTECTED REGION END -----*/	//	DataBase::Class::attribute_factory_before


	//	Attribute : StoredProcedureRelease
	StoredProcedureReleaseAttrib	*storedprocedurerelease = new StoredProcedureReleaseAttrib();
	Tango::UserDefaultAttrProp	storedprocedurerelease_prop;
	//	description	not set for	StoredProcedureRelease
	//	label	not set for	StoredProcedureRelease
	//	unit	not set for	StoredProcedureRelease
	//	standard_unit	not set for	StoredProcedureRelease
	//	display_unit	not set for	StoredProcedureRelease
	//	format	not set for	StoredProcedureRelease
	//	max_value	not set for	StoredProcedureRelease
	//	min_value	not set for	StoredProcedureRelease
	//	max_alarm	not set for	StoredProcedureRelease
	//	min_alarm	not set for	StoredProcedureRelease
	//	max_warning	not set for	StoredProcedureRelease
	//	min_warning	not set for	StoredProcedureRelease
	//	delta_t	not set for	StoredProcedureRelease
	//	delta_val	not set for	StoredProcedureRelease
	storedprocedurerelease->set_default_properties(storedprocedurerelease_prop);
	//	Not Polled
	storedprocedurerelease->set_disp_level(Tango::OPERATOR);
	//	Not memorized

	//	StoredProcedureRelease does not fire change event
	//	StoredProcedureRelease does not fire archive event
	//	StoredProcedureRelease does not fire data_ready event
	att_list.push_back(storedprocedurerelease);

	//	Attribute : Timing_average
	Timing_averageAttrib	*timing_average = new Timing_averageAttrib();
	Tango::UserDefaultAttrProp	timing_average_prop;
	//	description	not set for	Timing_average
	//	label	not set for	Timing_average
	//	unit	not set for	Timing_average
	//	standard_unit	not set for	Timing_average
	//	display_unit	not set for	Timing_average
	//	format	not set for	Timing_average
	//	max_value	not set for	Timing_average
	//	min_value	not set for	Timing_average
	//	max_alarm	not set for	Timing_average
	//	min_alarm	not set for	Timing_average
	//	max_warning	not set for	Timing_average
	//	min_warning	not set for	Timing_average
	//	delta_t	not set for	Timing_average
	//	delta_val	not set for	Timing_average
	timing_average->set_default_properties(timing_average_prop);
	//	Not Polled
	timing_average->set_disp_level(Tango::OPERATOR);
	//	Not memorized

	//	Timing_average does not fire change event
	//	Timing_average does not fire archive event
	//	Timing_average does not fire data_ready event
	att_list.push_back(timing_average);

	//	Attribute : Timing_minimum
	Timing_minimumAttrib	*timing_minimum = new Timing_minimumAttrib();
	Tango::UserDefaultAttrProp	timing_minimum_prop;
	//	description	not set for	Timing_minimum
	//	label	not set for	Timing_minimum
	//	unit	not set for	Timing_minimum
	//	standard_unit	not set for	Timing_minimum
	//	display_unit	not set for	Timing_minimum
	//	format	not set for	Timing_minimum
	//	max_value	not set for	Timing_minimum
	//	min_value	not set for	Timing_minimum
	//	max_alarm	not set for	Timing_minimum
	//	min_alarm	not set for	Timing_minimum
	//	max_warning	not set for	Timing_minimum
	//	min_warning	not set for	Timing_minimum
	//	delta_t	not set for	Timing_minimum
	//	delta_val	not set for	Timing_minimum
	timing_minimum->set_default_properties(timing_minimum_prop);
	//	Not Polled
	timing_minimum->set_disp_level(Tango::OPERATOR);
	//	Not memorized

	//	Timing_minimum does not fire change event
	//	Timing_minimum does not fire archive event
	//	Timing_minimum does not fire data_ready event
	att_list.push_back(timing_minimum);

	//	Attribute : Timing_maximum
	Timing_maximumAttrib	*timing_maximum = new Timing_maximumAttrib();
	Tango::UserDefaultAttrProp	timing_maximum_prop;
	//	description	not set for	Timing_maximum
	//	label	not set for	Timing_maximum
	//	unit	not set for	Timing_maximum
	//	standard_unit	not set for	Timing_maximum
	//	display_unit	not set for	Timing_maximum
	//	format	not set for	Timing_maximum
	//	max_value	not set for	Timing_maximum
	//	min_value	not set for	Timing_maximum
	//	max_alarm	not set for	Timing_maximum
	//	min_alarm	not set for	Timing_maximum
	//	max_warning	not set for	Timing_maximum
	//	min_warning	not set for	Timing_maximum
	//	delta_t	not set for	Timing_maximum
	//	delta_val	not set for	Timing_maximum
	timing_maximum->set_default_properties(timing_maximum_prop);
	//	Not Polled
	timing_maximum->set_disp_level(Tango::OPERATOR);
	//	Not memorized

	//	Timing_maximum does not fire change event
	//	Timing_maximum does not fire archive event
	//	Timing_maximum does not fire data_ready event
	att_list.push_back(timing_maximum);

	//	Attribute : Timing_calls
	Timing_callsAttrib	*timing_calls = new Timing_callsAttrib();
	Tango::UserDefaultAttrProp	timing_calls_prop;
	//	description	not set for	Timing_calls
	//	label	not set for	Timing_calls
	//	unit	not set for	Timing_calls
	//	standard_unit	not set for	Timing_calls
	//	display_unit	not set for	Timing_calls
	//	format	not set for	Timing_calls
	//	max_value	not set for	Timing_calls
	//	min_value	not set for	Timing_calls
	//	max_alarm	not set for	Timing_calls
	//	min_alarm	not set for	Timing_calls
	//	max_warning	not set for	Timing_calls
	//	min_warning	not set for	Timing_calls
	//	delta_t	not set for	Timing_calls
	//	delta_val	not set for	Timing_calls
	timing_calls->set_default_properties(timing_calls_prop);
	//	Not Polled
	timing_calls->set_disp_level(Tango::OPERATOR);
	//	Not memorized

	//	Timing_calls does not fire change event
	//	Timing_calls does not fire archive event
	//	Timing_calls does not fire data_ready event
	att_list.push_back(timing_calls);

	//	Attribute : Timing_index
	Timing_indexAttrib	*timing_index = new Timing_indexAttrib();
	Tango::UserDefaultAttrProp	timing_index_prop;
	//	description	not set for	Timing_index
	//	label	not set for	Timing_index
	//	unit	not set for	Timing_index
	//	standard_unit	not set for	Timing_index
	//	display_unit	not set for	Timing_index
	//	format	not set for	Timing_index
	//	max_value	not set for	Timing_index
	//	min_value	not set for	Timing_index
	//	max_alarm	not set for	Timing_index
	//	min_alarm	not set for	Timing_index
	//	max_warning	not set for	Timing_index
	//	min_warning	not set for	Timing_index
	//	delta_t	not set for	Timing_index
	//	delta_val	not set for	Timing_index
	timing_index->set_default_properties(timing_index_prop);
	//	Not Polled
	timing_index->set_disp_level(Tango::OPERATOR);
	//	Not memorized

	//	Timing_index does not fire change event
	//	Timing_index does not fire archive event
	//	Timing_index does not fire data_ready event
	att_list.push_back(timing_index);

	//	Attribute : Timing_info
	Timing_infoAttrib	*timing_info = new Timing_infoAttrib();
	Tango::UserDefaultAttrProp	timing_info_prop;
	//	description	not set for	Timing_info
	//	label	not set for	Timing_info
	//	unit	not set for	Timing_info
	//	standard_unit	not set for	Timing_info
	//	display_unit	not set for	Timing_info
	//	format	not set for	Timing_info
	//	max_value	not set for	Timing_info
	//	min_value	not set for	Timing_info
	//	max_alarm	not set for	Timing_info
	//	min_alarm	not set for	Timing_info
	//	max_warning	not set for	Timing_info
	//	min_warning	not set for	Timing_info
	//	delta_t	not set for	Timing_info
	//	delta_val	not set for	Timing_info
	timing_info->set_default_properties(timing_info_prop);
	//	Not Polled
	timing_info->set_disp_level(Tango::OPERATOR);
	//	Not memorized

	//	Timing_info does not fire change event
	//	Timing_info does not fire archive event
	//	Timing_info does not fire data_ready event
	att_list.push_back(timing_info);


	//	Create a list of static attributes
	create_static_attribute_list(get_class_attr()->get_attr_list());

	/*----- PROTECTED REGION ID(DataBase::Class::attribute_factory_after) ENABLED START -----*/

	//	Add your own code

	/*----- PROTECTED REGION END -----*/	//	DataBase::Class::attribute_factory_after

}


//--------------------------------------------------------
/**
 *	Method      : DataBase::DataBaseClass::command_factory()
 *	Description : Create the command object(s)
 *	              and store them in the command list
 */
//--------------------------------------------------------
void DataBaseClass::command_factory()
{
	/*----- PROTECTED REGION ID(DataBase::Class::command_factory_before) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::Class::command_factory_before

	DbAddDeviceClass	*pDbAddDeviceCmd =
		new DbAddDeviceClass("DbAddDevice",
			Tango::DEVVAR_STRINGARRAY, Tango::DEV_VOID,
			"",
			"",
			Tango::OPERATOR);
	command_list.push_back(pDbAddDeviceCmd);
	DbAddServerClass	*pDbAddServerCmd =
		new DbAddServerClass("DbAddServer",
			Tango::DEVVAR_STRINGARRAY, Tango::DEV_VOID,
			"",
			"",
			Tango::OPERATOR);
	command_list.push_back(pDbAddServerCmd);
	DbDeleteAttributeAliasClass	*pDbDeleteAttributeAliasCmd =
		new DbDeleteAttributeAliasClass("DbDeleteAttributeAlias",
			Tango::DEV_STRING, Tango::DEV_VOID,
			"alias name.",
			"",
			Tango::OPERATOR);
	command_list.push_back(pDbDeleteAttributeAliasCmd);
	DbDeleteClassAttributeClass	*pDbDeleteClassAttributeCmd =
		new DbDeleteClassAttributeClass("DbDeleteClassAttribute",
			Tango::DEVVAR_STRINGARRAY, Tango::DEV_VOID,
			"device",
			"attribute",
			Tango::OPERATOR);
	command_list.push_back(pDbDeleteClassAttributeCmd);
	DbDeleteClassAttributePropertyClass	*pDbDeleteClassAttributePropertyCmd =
		new DbDeleteClassAttributePropertyClass("DbDeleteClassAttributeProperty",
			Tango::DEVVAR_STRINGARRAY, Tango::DEV_VOID,
			"device",
			"attribute",
			Tango::OPERATOR);
	command_list.push_back(pDbDeleteClassAttributePropertyCmd);
	DbDeleteClassPropertyClass	*pDbDeleteClassPropertyCmd =
		new DbDeleteClassPropertyClass("DbDeleteClassProperty",
			Tango::DEVVAR_STRINGARRAY, Tango::DEV_VOID,
			"",
			"",
			Tango::OPERATOR);
	command_list.push_back(pDbDeleteClassPropertyCmd);
	DbDeleteDeviceClass	*pDbDeleteDeviceCmd =
		new DbDeleteDeviceClass("DbDeleteDevice",
			Tango::DEV_STRING, Tango::DEV_VOID,
			"device name",
			"",
			Tango::OPERATOR);
	command_list.push_back(pDbDeleteDeviceCmd);
	DbDeleteDeviceAliasClass	*pDbDeleteDeviceAliasCmd =
		new DbDeleteDeviceAliasClass("DbDeleteDeviceAlias",
			Tango::DEV_STRING, Tango::DEV_VOID,
			"alias name",
			"",
			Tango::OPERATOR);
	command_list.push_back(pDbDeleteDeviceAliasCmd);
	DbDeleteDeviceAttributeClass	*pDbDeleteDeviceAttributeCmd =
		new DbDeleteDeviceAttributeClass("DbDeleteDeviceAttribute",
			Tango::DEVVAR_STRINGARRAY, Tango::DEV_VOID,
			"device",
			"attribute",
			Tango::OPERATOR);
	command_list.push_back(pDbDeleteDeviceAttributeCmd);
	DbDeleteDeviceAttributePropertyClass	*pDbDeleteDeviceAttributePropertyCmd =
		new DbDeleteDeviceAttributePropertyClass("DbDeleteDeviceAttributeProperty",
			Tango::DEVVAR_STRINGARRAY, Tango::DEV_VOID,
			"device",
			"attribute",
			Tango::OPERATOR);
	command_list.push_back(pDbDeleteDeviceAttributePropertyCmd);
	DbDeleteDevicePropertyClass	*pDbDeleteDevicePropertyCmd =
		new DbDeleteDevicePropertyClass("DbDeleteDeviceProperty",
			Tango::DEVVAR_STRINGARRAY, Tango::DEV_VOID,
			"",
			"",
			Tango::OPERATOR);
	command_list.push_back(pDbDeleteDevicePropertyCmd);
	DbDeletePropertyClass	*pDbDeletePropertyCmd =
		new DbDeletePropertyClass("DbDeleteProperty",
			Tango::DEVVAR_STRINGARRAY, Tango::DEV_VOID,
			"",
			"",
			Tango::OPERATOR);
	command_list.push_back(pDbDeletePropertyCmd);
	DbDeleteServerClass	*pDbDeleteServerCmd =
		new DbDeleteServerClass("DbDeleteServer",
			Tango::DEV_STRING, Tango::DEV_VOID,
			"server name",
			"",
			Tango::OPERATOR);
	command_list.push_back(pDbDeleteServerCmd);
	DbDeleteServerInfoClass	*pDbDeleteServerInfoCmd =
		new DbDeleteServerInfoClass("DbDeleteServerInfo",
			Tango::DEV_STRING, Tango::DEV_VOID,
			"server name",
			"",
			Tango::OPERATOR);
	command_list.push_back(pDbDeleteServerInfoCmd);
	DbExportDeviceClass	*pDbExportDeviceCmd =
		new DbExportDeviceClass("DbExportDevice",
			Tango::DEVVAR_STRINGARRAY, Tango::DEV_VOID,
			"",
			"",
			Tango::OPERATOR);
	command_list.push_back(pDbExportDeviceCmd);
	DbExportEventClass	*pDbExportEventCmd =
		new DbExportEventClass("DbExportEvent",
			Tango::DEVVAR_STRINGARRAY, Tango::DEV_VOID,
			"event channel or factory",
			"IOR",
			Tango::OPERATOR);
	command_list.push_back(pDbExportEventCmd);
	DbGetAliasDeviceClass	*pDbGetAliasDeviceCmd =
		new DbGetAliasDeviceClass("DbGetAliasDevice",
			Tango::DEV_STRING, Tango::DEV_STRING,
			"specified alias.",
			"Device name found.",
			Tango::OPERATOR);
	command_list.push_back(pDbGetAliasDeviceCmd);
	DbGetAttributeAliasClass	*pDbGetAttributeAliasCmd =
		new DbGetAttributeAliasClass("DbGetAttributeAlias",
			Tango::DEV_STRING, Tango::DEV_STRING,
			"alias",
			"attribute name",
			Tango::OPERATOR);
	command_list.push_back(pDbGetAttributeAliasCmd);
	DbGetAttributeAliasListClass	*pDbGetAttributeAliasListCmd =
		new DbGetAttributeAliasListClass("DbGetAttributeAliasList",
			Tango::DEV_STRING, Tango::DEVVAR_STRINGARRAY,
			"attribute alias",
			"attribute name",
			Tango::OPERATOR);
	command_list.push_back(pDbGetAttributeAliasListCmd);
	DbGetClassAttributeListClass	*pDbGetClassAttributeListCmd =
		new DbGetClassAttributeListClass("DbGetClassAttributeList",
			Tango::DEVVAR_STRINGARRAY, Tango::DEVVAR_STRINGARRAY,
			"",
			"",
			Tango::OPERATOR);
	command_list.push_back(pDbGetClassAttributeListCmd);
	DbGetClassAttributePropertyClass	*pDbGetClassAttributePropertyCmd =
		new DbGetClassAttributePropertyClass("DbGetClassAttributeProperty",
			Tango::DEVVAR_STRINGARRAY, Tango::DEVVAR_STRINGARRAY,
			"",
			"",
			Tango::OPERATOR);
	command_list.push_back(pDbGetClassAttributePropertyCmd);
	DbGetClassAttributeProperty2Class	*pDbGetClassAttributeProperty2Cmd =
		new DbGetClassAttributeProperty2Class("DbGetClassAttributeProperty2",
			Tango::DEVVAR_STRINGARRAY, Tango::DEVVAR_STRINGARRAY,
			"",
			"",
			Tango::OPERATOR);
	command_list.push_back(pDbGetClassAttributeProperty2Cmd);
	DbGetClassAttributePropertyHistClass	*pDbGetClassAttributePropertyHistCmd =
		new DbGetClassAttributePropertyHistClass("DbGetClassAttributePropertyHist",
			Tango::DEVVAR_STRINGARRAY, Tango::DEVVAR_STRINGARRAY,
			"",
			"",
			Tango::OPERATOR);
	command_list.push_back(pDbGetClassAttributePropertyHistCmd);
	DbGetClassForDeviceClass	*pDbGetClassForDeviceCmd =
		new DbGetClassForDeviceClass("DbGetClassForDevice",
			Tango::DEV_STRING, Tango::DEV_STRING,
			"Device name",
			"Class off the specified device",
			Tango::OPERATOR);
	command_list.push_back(pDbGetClassForDeviceCmd);
	DbGetClassInheritanceForDeviceClass	*pDbGetClassInheritanceForDeviceCmd =
		new DbGetClassInheritanceForDeviceClass("DbGetClassInheritanceForDevice",
			Tango::DEV_STRING, Tango::DEVVAR_STRINGARRAY,
			"Device name",
			"Classes off the specified device.\n[0] - is the class of the device.\n[1] - is the class from the device class is inherited.\n........and so on",
			Tango::OPERATOR);
	command_list.push_back(pDbGetClassInheritanceForDeviceCmd);
	DbGetClassListClass	*pDbGetClassListCmd =
		new DbGetClassListClass("DbGetClassList",
			Tango::DEV_STRING, Tango::DEVVAR_STRINGARRAY,
			"",
			"",
			Tango::OPERATOR);
	command_list.push_back(pDbGetClassListCmd);
	DbGetClassPropertyClass	*pDbGetClassPropertyCmd =
		new DbGetClassPropertyClass("DbGetClassProperty",
			Tango::DEVVAR_STRINGARRAY, Tango::DEVVAR_STRINGARRAY,
			"",
			"",
			Tango::OPERATOR);
	command_list.push_back(pDbGetClassPropertyCmd);
	DbGetClassPropertyHistClass	*pDbGetClassPropertyHistCmd =
		new DbGetClassPropertyHistClass("DbGetClassPropertyHist",
			Tango::DEVVAR_STRINGARRAY, Tango::DEVVAR_STRINGARRAY,
			"",
			"",
			Tango::OPERATOR);
	command_list.push_back(pDbGetClassPropertyHistCmd);
	DbGetClassPropertyListClass	*pDbGetClassPropertyListCmd =
		new DbGetClassPropertyListClass("DbGetClassPropertyList",
			Tango::DEV_STRING, Tango::DEVVAR_STRINGARRAY,
			"",
			"",
			Tango::OPERATOR);
	command_list.push_back(pDbGetClassPropertyListCmd);
	DbGetDeviceAliasClass	*pDbGetDeviceAliasCmd =
		new DbGetDeviceAliasClass("DbGetDeviceAlias",
			Tango::DEV_STRING, Tango::DEV_STRING,
			"The device name",
			"The alias found",
			Tango::OPERATOR);
	command_list.push_back(pDbGetDeviceAliasCmd);
	DbGetDeviceAliasListClass	*pDbGetDeviceAliasListCmd =
		new DbGetDeviceAliasListClass("DbGetDeviceAliasList",
			Tango::DEV_STRING, Tango::DEVVAR_STRINGARRAY,
			"",
			"",
			Tango::OPERATOR);
	command_list.push_back(pDbGetDeviceAliasListCmd);
	DbGetDeviceAttributeListClass	*pDbGetDeviceAttributeListCmd =
		new DbGetDeviceAttributeListClass("DbGetDeviceAttributeList",
			Tango::DEVVAR_STRINGARRAY, Tango::DEVVAR_STRINGARRAY,
			"device name",
			"attribute wildcard",
			Tango::OPERATOR);
	command_list.push_back(pDbGetDeviceAttributeListCmd);
	DbGetDeviceAttributePropertyClass	*pDbGetDeviceAttributePropertyCmd =
		new DbGetDeviceAttributePropertyClass("DbGetDeviceAttributeProperty",
			Tango::DEVVAR_STRINGARRAY, Tango::DEVVAR_STRINGARRAY,
			"",
			"",
			Tango::OPERATOR);
	command_list.push_back(pDbGetDeviceAttributePropertyCmd);
	DbGetDeviceAttributeProperty2Class	*pDbGetDeviceAttributeProperty2Cmd =
		new DbGetDeviceAttributeProperty2Class("DbGetDeviceAttributeProperty2",
			Tango::DEVVAR_STRINGARRAY, Tango::DEVVAR_STRINGARRAY,
			"",
			"",
			Tango::OPERATOR);
	command_list.push_back(pDbGetDeviceAttributeProperty2Cmd);
	DbGetDeviceAttributePropertyHistClass	*pDbGetDeviceAttributePropertyHistCmd =
		new DbGetDeviceAttributePropertyHistClass("DbGetDeviceAttributePropertyHist",
			Tango::DEVVAR_STRINGARRAY, Tango::DEVVAR_STRINGARRAY,
			"",
			"",
			Tango::OPERATOR);
	command_list.push_back(pDbGetDeviceAttributePropertyHistCmd);
	DbGetDeviceClassListClass	*pDbGetDeviceClassListCmd =
		new DbGetDeviceClassListClass("DbGetDeviceClassList",
			Tango::DEV_STRING, Tango::DEVVAR_STRINGARRAY,
			"",
			"",
			Tango::OPERATOR);
	command_list.push_back(pDbGetDeviceClassListCmd);
	DbGetDeviceDomainListClass	*pDbGetDeviceDomainListCmd =
		new DbGetDeviceDomainListClass("DbGetDeviceDomainList",
			Tango::DEV_STRING, Tango::DEVVAR_STRINGARRAY,
			"",
			"",
			Tango::OPERATOR);
	command_list.push_back(pDbGetDeviceDomainListCmd);
	DbGetDeviceExportedListClass	*pDbGetDeviceExportedListCmd =
		new DbGetDeviceExportedListClass("DbGetDeviceExportedList",
			Tango::DEV_STRING, Tango::DEVVAR_STRINGARRAY,
			"filter",
			"list of exported devices",
			Tango::OPERATOR);
	command_list.push_back(pDbGetDeviceExportedListCmd);
	DbGetDeviceFamilyListClass	*pDbGetDeviceFamilyListCmd =
		new DbGetDeviceFamilyListClass("DbGetDeviceFamilyList",
			Tango::DEV_STRING, Tango::DEVVAR_STRINGARRAY,
			"",
			"",
			Tango::OPERATOR);
	command_list.push_back(pDbGetDeviceFamilyListCmd);
	DbGetDeviceInfoClass	*pDbGetDeviceInfoCmd =
		new DbGetDeviceInfoClass("DbGetDeviceInfo",
			Tango::DEV_STRING, Tango::DEVVAR_LONGSTRINGARRAY,
			"Device name",
			"Info from DbImportDevice and started/stopped dates.",
			Tango::OPERATOR);
	command_list.push_back(pDbGetDeviceInfoCmd);
	DbGetDeviceListClass	*pDbGetDeviceListCmd =
		new DbGetDeviceListClass("DbGetDeviceList",
			Tango::DEVVAR_STRINGARRAY, Tango::DEVVAR_STRINGARRAY,
			"argin[0] : server name\nargin[1] : class name",
			"The list of devices for specified server and class.",
			Tango::OPERATOR);
	command_list.push_back(pDbGetDeviceListCmd);
	DbGetDeviceWideListClass	*pDbGetDeviceWideListCmd =
		new DbGetDeviceWideListClass("DbGetDeviceWideList",
			Tango::DEV_STRING, Tango::DEVVAR_STRINGARRAY,
			"filter",
			"list of exported devices",
			Tango::OPERATOR);
	command_list.push_back(pDbGetDeviceWideListCmd);
	DbGetDeviceMemberListClass	*pDbGetDeviceMemberListCmd =
		new DbGetDeviceMemberListClass("DbGetDeviceMemberList",
			Tango::DEV_STRING, Tango::DEVVAR_STRINGARRAY,
			"",
			"",
			Tango::OPERATOR);
	command_list.push_back(pDbGetDeviceMemberListCmd);
	DbGetDevicePropertyClass	*pDbGetDevicePropertyCmd =
		new DbGetDevicePropertyClass("DbGetDeviceProperty",
			Tango::DEVVAR_STRINGARRAY, Tango::DEVVAR_STRINGARRAY,
			"",
			"",
			Tango::OPERATOR);
	command_list.push_back(pDbGetDevicePropertyCmd);
	DbGetDevicePropertyHistClass	*pDbGetDevicePropertyHistCmd =
		new DbGetDevicePropertyHistClass("DbGetDevicePropertyHist",
			Tango::DEVVAR_STRINGARRAY, Tango::DEVVAR_STRINGARRAY,
			"",
			"",
			Tango::OPERATOR);
	command_list.push_back(pDbGetDevicePropertyHistCmd);
	DbGetDevicePropertyListClass	*pDbGetDevicePropertyListCmd =
		new DbGetDevicePropertyListClass("DbGetDevicePropertyList",
			Tango::DEVVAR_STRINGARRAY, Tango::DEVVAR_STRINGARRAY,
			"",
			"",
			Tango::OPERATOR);
	command_list.push_back(pDbGetDevicePropertyListCmd);
	DbGetDeviceServerClassListClass	*pDbGetDeviceServerClassListCmd =
		new DbGetDeviceServerClassListClass("DbGetDeviceServerClassList",
			Tango::DEV_STRING, Tango::DEVVAR_STRINGARRAY,
			"device server instance name",
			"list of classes for this device server",
			Tango::OPERATOR);
	command_list.push_back(pDbGetDeviceServerClassListCmd);
	DbGetExportdDeviceListForClassClass	*pDbGetExportdDeviceListForClassCmd =
		new DbGetExportdDeviceListForClassClass("DbGetExportdDeviceListForClass",
			Tango::DEV_STRING, Tango::DEVVAR_STRINGARRAY,
			"Class name",
			"Device exported list",
			Tango::OPERATOR);
	command_list.push_back(pDbGetExportdDeviceListForClassCmd);
	DbGetHostListClass	*pDbGetHostListCmd =
		new DbGetHostListClass("DbGetHostList",
			Tango::DEV_STRING, Tango::DEVVAR_STRINGARRAY,
			"",
			"",
			Tango::OPERATOR);
	command_list.push_back(pDbGetHostListCmd);
	DbGetHostServerListClass	*pDbGetHostServerListCmd =
		new DbGetHostServerListClass("DbGetHostServerList",
			Tango::DEV_STRING, Tango::DEVVAR_STRINGARRAY,
			"",
			"",
			Tango::OPERATOR);
	command_list.push_back(pDbGetHostServerListCmd);
	DbGetHostServersInfoClass	*pDbGetHostServersInfoCmd =
		new DbGetHostServersInfoClass("DbGetHostServersInfo",
			Tango::DEV_STRING, Tango::DEVVAR_STRINGARRAY,
			"host name",
			"server info for all servers running on specified host",
			Tango::OPERATOR);
	command_list.push_back(pDbGetHostServersInfoCmd);
	DbGetInstanceNameListClass	*pDbGetInstanceNameListCmd =
		new DbGetInstanceNameListClass("DbGetInstanceNameList",
			Tango::DEV_STRING, Tango::DEVVAR_STRINGARRAY,
			"server name",
			"The instance names found for specified server.",
			Tango::OPERATOR);
	command_list.push_back(pDbGetInstanceNameListCmd);
	DbGetObjectListClass	*pDbGetObjectListCmd =
		new DbGetObjectListClass("DbGetObjectList",
			Tango::DEV_STRING, Tango::DEVVAR_STRINGARRAY,
			"wild card",
			"list of object names",
			Tango::OPERATOR);
	command_list.push_back(pDbGetObjectListCmd);
	DbGetPropertyClass	*pDbGetPropertyCmd =
		new DbGetPropertyClass("DbGetProperty",
			Tango::DEVVAR_STRINGARRAY, Tango::DEVVAR_STRINGARRAY,
			"",
			"",
			Tango::OPERATOR);
	command_list.push_back(pDbGetPropertyCmd);
	DbGetPropertyHistClass	*pDbGetPropertyHistCmd =
		new DbGetPropertyHistClass("DbGetPropertyHist",
			Tango::DEVVAR_STRINGARRAY, Tango::DEVVAR_STRINGARRAY,
			"",
			"",
			Tango::OPERATOR);
	command_list.push_back(pDbGetPropertyHistCmd);
	DbGetPropertyListClass	*pDbGetPropertyListCmd =
		new DbGetPropertyListClass("DbGetPropertyList",
			Tango::DEVVAR_STRINGARRAY, Tango::DEVVAR_STRINGARRAY,
			"",
			"",
			Tango::OPERATOR);
	command_list.push_back(pDbGetPropertyListCmd);
	DbGetServerInfoClass	*pDbGetServerInfoCmd =
		new DbGetServerInfoClass("DbGetServerInfo",
			Tango::DEV_STRING, Tango::DEVVAR_STRINGARRAY,
			"server name",
			"server info",
			Tango::OPERATOR);
	command_list.push_back(pDbGetServerInfoCmd);
	DbGetServerListClass	*pDbGetServerListCmd =
		new DbGetServerListClass("DbGetServerList",
			Tango::DEV_STRING, Tango::DEVVAR_STRINGARRAY,
			"",
			"",
			Tango::OPERATOR);
	command_list.push_back(pDbGetServerListCmd);
	DbGetServerNameListClass	*pDbGetServerNameListCmd =
		new DbGetServerNameListClass("DbGetServerNameList",
			Tango::DEV_STRING, Tango::DEVVAR_STRINGARRAY,
			"wildcard for server names.",
			"server names found.",
			Tango::OPERATOR);
	command_list.push_back(pDbGetServerNameListCmd);
	DbImportDeviceClass	*pDbImportDeviceCmd =
		new DbImportDeviceClass("DbImportDevice",
			Tango::DEV_STRING, Tango::DEVVAR_LONGSTRINGARRAY,
			"",
			"",
			Tango::OPERATOR);
	command_list.push_back(pDbImportDeviceCmd);
	DbImportEventClass	*pDbImportEventCmd =
		new DbImportEventClass("DbImportEvent",
			Tango::DEV_STRING, Tango::DEVVAR_LONGSTRINGARRAY,
			"name of event channel or factory",
			"export information e.g. IOR",
			Tango::OPERATOR);
	command_list.push_back(pDbImportEventCmd);
	DbInfoClass	*pDbInfoCmd =
		new DbInfoClass("DbInfo",
			Tango::DEV_VOID, Tango::DEVVAR_STRINGARRAY,
			"",
			"",
			Tango::OPERATOR);
	command_list.push_back(pDbInfoCmd);
	DbPutAttributeAliasClass	*pDbPutAttributeAliasCmd =
		new DbPutAttributeAliasClass("DbPutAttributeAlias",
			Tango::DEVVAR_STRINGARRAY, Tango::DEV_VOID,
			"attribute name, alias",
			"",
			Tango::OPERATOR);
	command_list.push_back(pDbPutAttributeAliasCmd);
	DbPutClassAttributePropertyClass	*pDbPutClassAttributePropertyCmd =
		new DbPutClassAttributePropertyClass("DbPutClassAttributeProperty",
			Tango::DEVVAR_STRINGARRAY, Tango::DEV_VOID,
			"",
			"",
			Tango::OPERATOR);
	command_list.push_back(pDbPutClassAttributePropertyCmd);
	DbPutClassAttributeProperty2Class	*pDbPutClassAttributeProperty2Cmd =
		new DbPutClassAttributeProperty2Class("DbPutClassAttributeProperty2",
			Tango::DEVVAR_STRINGARRAY, Tango::DEV_VOID,
			"",
			"",
			Tango::OPERATOR);
	command_list.push_back(pDbPutClassAttributeProperty2Cmd);
	DbPutClassPropertyClass	*pDbPutClassPropertyCmd =
		new DbPutClassPropertyClass("DbPutClassProperty",
			Tango::DEVVAR_STRINGARRAY, Tango::DEV_VOID,
			"",
			"",
			Tango::OPERATOR);
	command_list.push_back(pDbPutClassPropertyCmd);
	DbPutDeviceAliasClass	*pDbPutDeviceAliasCmd =
		new DbPutDeviceAliasClass("DbPutDeviceAlias",
			Tango::DEVVAR_STRINGARRAY, Tango::DEV_VOID,
			"device name",
			"alias",
			Tango::OPERATOR);
	command_list.push_back(pDbPutDeviceAliasCmd);
	DbPutDeviceAttributePropertyClass	*pDbPutDeviceAttributePropertyCmd =
		new DbPutDeviceAttributePropertyClass("DbPutDeviceAttributeProperty",
			Tango::DEVVAR_STRINGARRAY, Tango::DEV_VOID,
			"",
			"",
			Tango::OPERATOR);
	command_list.push_back(pDbPutDeviceAttributePropertyCmd);
	DbPutDeviceAttributeProperty2Class	*pDbPutDeviceAttributeProperty2Cmd =
		new DbPutDeviceAttributeProperty2Class("DbPutDeviceAttributeProperty2",
			Tango::DEVVAR_STRINGARRAY, Tango::DEV_VOID,
			"",
			"",
			Tango::OPERATOR);
	command_list.push_back(pDbPutDeviceAttributeProperty2Cmd);
	DbPutDevicePropertyClass	*pDbPutDevicePropertyCmd =
		new DbPutDevicePropertyClass("DbPutDeviceProperty",
			Tango::DEVVAR_STRINGARRAY, Tango::DEV_VOID,
			"",
			"",
			Tango::OPERATOR);
	command_list.push_back(pDbPutDevicePropertyCmd);
	DbPutPropertyClass	*pDbPutPropertyCmd =
		new DbPutPropertyClass("DbPutProperty",
			Tango::DEVVAR_STRINGARRAY, Tango::DEV_VOID,
			"",
			"",
			Tango::OPERATOR);
	command_list.push_back(pDbPutPropertyCmd);
	DbPutServerInfoClass	*pDbPutServerInfoCmd =
		new DbPutServerInfoClass("DbPutServerInfo",
			Tango::DEVVAR_STRINGARRAY, Tango::DEV_VOID,
			"server info",
			"",
			Tango::OPERATOR);
	command_list.push_back(pDbPutServerInfoCmd);
	DbUnExportDeviceClass	*pDbUnExportDeviceCmd =
		new DbUnExportDeviceClass("DbUnExportDevice",
			Tango::DEV_STRING, Tango::DEV_VOID,
			"",
			"",
			Tango::OPERATOR);
	command_list.push_back(pDbUnExportDeviceCmd);
	DbUnExportEventClass	*pDbUnExportEventCmd =
		new DbUnExportEventClass("DbUnExportEvent",
			Tango::DEV_STRING, Tango::DEV_VOID,
			"name of event channel or factory to unexport",
			"none",
			Tango::OPERATOR);
	command_list.push_back(pDbUnExportEventCmd);
	DbUnExportServerClass	*pDbUnExportServerCmd =
		new DbUnExportServerClass("DbUnExportServer",
			Tango::DEV_STRING, Tango::DEV_VOID,
			"",
			"",
			Tango::OPERATOR);
	command_list.push_back(pDbUnExportServerCmd);
	ResetTimingValuesClass	*pResetTimingValuesCmd =
		new ResetTimingValuesClass("ResetTimingValues",
			Tango::DEV_VOID, Tango::DEV_VOID,
			"",
			"",
			Tango::OPERATOR);
	command_list.push_back(pResetTimingValuesCmd);
	DbGetDataForServerCacheClass	*pDbGetDataForServerCacheCmd =
		new DbGetDataForServerCacheClass("DbGetDataForServerCache",
			Tango::DEVVAR_STRINGARRAY, Tango::DEVVAR_STRINGARRAY,
			"Elt[0] = DS name (exec_name/inst_name), Elt[1] = Host name",
			"All the data needed by the device server during its startup sequence. Precise list depend on the device server",
			Tango::OPERATOR);
	command_list.push_back(pDbGetDataForServerCacheCmd);
	DbDeleteAllDeviceAttributePropertyClass	*pDbDeleteAllDeviceAttributePropertyCmd =
		new DbDeleteAllDeviceAttributePropertyClass("DbDeleteAllDeviceAttributeProperty",
			Tango::DEVVAR_STRINGARRAY, Tango::DEV_VOID,
			"str[0] = device name, str[1]...str[n] = attribute name(s)",
			"",
			Tango::OPERATOR);
	command_list.push_back(pDbDeleteAllDeviceAttributePropertyCmd);
	DbMySqlSelectClass	*pDbMySqlSelectCmd =
		new DbMySqlSelectClass("DbMySqlSelect",
			Tango::DEV_STRING, Tango::DEVVAR_LONGSTRINGARRAY,
			"MySql Select command",
			"MySql Select command result\n - svalues : select results\n - lvalue[n] : =0 if svalue[n] is null else =1\n (last lvalue -1) is number of rows, (last lvalue) is number of fields",
			Tango::OPERATOR);
	command_list.push_back(pDbMySqlSelectCmd);

	/*----- PROTECTED REGION ID(DataBase::Class::command_factory_after) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::Class::command_factory_after

}




//===================================================================
//	Dynamic attributes related methods
//===================================================================


//--------------------------------------------------------
/**
 * method : 		DataBaseClass::create_static_attribute_list
 * description : 	Create the a list of static attributes
 *
 * @param	att_list	the ceated attribute list 
 */
//--------------------------------------------------------
void DataBaseClass::create_static_attribute_list(vector<Tango::Attr *> &att_list)
{
	for (unsigned long i=0 ; i<att_list.size() ; i++)
	{
		string att_name(att_list[i]->get_name());
		transform(att_name.begin(), att_name.end(), att_name.begin(), ::tolower);
		defaultAttList.push_back(att_name);
	}

	cout2 << defaultAttList.size() << " attributes in default list" << endl;


	/*----- PROTECTED REGION ID(DataBase::Class::create_static_att_list) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::Class::create_static_att_list

}


//--------------------------------------------------------
/**
 * method : 		DataBaseClass::erase_dynamic_attributes
 * description : 	delete the dynamic attributes if any.
 *
 * @param	devlist_ptr	the device list pointer
 * @param	list of all attributes
 */
//--------------------------------------------------------
void DataBaseClass::erase_dynamic_attributes(const Tango::DevVarStringArray *devlist_ptr, vector<Tango::Attr *> &att_list)
{
	Tango::Util *tg = Tango::Util::instance();

	for (unsigned long i=0 ; i<devlist_ptr->length() ; i++)
	{	
		Tango::DeviceImpl *dev_impl = tg->get_device_by_name(((string)(*devlist_ptr)[i]).c_str());
		DataBase *dev = static_cast<DataBase *> (dev_impl);
		
		vector<Tango::Attribute *> &dev_att_list = dev->get_device_attr()->get_attribute_list();
		vector<Tango::Attribute *>::iterator ite_att;
		for (ite_att=dev_att_list.begin() ; ite_att != dev_att_list.end() ; ++ite_att)
		{
			string att_name((*ite_att)->get_name_lower());
			if ((att_name == "state") || (att_name == "status"))
				continue;
			vector<string>::iterator ite_str = find(defaultAttList.begin(), defaultAttList.end(), att_name);
			if (ite_str == defaultAttList.end())
			{
				cout2 << att_name << " is a UNWANTED dynamic attribute for device " << (*devlist_ptr)[i] << endl;
				Tango::Attribute &att = dev->get_device_attr()->get_attr_by_name(att_name.c_str());
				dev->remove_attribute(att_list[att.get_attr_idx()],true);
				--ite_att;
			}
		}
	}
	/*----- PROTECTED REGION ID(DataBase::Class::erase_dynamic_attributes) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::Class::erase_dynamic_attributes

}



	/*----- PROTECTED REGION ID(DataBase::Class::Additional Methods) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::Class::Additional Methods

} //	namespace
