#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <stdarg.h>
#include <string.h>

#include "io_lib_header.h"
#include "util_lib_header.h"
#include "define_header.h"
#include "dp_lib_header.h"

static int suboptimal_pair_wise ( Alignment *A, int *ns, int **ls, Constraint_list *CL, int mode);
static int *** forward_so_dp ( Alignment *A, int *ns, int **ls, int **pos,int I, int J, int gop, int gep,int gop2, int gep2,Constraint_list *CL);
static int *** backward_so_dp ( Alignment *A, int *ns, int **ls,int **pos,int I, int J, int gop, int gep,int gop2, int gep2,Constraint_list *CL);
static int *** forward_so_dp_biphasic ( Alignment *A, int *ns, int **ls, int **pos,int I, int J, int gop, int gep,int gop2, int gep2,Constraint_list *CL);
static int *** backward_so_dp_biphasic ( Alignment *A, int *ns, int **ls,int **pos,int I, int J, int gop, int gep,int gop2, int gep2,Constraint_list *CL);
static int *** forward_so_dp_glocal ( Alignment *A, int *ns, int **ls, int **pos,int I, int J, int gop, int gep,int gop2, int gep2,Constraint_list *CL);
static int *** backward_so_dp_glocal ( Alignment *A, int *ns, int **ls,int **pos,int I, int J, int gop, int gep,int gop2, int gep2,Constraint_list *CL);

static int match=0;
static int ins=1;
static int del=2;
static int umatch=3;
static int ins2=3;
static int del2=4;

int subop1_pair_wise ( Alignment *A, int *ns, int **ls, Constraint_list *CL)
{
  return suboptimal_pair_wise ( A, ns, ls, CL, 1);
}

int subop2_pair_wise ( Alignment *A, int *ns, int **ls, Constraint_list *CL)
{
  return suboptimal_pair_wise ( A, ns, ls, CL, 2);
}



int suboptimal_pair_wise ( Alignment *A, int *ns, int **ls, Constraint_list *CL, int mode)
{
  int ***F=NULL;
  int ***B=NULL;
  int **pos0;
  int gop, gep,gop2, gep2;
  int i, I, j, J, n, s1, s2;
  char *seqI, *seqJ;
  int id, min,max, thres;
  int *entry;
  double avg=0, sd=0, z;

  
  gop=CL->gop*SCORE_K;
  gep=CL->gep*SCORE_K;

  /*gop2=CL->gop*10*SCORE_K;*/
  gop2=CL->gop*2*SCORE_K;
  gep2=0;

  seqI=A->seq_al[ls[0][0]];
  seqJ=A->seq_al[ls[1][0]];
  
  I=strlen (seqI); J=strlen (seqJ);
  pos0=aln2pos_simple ( A,-1, ns, ls);
  if ( mode==1)
    {
      F=forward_so_dp (A, ns, ls, pos0,I, J,gop, gep,gop2, gep2,CL);
      B=backward_so_dp (A, ns, ls, pos0,I, J,gop, gep,gop2, gep2, CL);
    }
  else if ( mode ==2)
    {
      F=forward_so_dp_glocal (A, ns, ls, pos0,I, J,gop, gep,gop2, gep2,CL);
      B=backward_so_dp_glocal (A, ns, ls, pos0,I, J,gop, gep,gop2, gep2, CL);
    }
  else if ( mode ==3)
    {
      F=forward_so_dp_biphasic (A, ns, ls, pos0,I, J,gop, gep,gop2, gep2,CL);
      B=backward_so_dp_biphasic (A, ns, ls, pos0,I, J,gop, gep,gop2, gep2, CL);
    }
  

  for ( i=1; i<=I; i++)
    for (j=1; j<=J; j++)
      { 
	F[match][i][j]+=B[match][i][j]-(CL->get_dp_cost) (A, pos0, ns[0], ls[0], i-1, pos0, ns[1], ls[1],j-1,CL);
      }
	  
  gotoh_pair_wise (A, ns, ls, CL);
  s1=name_is_in_list (A->name[ls[0][0]], (CL->S)->name, (CL->S)->nseq, 100);
  s2=name_is_in_list (A->name[ls[1][0]], (CL->S)->name, (CL->S)->nseq, 100);
  
  id=get_seq_sim (seqI, seqJ, "-", "idmat");
  min=max=F[match][1][1];


  for ( i=1; i<=I; i++)
    for (j=1; j<=J; j++)
      { 
	min=MIN(F[match][i][j],min);
	max=MAX(F[match][i][j],max);
      }
	 
  for ( i=1; i<=I; i++)for (j=1; j<=J; j++)if (F[match][i][j]!=UNDEFINED){F[match][i][j]-=min;}
  max-=min;
 

  
  if ( id>50)z=0;
  else z=0.015;
      
  fprintf ( stdout, "\nMax=%d Min=%d", max, min);
  thres=(max-FABS(max)*z);
  
  fprintf ( stdout, "\nThres=%d", thres);
  
  /*OPT=0.019*/
  entry=vcalloc ( CL->entry_len, CL->el_size);
  entry[SEQ1]=s1;entry[SEQ2]=s2;
  
  for ( n=0,i=1; i<=I; i++)
    {
      for (j=1; j<=J; j++)
	{
	  if ( F[match][i][j]==UNDEFINED)continue;

	  /*F[0][i][j]+=B[0][i][j]-((CL->get_dp_cost) (A, pos0, ns[0], ls[0], i-1, pos0, ns[1], ls[1],j-1,CL));*/
	  
	  if ( F[0][i][j]>=thres)
	    {
	      n++;
	      entry[R1]=i;entry[R2]=j;
	      entry[WE]=id;
	      entry[CONS]=1;
	      add_entry2list (entry,A->CL);
	    }
	}
    }
  if (I && J )fprintf ( stderr, "\nID=%d z=%.2f avg=%d sd=%d %d %d: Ratio=[%.2f]\n", (int) id, z, (int) avg, (int) sd,entry[SEQ1], entry[SEQ2], ((float)n*100)/(float)(I*J));
  vfree (entry);
  free_int (pos0, -1);
  free_arrayN (F, 3);
  free_arrayN (B, 3);

  return A->score_aln;
}
/************************************************************************************************************************/
/*                                                                                                                      */
/*                                                                                                                      */
/*                                                     GLOCAL                                                           */
/*                                                                                                                      */
/*                                                                                                                      */
/************************************************************************************************************************/
int *** forward_so_dp_glocal ( Alignment *A, int *ns, int **ls, int **pos0,int I, int J,int gop, int gep,int gop2, int gep2,Constraint_list *CL)
{
  int i,j;
  int c;
  int sub;
  int ***M;
  int match=0, del=1, ins=2;
  
  M=declare_arrayN (3, sizeof (int), 5, I+1, J+1);

  for ( i=0; i<=I; i++)for (j=0; j<=J; j++)for (c=0; c<5; c++)M[c][i][j]=-999999;
  
  M[match][0][0]=0;
  
  for (i=1; i<=I; i++){M[ins]  [i][0]=i*gep;M[umatch][i][0]=i*gep2+gop2;}
  for (j=1; j<=J; j++){M[del]  [0][j]=j*gep;M[umatch][0][j]=j*gep2+gop2;}
  
  
  for (i=1; i<=I; i++)
    {
      for ( j=1; j<=J; j++)
	{
	sub=(CL->get_dp_cost) (A, pos0, ns[0], ls[0], i-1, pos0, ns[1], ls[1],j-1,CL);	
	
	M[match][i][j] =MAX4  (M[match][i-1][j-1],M[del][i-1][j-1], M[ins][i-1][j-1],M[umatch][i-1][j-1])+sub;
	M[del][i][j]   =MAX2       ((M[match][i-1][j]+gop), M[del][i-1][j])+gep;	
	M[ins][i][j]   =MAX2       ((M[match][i][j-1]+gop), M[ins][i][j-1])+gep;
	M[umatch][i][j]=MAX6 (M[match][i-1][j-1]+gop2, M[match][i][j-1]+gop2, M[match][i-1][j]+gop2,M[umatch][i-1][j-1], M[umatch][i-1][j], M[umatch][i][j-1])+gep2;
	}
    }
  return M;
}
int *** backward_so_dp_glocal ( Alignment *A, int *ns, int **ls, int **pos0, int I, int J, int gop, int gep,int gop2, int gep2,Constraint_list *CL)
{
  int i,j;
  int c;
  int sub;
  int ***M;



  M=declare_arrayN (3, sizeof (int), 5, I+2, J+2);
  for ( i=I+1; i>=0; i--)for (j=J+1; j>=0; j--)for (c=0; c<5; c++)M[c][i][j]=-999999;
  M[match][I+1][J+1]=0;
  
  for (i=I; i>0; i--){M[ins]  [i][J+1]=i*gep;M[umatch]  [i][J+1]=i*gep2+gop2;}
  for (j=J; j>0; j--){M[del]  [I+1][j]=j*gep;M[umatch]  [I+1][j]=j*gep2+gop2;}
  
  for (i=I; i>0; i--)
    {
      for ( j=J; j>0; j--)
	{
	sub=(CL->get_dp_cost) (A, pos0, ns[0], ls[0], i-1, pos0, ns[1], ls[1],j-1,CL);	
	
	M[match ][i][j]  =MAX4 ((M[del][i+1][j+1]+gop), (M[ins][i+1][j+1]+gop), M[match][i+1][j+1], M[umatch][i+1][j+1]+gop2)+sub;
	M[del   ][i][j]  =MAX2 (M[match][i+1][j], M[del][i+1][j])+gep;
	M[ins   ][i][j]  =MAX2 (M[match][i][j+1], M[ins][i][j+1])+gep;
	M[umatch][i][j]  =MAX6 (M[match][i+1][j+1], M[match][i+1][j],M[match][i][j+1], M[umatch][i+1][j+1], M[umatch][i+1][j], M[umatch][i][j+1])+gep2;
	
	}
    }
  return M;
}




/************************************************************************************************************************/
/*                                                                                                                      */
/*                                                                                                                      */
/*                                                     SIMPLE                                                           */
/*                                                                                                                      */
/*                                                                                                                      */
/************************************************************************************************************************/

int *** forward_so_dp ( Alignment *A, int *ns, int **ls, int **pos0,int I, int J,int gop, int gep,int gop2, int gep2,Constraint_list *CL)
{
  int i,j;
  int c;
  int sub;
  int ***M;

  M=declare_arrayN (3, sizeof (int), 5, I+1, J+1);

  for ( i=0; i<=I; i++)for (j=0; j<=J; j++)for (c=0; c<3; c++)M[c][i][j]=-999999;
  
  M[match][0][0]=0;
  
  for (i=1; i<=I; i++){M[ins]  [i][0]=i*gep;}
  for (j=1; j<=J; j++){M[del]  [0][j]=j*gep;}
  
  
  for (i=1; i<=I; i++)
    {
      for ( j=1; j<=J; j++)
	{
	sub=(CL->get_dp_cost) (A, pos0, ns[0], ls[0], i-1, pos0, ns[1], ls[1],j-1,CL);	
	
	M[match][i][j]=MAX3  (M[del][i-1][j-1], M[ins][i-1][j-1], M[match][i-1][j-1])+sub;
	M[del][i][j]  =MAX ((M[match][i-1][j]+gop),M[del][i-1][j])+gep;
	M[ins][i][j]  =MAX ((M[match][i][j-1]+gop),  M[ins][i][j-1])+gep;
	
	}

    }
  return M;
  }
int *** backward_so_dp ( Alignment *A, int *ns, int **ls, int **pos0, int I, int J, int gop, int gep,int gop2, int gep2,Constraint_list *CL)
{
  int i,j;
  int c;
  int sub;
  int ***M;



  M=declare_arrayN (3, sizeof (int), 5, I+2, J+2);
  for ( i=I+1; i>=0; i--)for (j=J+1; j>=0; j--)for (c=0; c<3; c++)M[c][i][j]=-999999;
  M[match][I+1][J+1]=0;
  
  for (i=I; i>0; i--){M[ins]  [i][J+1]=i*gep;}
  for (j=J; j>0; j--){M[del]  [I+1][j]=j*gep;}
  
  for (i=I; i>0; i--)
    {
      for ( j=J; j>0; j--)
	{
	sub=(CL->get_dp_cost) (A, pos0, ns[0], ls[0], i-1, pos0, ns[1], ls[1],j-1,CL);	
	
	M[match][i][j] =MAX3 ((M[del][i+1][j+1]+gop), (M[ins][i+1][j+1]+gop), M[match][i+1][j+1])+sub;
	M[del ][i][j]  =MAX (M[match][i+1][j], M[del][i+1][j])+gep;
	
	M[ins ][i][j]  =MAX (M[match][i][j+1], M[ins][i][j+1])+gep;
	
	
	}
    }
  return M;
}

/************************************************************************************************************************/
/*                                                                                                                      */
/*                                                                                                                      */
/*                                                     BI-PHASIC                                                        */
/*                                                                                                                      */
/*                                                                                                                      */
/************************************************************************************************************************/

int *** forward_so_dp_biphasic ( Alignment *A, int *ns, int **ls, int **pos0,int I, int J,int gop, int gep,int gop2, int gep2,Constraint_list *CL)
{
  int i,j;
  int c;
  int sub;
  int ***M;
  int match=0, del=1, ins=2;

  M=declare_arrayN (3, sizeof (int), 5, I+1, J+1);

  for ( i=0; i<=I; i++)for (j=0; j<=J; j++)for (c=0; c<5; c++)M[c][i][j]=-999999;
  
  M[match][0][0]=0;
  
  for (i=1; i<=I; i++){M[ins]  [i][0]=i*gep;}
  for (j=1; j<=J; j++){M[del]  [0][j]=j*gep;}
  
  
  for (i=1; i<=I; i++)
    {
      for ( j=1; j<=J; j++)
	{
	sub=(CL->get_dp_cost) (A, pos0, ns[0], ls[0], i-1, pos0, ns[1], ls[1],j-1,CL);	
	
	M[match][i][j]=MAX3  (M[del][i-1][j-1], M[ins][i-1][j-1], M[match][i-1][j-1])+sub;
	
	M[del][i][j]   =MAX3 ((M[match][i-1][j]+gop),M[del][i-1][j], M[del2][i-1][j])+gep;
	M[del2][i][j]  =MAX  ((M[del][i-1][j]+gop2), M[del2][i-1][j])+gep2;
	
	M[ins][i][j]  =MAX3 ((M[match][i][j-1]+gop),  M[ins][i][j-1], M[ins2][i][j-1])+gep;
	M[ins2][i][j] =MAX  ((M[ins][i][j-1]+gop2), M[ins2][i][j-1])+gep2;
	}

    }
  return M;
  }
int *** backward_so_dp_biphasic ( Alignment *A, int *ns, int **ls, int **pos0, int I, int J, int gop, int gep,int gop2, int gep2,Constraint_list *CL)
{
  int i,j;
  int c;
  int sub;
  int ***M;



  M=declare_arrayN (3, sizeof (int), 5, I+2, J+2);
  for ( i=I+1; i>=0; i--)for (j=J+1; j>=0; j--)for (c=0; c<5; c++)M[c][i][j]=-999999;
  M[match][I+1][J+1]=0;
  
  for (i=I; i>0; i--){M[ins]  [i][J+1]=i*gep;}
  for (j=J; j>0; j--){M[del]  [I+1][j]=j*gep;}
  
  for (i=I; i>0; i--)
    {
      for ( j=J; j>0; j--)
	{
	sub=(CL->get_dp_cost) (A, pos0, ns[0], ls[0], i-1, pos0, ns[1], ls[1],j-1,CL);	
	
	M[match][i][j] =MAX3 ((M[del][i+1][j+1]+gop), (M[ins][i+1][j+1]+gop), M[match][i+1][j+1])+sub;
	M[del ][i][j]  =MAX3 (M[match][i+1][j], M[del][i+1][j],(M[del2][i+1][j]+gop2))+gep;
	M[del2][i][j]  =MAX  (M[del][i+1][j], M[del2][i+1][j])+gep2;
	
	M[ins ][i][j]  =MAX3 (M[match][i][j+1], M[ins][i][j+1],(M[ins2][i][j+1]+gop2))+gep;
	M[ins2][i][j]  =MAX  (M[ins][i][j+1], M[ins2][i][j+1])+gep2;
	
	}
    }
  return M;
}


/*********************************COPYRIGHT NOTICE**********************************/
/* Centro de Regulacio Genomica */
/*and */
/*Cedric Notredame */
/*Fri Jun  6 17:35:06 WEST 2008. */
/*All rights reserved.*/
/*This file is part of T-COFFEE.*/
/**/
/*    T-COFFEE is free software; you can redistribute it and/or modify*/
/*    it under the terms of the GNU General Public License as published by*/
/*    the Free Software Foundation; either version 2 of the License, or*/
/*    (at your option) any later version.*/
/**/
/*    T-COFFEE is distributed in the hope that it will be useful,*/
/*    but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*    GNU General Public License for more details.*/
/**/
/*    You should have received a copy of the GNU General Public License*/
/*    along with Foobar; if not, write to the Free Software*/
/*    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA*/
/*...............................................                                                                                      |*/
/*  If you need some more information*/
/*  cedric.notredame@europe.com*/
/*...............................................                                                                                                                                     |*/
/**/
/**/
/*	*/
/*********************************COPYRIGHT NOTICE**********************************/
