/*-----------------------------------------------------------------------

                         SYRTHES version 3.4
                         -------------------

     This file is part of the SYRTHES Kernel, element of the
     thermal code SYRTHES.

     Copyright (C) 1988-2008 EDF S.A., France

     contact: syrthes-support@edf.fr


     The SYRTHES Kernel is free software; you can redistribute it
     and/or modify it under the terms of the GNU General Public License
     as published by the Free Software Foundation; either version 2 of
     the License, or (at your option) any later version.

     The SYRTHES Kernel is distributed in the hope that it will be
     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.


     You should have received a copy of the GNU General Public License
     along with the Code_Saturne Kernel; if not, write to the
     Free Software Foundation, Inc.,
     51 Franklin St, Fifth Floor,
     Boston, MA  02110-1301  USA

-----------------------------------------------------------------------*/
# include <stdio.h>
# include <stdlib.h>
# include <math.h>

# include "f2c_syrthes.h"
# include "abs.h"

/* tableaux */
int *ncoups,*nfluss,*ndirs,*nechs,*nfluvs,*nrescs,*nrayts;
int *nrayis,*nprios,*nmobil;
double *vfluss,*vdirs,*vechs,*vfluvs,*vrescs,*vrayts,*vrayis;
int *nrefac,*nrefal,*nfcous,*nfflus,*nfechs,*nfresc,*nfrays,*nfrais;
double *vfflus,*vfechs,*vfresc,*vfrays,*vfrais,*coords;
int *nrefs,*nrefe,*nodes,*nangle,*nodess,*nodeus,*noderc,*nodepr,*nodera;
double *physol,*tmpsa,*tmps,*tmpsc1,*tmpsc2,*tmpsc3,*volume,*surfus;
double *tmpmax,*tmpmin;
int *ngffir,*ngftir,*ngfper,*ngfpef;
int *ngfmst,*ngfmse;
double *vfmste,*phmstp,*phmsto;
double *emissi,*phfraf,*phfrae,*temray,*firay,*vfiray;
double *erayeq,*trayeq,*erayen,*trayen,*epropr;
int *nodray,*nrfray,*ityfar,*ncsray,*ncfray,*nesray;
double *cooray,*fdfray,*sufray;
int *ncfin,*ncgros,*itrav;
double *tabray,*radios,*flumst,*barygr,*baryfs;
double *b,*dmat,*xmat,*diag,*wct;
int *itrav1,*itrav2,*itrmed;
int *ncfinf,*ncgrof,*ncbors,*ncborf,*nodesf,*ncoupf,*nrapf,*nodraf;
double *baryfr,*baryff,*barys,*baryf,*vcoups,*vcoupf,*vfcous;
double *cooraf,*coordf,*vrapf;

/* constantes */
int ndim,nelesf,nbcouf,nbraf,nelraf,ndmasf;
int npoins,nelems,nfbida,neless,neleus,nelepr,nelerc,nelera;
int nbcous,nbflus,nbdirs,nbechs,nbflvs,nbress;
int nbrays,nbrais,nbprio,nbmobs,nbfflu,nbfech,nbfrai;
int ndiele,ndmats,ndmass,ncoema,nbphys,nbface;
int nbcopr,nbicor,nppel,npoue,npfel;
int npoinr,nelray,nnsray,nnfray,nneray;
int nfcfra,nfcsra,nftira,nffira,nfpera,nfmst,nfmste;

double totso,timso,totsoi,totray,timray,totrai;
int nbpaso,nbpara;
double *b,*trav1,*trav2,*trav3,*trav4,*dmat,*diag,*xmat,*wct,*travf;
int idtrav;

/*|======================================================================|
  | SYRTHES 3.4.2                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | syrtc1                                                               |
  |   Initialisation de Syrthes avec couplage avec le Solveur Commun     |
  |======================================================================| */
proc(syrtc1,SYRTC1)(int *ndim_, int *npoinf,int *nodebf,int *nelebf,
		    double *xyzf, double *tf, double *hht)
{
  int un=1,calcium=0;
 

  /* variables a recuperer des communs */
  int lcface,lray,ntsyr,ncthfs,ldern,lstops,lhisor,lsyrth,ltmax;
  int nchror,lsdepl,ntsmax,ntsyrd,lhisol,nhrmax,nbande,ndprop,nfreqs;
  double rdtts,tempss;
  
  double timso1,timso2,timsobc,timsoac;
  int nbfils,nwmail,nwdn,nwdrn,nwde,nwdre;
  int nwncf1,nwnrf1,nwecf1,nwerf1,nwdma1;
  int taill_i,taill_r,taill_it,taill_rt,taill_rr;
  int i;

  proc(syrban,SYRBAN)(&un);

  proc(cpusyr,CPUSYR)(&timso1);
  printf("\n **TEMPS D'ENTREE ETAPE D'INITIALISATION : %f\n",timso1);
  totso=totsoi=totray=totrai=timray=timso=0.;  
  ntsmax=nbpaso=nbpara=taill_i=taill_r=taill_it=taill_rt=taill_rr=0;
  lsyrth=0;   


  proc(syrban,SYRBAN)(&un);  
  proc(iniso1,INISO1)
         (&ndim,&npoins,&nelems,&nfbida,&neless,&neleus,&nelepr,&nelerc,&nelera,
          &nbcous,&nbflus,&nbdirs,&nbechs,&nbflvs,&npfel,&nbress,
          &nbrays,&nbrais,&nbprio,&nbmobs,&nbcopr,
          &ndiele,&ndmats,&ndmass,&nbface,&ncoema,&nbphys,&nppel,&npoue,&nbicor,
	  &nbfflu,&nbfech,&nbfrai,&npoinr,&nelray,&nnsray,&nnfray,&nneray,
          &nfcfra,&nfcsra,&nftira,&nffira,&nfpera,&nfmst,&nfmste);

  if (ndim != *ndim_)
    {
      printf("\n ERREUR SYRTHES : les dimensions des domaines fluide et solide sont incompatibles\n");
      exit(0);
    }
  ndmasf=ndim; 
  nbcouf=*npoinf; nelesf=*nelebf;  nbraf=nelraf=0;

  fflush(stdout);
  nbfils=1;nwmail=1;nwdn=1;nwdrn=1;nwde=1;nwdre=1;nwncf1=nbcouf;
  nwnrf1=nbraf;nwecf1=nelesf;nwerf1=nelraf;nwdma1=ndmasf;

  if (nbcouf==0)
    {printf("  $$ ATTENTION :\n");
     printf("     VOUS UTILISEZ LE COUPLAGE THERMIQUE \n");
     printf("     CODE_SATURNE (FLUIDE) / SYRTHES (SOLIDE)\n");
     printf("     AUCUN NOEUD FLUIDE COUPLE AU SOLIDE N''EST DETECTE\n");
     printf("     ==> UTILISEZ SYRTHES POUR LES CALCULS DE THERMIQUE\n");
     printf("     DANS DES SOLIDES\n");
     exit(0);
   }

  proc(recusy,RECUSY)(&lsyrth,&lcface,&lray,&ntsyr,&ncthfs,&ldern,&lstops,&lhisor,
		      &nchror,&lsdepl,&ntsmax,&ntsyrd,&lhisol,&nhrmax,&nbande,&ndprop,
		      &rdtts,&tempss,&nfreqs,&ltmax);

  idtrav=max(nbcouf,npoins); idtrav=max(idtrav,npoinr);idtrav=max(idtrav,nelray);

  ncoups=(int*)malloc(max(nbcous,1)*sizeof(int));                     taill_i+=max(nbcous,1);
  nfluss=(int*)malloc(max(nbflus,1)*sizeof(int));                     taill_i+=max(nbflus,1);
  ndirs=(int*)malloc(max(nbdirs,1)*sizeof(int));                      taill_i+=max(nbdirs,1);
  nechs=(int*)malloc(max(nbechs*2,1)*sizeof(int));                    taill_i+=max(nbechs*2,1);
  nfluvs=(int*)malloc(max(nbflvs,1)*sizeof(int));                     taill_i+=max(nbflvs,1);
  nrescs=(int*)malloc(max(nbress*2,1)*sizeof(int));                   taill_i+=max(nbress*2,1);
  nrayts=(int*)malloc(max(nbrays,1)*sizeof(int));                     taill_i+=max(nbrays,1);
  nrayis=(int*)malloc(max(nbrais,1)*sizeof(int));                     taill_i+=max(nbrais,1);
  nprios=(int*)malloc(max(nbprio*(nbcopr+1),1)*sizeof(int));          taill_i+=max(nbprio*(nbcopr+1),1);
  nmobil=(int*)malloc(max(nbmobs*2,1)*sizeof(int));                   taill_i+=max(nbmobs*2,1);
  vfluss=(double*)malloc(max(nbflus,1)*sizeof(double));               taill_r+=max(nbflus,1);
  vdirs=(double*)malloc(max(nbdirs,1)*sizeof(double));                taill_r+=max(nbdirs,1);
  vechs=(double*)malloc(max(nbechs*2,1)*sizeof(double));              taill_r+=max(nbechs*2,1);
  vfluvs=(double*)malloc(max(nbflvs*npfel,1)*sizeof(double));         taill_r+=max(nbflvs*npfel,1);
  vrescs=(double*)malloc(max(nbress*2,1)*sizeof(double));             taill_r+=max(nbress*2,1);
  vrayts=(double*)malloc(max(nbrays*2,1)*sizeof(double));             taill_r+=max(nbrays*2,1);
  vrayis=(double*)malloc(max(nbrais*2,1)*sizeof(double));             taill_r+=max(nbrais*2,1);
  nrefe=(int*)malloc(nelems*sizeof(int));                             taill_i+=nelems;
  if (!ncoups|| !ndirs|| !nechs|| !nfluvs|| !nrescs|| !nrayts|| !nrayis|| !nprios|| !nmobil
   || !vfluss|| !vdirs|| !vechs|| !vfluvs|| !vrescs|| !vrayts|| !vrayis|| !nrefe)
    { printf("\n ERREUR D'ALLOCATION MEMOIRE 1\n");exit(0);}

  if (lcface)
    {
      nrefac=(int*)malloc(nelems*nbface*sizeof(int));                       taill_i+=nelems*nbface;
      nrefal=(int*)malloc(max(neleus,1)*sizeof(int));                       taill_i+=max(neleus,1);
      if (ncthfs==2)       {nfcous=(int*)malloc(max(nelems,1)*sizeof(int)); taill_i+=max(nelems,1);}
      else if  (ncthfs==3) {nfcous=(int*)malloc(max(neless,1)*sizeof(int)); taill_i+=max(neless,1);}
      nfflus=(int*)malloc(max(nbfflu,1)*sizeof(int));                       taill_i+=max(nbfflu,1);
      nfechs=(int*)malloc(max(nbfech,1)*sizeof(int));                       taill_i+=max(nbfech,1);
      nfresc=(int*)malloc(max(nelerc,1)*sizeof(int));                       taill_i+=max(nelerc,1);
      nfrays=(int*)malloc(max(nelera,1)*sizeof(int));                       taill_i+=max(nelera,1);
      nfrais=(int*)malloc(max(nbfrai,1)*sizeof(int));                       taill_i+=max(nbfrai,1);
      vfflus=(double*)malloc(max(nbfflu*ndmass,1)*sizeof(double));          taill_r+=max(nbfflu*ndmass,1);
      vfechs=(double*)malloc(max(nbfech*ndmass*2,1)*sizeof(double));        taill_r+=max(nbfech*ndmass*2,1);
      vfresc=(double*)malloc(max(nelerc*ndmass*2,1)*sizeof(double));        taill_r+=max(nelerc*ndmass*2,1);
      vfrays=(double*)malloc(max(nelera*ndmass*2,1)*sizeof(double));        taill_r+=max(nelera*ndmass*2,1);
      vfrais=(double*)malloc(max(nbfrai*ndmass*2,1)*sizeof(double));        taill_r+=max(nbfrai*ndmass*2,1);
      vfcous=(double*)malloc(max(neless*ndmass*2,1)*sizeof(double));      taill_r+=max(neless*ndmass*2,1);
      if ( !nrefal || !nfcous || !nfflus || !nfechs || !nfresc || !nfrays || !nfrais 
        || !vfflus || !vfechs || !vfresc || !vfrays || !vfrais || !nrefac || !vfcous)
	{printf("\n ERREUR D'ALLOCATION MEMOIRE 2\n");exit(0);}
    }
  
  nrefs=(int*)malloc(npoins*sizeof(int));                                   taill_i+=npoins;
  coords=(double*)malloc(npoins*ndim*sizeof(double));                       taill_r+=npoins*ndim;
  nodes=(int*)malloc(nelems*ndmats*sizeof(int));                            taill_i+=nelems*ndmats;
  nangle=(int*)malloc(nelems*sizeof(int));                                  taill_i+=nelems;
  nodess=(int*)malloc(max(neless*ndmass,1)*sizeof(int));                    taill_i+=max(neless*ndmass,1);
  nodeus=(int*)malloc(max(neleus*ndmass,1)*sizeof(int));                    taill_i+=max(neleus*ndmass,1);
  noderc=(int*)malloc(max(nelerc*ndmass,1)*sizeof(int));                    taill_i+=max(nelerc*ndmass,1);
  nodepr=(int*)malloc(max(nelepr*(ndmats+1),1)*sizeof(int));                taill_i+=max(nelepr*(ndmats+1),1);
  nodera=(int*)malloc(max(nelera*ndmass,1)*sizeof(int));                    taill_i+=max(nelera*ndmass,1);
  physol=(double*)malloc(max(npoue*nppel*nbphys,1)*sizeof(double));         taill_r+=max(npoue*nppel*nbphys,1);
  tmpsa=(double*)malloc(npoins*sizeof(double));                             taill_r+=npoins;
  tmps=(double*)malloc(npoins*sizeof(double));                              taill_r+=npoins;
  if ( !coords|| !nodes|| !nodess|| !nodeus|| !noderc|| !nodepr|| !nodera|| !physol
    || !tmpsa || !tmps || !nrefs)
    { printf("\n ERREUR D'ALLOCATION MEMOIRE 3\n");exit(0);}

  if (ncthfs!=2)
    {
      volume=(double*)malloc(nelems*sizeof(double));                        taill_r+=nelems;
      surfus=(double*)malloc(max(neleus,1)*sizeof(double));                 taill_r+=max(neleus,1);
      if ( !volume|| !surfus) { printf("\n ERREUR D'ALLOCATION MEMOIRE 4\n");exit(0);}
    }
  if (ltmax)
    {
      tmpmax=(double*)malloc(npoins*sizeof(double));     
      tmpmin=(double*)malloc(npoins*sizeof(double));     
      if (!tmpmax || !tmpmin) { printf("\n ERREUR D'ALLOCATION MEMOIRE 5\n");exit(0);}
    }


  if (lray)
    {
      ngffir=(int*)malloc(max(nffira,1)*sizeof(int));                      taill_i+=max(nffira,1);
      ngftir=(int*)malloc(max(nftira,1)*sizeof(int));                      taill_i+=max(nftira,1);
      ngfper=(int*)malloc(max(nfpera,1)*sizeof(int));                      taill_i+=max(nfpera,1);
      ngfpef=(int*)malloc(max(nfcfra,1)*sizeof(int));                      taill_i+=max(nfcfra,1);
      ngfmst=(int*)malloc(max(nfmst*2,1)*sizeof(int));                     taill_i+=max(nfmst*2,1);
      ngfmse=(int*)malloc(max(nfmste,1)*sizeof(int));                      taill_i+=max(nfmste,1);
      vfmste=(double*)malloc(max(nfmste*2,1)*sizeof(double));              taill_r+=max(nfmste*2,1);
      phmstp=(double*)malloc(max(nfmst*4,1)*sizeof(double));               taill_r+=max(nfmst*4,1)  ;  
      phmsto=(double*)malloc(max(nfmst*5*nbande,1)*sizeof(double));        taill_r+=max(nfmst*5*nbande,1);
      flumst=(double*)malloc(max(nfmst*nbande,1)*sizeof(double));          taill_r+=max(nfmst*nbande,1);
      emissi=(double*)malloc(max(nelray*2*nbande,1)*sizeof(double));       taill_r+=max(nelray*2*nbande,1);
      epropr=(double*)malloc(max(nelray*nbande,1)*sizeof(double));         taill_r+=max(nelray*nbande,1);
      phfraf=(double*)malloc(max(nfcfra*4,1)*sizeof(double));              taill_r+=max(nfcfra*4,1);
      phfrae=(double*)malloc(max(nfpera*4,1)*sizeof(double));              taill_r+=max(nfpera*4,1);
      temray=(double*)malloc(max(nelray,1)*sizeof(double));                taill_r+=max(nelray,1);
      firay=(double*)malloc(max(nelray*nbande,1)*sizeof(double));          taill_r+=max(nelray*nbande,1);
      vfiray=(double*)malloc(max(nffira*nbande*2,1)*sizeof(double));       taill_r+=max(nffira*nbande*2,1);
      erayeq=(double*)malloc(max(nelray,1)*sizeof(double));                taill_r+=max(nelray,1);
      trayeq=(double*)malloc(max(nelray,1)*sizeof(double));                taill_r+=max(nelray,1);
      erayen=(double*)malloc(max(npoinr,1)*sizeof(double));                taill_r+=max(npoinr,1);
      trayen=(double*)malloc(max(npoinr,1)*sizeof(double));                taill_r+=max(npoinr,1);
      nodray=(int*)malloc(max(nelray*ndim,1)*sizeof(int));                 taill_i+=max(nelray*ndim,1);
      nrfray=(int*)malloc(max(nelray,1)*sizeof(int));                      taill_i+=max(nelray,1);
      ityfar=(int*)malloc(max(nelray,1)*sizeof(int));                      taill_i+=max(nelray,1);
      cooray=(double*)malloc(max(npoinr*ndim,1)*sizeof(double));           taill_r+=max(npoinr*ndim,1);
      fdfray=(double*)malloc(max(nelray*(nelray+1)/2,1)*sizeof(double));   taill_r+=max(nelray*(nelray+1)/2,1);
      sufray=(double*)malloc(max(nelray,1)*sizeof(double));                taill_r+=max(nelray,1);
      ncsray=(int*)malloc(max(nnsray,1)*sizeof(int));                      taill_i+=max(nnsray,1);
      ncfray=(int*)malloc(max(nnfray,1)*sizeof(int));                      taill_i+=max(nnfray,1);
      nesray=(int*)malloc(max(nneray,1)*sizeof(int));                      taill_i+=max(nneray,1);
      ncfin=(int*)malloc(max(nbrays,1)*sizeof(int));                       taill_i+=max(nbrays,1);
      ncgros=(int*)malloc(max(nnsray*2,1)*sizeof(int));                    taill_i+=max(nnsray*2,1);
      barygr=(double*)malloc(max(nnsray*ndim,1)*sizeof(double));           taill_r+=max(nnsray*ndim,1);
      baryfs=(double*)malloc(max(nbrays*ndim,1)*sizeof(double));           taill_r+=max(nbrays*ndim,1);
      tabray=(double*)malloc(max(nelray*9,1)*sizeof(double));              taill_r+=max((nelray+1)*8,1);
      radios=(double*)malloc(max(nelray*nbande,1)*sizeof(double));         taill_r+=max(nfmst*5*nbande,1);
							       
      if (!ngffir || !ngftir || !ngfper || !ngfpef || !ngfmst  || !ngfmse || !vfmste || 
	  !phmstp || !phmsto || !flumst || !emissi || !epropr  || !phfraf || !phfrae || 
	  !temray || !firay  || !vfiray || !erayeq || !trayen  || !erayen || !trayen || 
	  !nodray || !nrfray || !ityfar || !cooray || !fdfray  || !sufray || !ncsray || 
	  !ncfray || !nesray || !ncfin  || !ncgros || !barygr  || !baryfs ||  
	  !tabray || !radios)
	{printf("\n ERREUR D'ALLOCATION MEMOIRE 6\n");exit(0);}
    }


  itrav=(int*)malloc(max(idtrav,1)*sizeof(int));                    taill_it+=max(idtrav,1);
  itrav1=(int*)malloc(max(idtrav,1)*sizeof(int));                   taill_it+=max(idtrav,1);
  itrmed=(int*)malloc(max(ndmats*nelems,1)*sizeof(int));            taill_it+=max(ndmats*nelems,1);
  if (!itrav||!itrav1){printf("\n ERREUR D'ALLOCATION MEMOIRE 7\n");exit(0);}
  trav1=(double*)malloc(max(npoins,nbcouf)*sizeof(double));                 taill_rt+=npoins;
  trav2=(double*)malloc(max(npoins,1)*sizeof(double));                 taill_rt+=npoins;
  if (!trav1||!trav2)
    {printf("\n ERREUR D'ALLOCATION MEMOIRE 8\n");exit(0);}
  if (nbprio)
    {
      itrav2=(int*)malloc(max(npoins,1)*sizeof(int));                      taill_it+=npoins;
      trav3=(double*)malloc(max(npoins,1)*sizeof(double));                 taill_rt+=npoins;
      if (!itrav2||!trav3)
	{printf("\n ERREUR D'ALLOCATION MEMOIRE 8\n");exit(0);}
    }

  printf("\n\n ============================================================\n");
  printf("        Memoire totale pour la phase initiale :\n\n");
  printf("            Nombre d'entiers reserves : %9d\n",taill_i+taill_it);
  printf("                       soit par noeud : %9d\n\n",(taill_i+taill_it)/npoins);
  printf("            Nombre de reels  reserves : %9d\n",taill_r+taill_rt);
  printf("                       soit par noeud : %9d\n",(taill_r+taill_rt)/npoins); 
  printf("============================================================\n\n");

  proc(inisol,INISOL)
        (&ndim,&ndiele,&nbface,&nfbida,
         &nbcous,&nbflus,&nbdirs,&nbechs,&nbflvs,&npfel,&npoins,&nelems,&ndmats,
	 &neless,&ndmass,&neleus,&nelerc,&nelepr,&nelera,&nbress,
         &nbrays,&nbrais,&nbprio,&nbmobs,&nbcopr,&nbphys,&nppel,&npoue,&nbicor,
	 &nbfflu,&nbfech,&nbfrai,
	 ncoups,nfluss,ndirs,nechs,nfluvs,nrescs,nrayts,
	 nrayis,nprios,nmobil,
	 vfluss,vdirs,vechs,vfluvs,vrescs,vrayts,vrayis,
	 nrefac,nrefal,nfcous,nfflus,nfechs,nfresc,nfrays,nfrais,
	 vfflus,vfechs,vfresc,vfrays,vfrais,
	 nrefs,nrefe,coords,nodes,nodess,nodeus,noderc,nodepr,nodera,
	 nangle,physol,tmpsa,tmps,tmpsc1,tmpsc2,tmpsc3,volume,surfus,
	 &nelray,&npoinr,&nnsray,&nnfray,&nneray,&nfcfra,&nfcsra,&nftira,
	 &nffira,&nfpera,&nfmst,&nfmste,ngffir,ngftir,ngfper,ngfpef,
	 ngfmst,ngfmse,vfmste,phmstp,phmsto,
	 emissi,phfraf,phfrae,temray,firay,vfiray,erayeq,trayeq,
	 nodray,nrfray,ityfar,cooray,fdfray,sufray,ncsray,ncfray,nesray,
	 ncfin,ncgros,barygr,baryfs,itrav,&idtrav,tabray,radios,
	 itrav1,itrav2,trav1,trav2,trav3,&totrai,tmpmax,tmpmin,itrmed);

  proc(recusy,RECUSY)(&lsyrth,&lcface,&lray,&ntsyr,&ncthfs,&ldern,&lstops,&lhisor,
		      &nchror,&lsdepl,&ntsmax,&ntsyrd,&lhisol,&nhrmax,&nbande,&ndprop,
		      &rdtts,&tempss,&nfreqs,&ltmax);
  fflush(stdout);

  free(itrav); free(itrav1); free(itrav2); free(itrmed);

  nodesf=(int*)malloc(max(nelesf*ndmasf,1)*sizeof(int));                   taill_i+=max(nelesf*ndmasf,1);
  nodraf=(int*)malloc(max(nelraf*ndmasf,1)*sizeof(int));                   taill_i+=max(nelraf*ndmasf,1);
  coordf=(double*)malloc(max(nbcouf*ndim,1)*sizeof(double));               taill_r+=max(nbcouf*ndim,1);
  cooraf=(double*)malloc(max(nbraf*ndim,1)*sizeof(double));                taill_r+=max(nbraf*ndim,1);
  ncoupf=(int*)malloc(max(nbcouf*2,1)*sizeof(int));                        taill_i+=max(nbcouf*2,1);
  nrapf=(int*)malloc(max(nbraf*2,1)*sizeof(int));                          taill_i+=max(nbraf*2,1);
  if (!nodesf||!nodraf||!coordf||!cooraf||!ncoupf||!nrapf)
    {printf("\n ERREUR D'ALLOCATION MEMOIRE 9\n");exit(0);}

  proc(mailfc,MAILFC)
          (&ndim,npoinf,nelebf,xyzf,&nbcouf,&nelesf,&ndmasf,
           coordf,nodebf,nodesf,ncoupf,
           &nbfils,&nwmail,&nwdn,&nwde,&nwncf1,&nwecf1,&nwdma1);

  ncfinf=(int*)malloc(max(nbraf,1)*sizeof(int));                           taill_i+=max(nbraf,1);
  ncgrof=(int*)malloc(max(nnfray*2,1)*sizeof(int));                        taill_i+=max(nnfray*2,1);
  ncbors=(int*)malloc(max(nbcous*nbicor,1)*sizeof(int));                   taill_i+=max(nbcous*nbicor,1);
  ncborf=(int*)malloc(max(nbcouf*nbicor,1)*sizeof(int));                   taill_i+=max(nbcouf*nbicor,1);

  baryfr=(double*)malloc(max(nnfray*ndim,1)*sizeof(double));               taill_r+=max(nnfray*ndim,1);
  baryff=(double*)malloc(max(nbraf*ndim,1)*sizeof(double));                taill_r+=max(nbraf*ndim,1);
  barys=(double*)malloc(max(nbcous*ndim,1)*sizeof(double));                taill_r+=max(nbcous*ndim,1);
  baryf=(double*)malloc(max(nbcouf*ndim,1)*sizeof(double));                taill_r+=max(nbcouf*ndim,1);
  vcoups=(double*)malloc(max(nbcous*2,1)*sizeof(double));                  taill_r+=max(nbcous*2,1);
  vcoupf=(double*)malloc(max(nbcouf*2,1)*sizeof(double));                  taill_r+=max(nbcouf*2,1);
  vrapf=(double*)malloc(max(nbraf*2,1)*sizeof(double));                    taill_r+=max(nbraf*2,1);
  if (!ncfinf||!ncgrof||!ncbors||!ncborf||
      !nodraf||!baryfr||!baryff||
      !barys||!baryf||!vcoups||!vcoupf||!vrapf)
    {printf("\n ERREUR D'ALLOCATION MEMOIRE 10\n");exit(0);}
  
  fflush(stdout);


  proc(cpusyr,CPUSYR)(&timsobc);

  itrav=(int*)malloc(max(idtrav,1)*sizeof(int)); 
  proc(inisf2,INISF2)
          (&ndim,&ndiele,&nbcouf,&nelesf,&ndmasf,&nbraf,&nelraf,&nbicor,&nbmobs,
	   &nbcous,&npoins,&nelems,&ndmats,&neless,&ndmass,
	   coordf,nodesf,ncoupf,cooraf,nrapf,
	   ncoups,nrefs,coords,nodes,nodess,
	   nodraf,ncbors,ncborf,barys,baryf,
	   &nelray,nrfray,&npoinr,nodray,cooray,
	   &nnfray,ncfray,ncfinf,ncgrof,baryfr,baryff,
	   itrav,&idtrav,&totrai,&calcium,trav1,trav2);

  free(itrav);
  proc(cpusyr,CPUSYR)(&timsoac);
  printf("\n **Temps CPU pour le calcul des correspondants fluide/solide: %f\n",abs(timsoac-timsobc));

  fflush(stdout);

  if (ntsmax==0) ntsmax=1000000;

  if (ltmax) for (i=0;i<npoins;i++) { *(tmpmax+i)=*(tmps+i); *(tmpmin+i)=*(tmps+i);}


  printf("\n\n ============================================================\n");
  printf("        Memoire totale pour la phase initiale :\n\n");
  printf("            Nombre d'entiers reserves : %9d\n",taill_i+taill_it);
  printf("                       soit par noeud : %9d\n\n",(taill_i+taill_it)/npoins);
  printf("            Nombre de reels  reserves : %9d\n",taill_r+taill_rt);
  printf("                       soit par noeud : %9d\n",(taill_r+taill_rt)/npoins); 
  printf("============================================================\n\n");

  proc(cpusyr,CPUSYR)(&timso2);
  totsoi = abs(timso2-timso1);totrai=abs(totrai);
  printf("\n **TEMPS CPU DES INITIALISATIONS SOLIDES : %f\n",abs(totsoi-totrai));
  printf("\n **TEMPS CPU DES INITIALISATIONS RAYONNEMENT : %f\n",totrai);

  proc(envosy,ENVOSY)(&lsyrth,&ntsyr,&ldern,&lstops,&tempss,&ntsmax);


  /* memoire pour la resolution */
  b=(double*)malloc(max(npoins,1)*sizeof(double));           taill_rr+=npoins;
  /*  if (!trav1) trav1=(double*)malloc(max(idtrav,1)*sizeof(double));       taill_rr+=idtrav; */
  /*  if (!trav2) trav2=(double*)malloc(max(idtrav,1)*sizeof(double));       taill_rr+=idtrav; */
  if (!trav3) trav3=(double*)malloc(max(idtrav,1)*sizeof(double));       taill_rr+=idtrav;
  if (!trav4) trav4=(double*)malloc(max(idtrav,1)*sizeof(double));       taill_rr+=idtrav;
  dmat=(double*)malloc(max(idtrav,1)*sizeof(double));        taill_rr+=idtrav;
  diag=(double*)malloc(max(npoins,1)*sizeof(double));        taill_rr+=npoins;

  if (!b||!trav1||!trav2||!trav3||!trav4||!dmat||!diag)
    {printf("\n ERREUR D'ALLOCATION MEMOIRE 11\n");exit(0);}

  xmat=(double*)malloc(max(nelems*ncoema,1)*sizeof(double)); taill_rr+=nelems*ncoema;
  wct=(double*)malloc(max(nelems*ndmats,1)*sizeof(double));  taill_rr+=nelems*ndmats;
  if (!xmat||!wct)
    {
      printf("\n ERREUR D'ALLOCATION MEMOIRE 12\n");
      printf("\n On cherche a allouer %d  reels supplementaires \n",nelems*(ncoema+ndmats));
      exit(0);
    }
  if (lcface) 
    {
      travf=(double*)malloc(max(neleus*ndmass,1)*sizeof(double)); taill_rr+=neleus*ndmass;
      if (!travf) {printf("\n ERREUR D'ALLOCATION MEMOIRE 13\n");exit(0);}
    }

  printf("\n\n ============================================================\n");
  printf("        Memoire totale pour la phase de resolution :\n\n");
  printf("            Nombre d'entiers reserves : %9d\n",taill_i);
  printf("                       soit par noeud : %9d\n\n",(taill_i)/npoins);
  printf("            Nombre de reels  reserves : %9d\n",taill_r+taill_rr);
  printf("                       soit par noeud : %9d\n",(taill_r+taill_rr)/npoins); 
  printf("============================================================\n\n");

  /* Premier passage des conditions limites du solide vers le fluide
     ===============================================================*/

  proc(trans1,TRANS1)(&ndim,&npoins,tmps,
		      &nbcouf,ncoupf,vcoupf,
		      &nbcous,ncoups,vcoups,
		      &nelesf,&ndmasf,nodesf,&neless,&ndmass,nodess,
		      &nbicor,baryf,ncborf,barys,ncbors,
		      npoinf,tf,hht);

  return 0;

}
