C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C                       *****************
                        SUBROUTINE LECID2
C                       *****************
C
C     ----------------------------------------------------------------
     *(NDIM,NDIELE,NPOINS,NELEMS,NFBIDA,
     * NBFACE,NN,IREF,INOEUD,IFACE,IELT)
C     ----------------------------------------------------------------
C
C***********************************************************************
C* SYRTHES 3.4.2                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C FONCTION :                                                           *
C ----------                                                           *
C             1ere LECTURE DU MAILLAGE ELEMENTS FINIS                  *
C             --> STRUCTURE DE DONNEE ISSUE DE IDEAS                   *
C             (Necessaire pour les dimensionnements de tableaux)       *
C                                                                      *
C             Modif en cours pour pouvoir lire des faces dans ideas    *
C                                                                      *
C-----------------------------------------------------------------------
C                             ARGUMENTS
C .___________.____.____.______________________________________________.
C !    NOM    !TYPE!MODE!                   ROLE                       !
C !___________!____!____!______________________________________________!
C !  A        ! TR ! A  ! TABLEAU DE TRAVAIL REEL                      !
C !  ILONRA   !  E ! D  ! DIMENSION DE A                               !
C !  IA       ! TE ! A  ! TABLEAUX DE TRAVAIL ENTIER                   !
C !  ILONIA   !  E ! D  ! DIMENSION DE IA                              !
C !___________!____!____!______________________________________________!
C ! COMMONS                                                            !
C !____________________________________________________________________!
C ! /XREFER/  !    ! D  !                                              !
C ! /NLOFES/  !    ! D  !                                              !
C ! /NLOFCT/  !    ! D  !                                              !
C !___________!____!____!______________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : CMPTNO,CMPTEL,CMPTFA,INREFA
C
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) :
C
C***********************************************************************
C
      IMPLICIT NONE
C
C***********************************************************************
C     DONNEES EN COMMON  
C **********************************************************************
C
#include "mobil.h"
#include "xrefer.h"
#include "nlofes.h"
#include "nlofct.h"
#include "optct.h"
C
C***********************************************************************
C 
      INTEGER NDX
      PARAMETER (NDX=10)
C
C.. Variables externes
      INTEGER NDIM,NDIELE,NPOINS,NELEMS,NBFACE,NN
      INTEGER IREF(NPOINS),INOEUD(NELEMS*NN),IFACE(NELEMS*NBFACE)
      INTEGER IELT(NELEMS)
C
C.. Variables internes
      INTEGER NDIMEF, NDSR,ITYE
      INTEGER I,J,NUM,ID,N1,N2,ICOU,NBNO,N,NSYS
      CHARACTER*80 CH
      INTEGER ITRIA6(6),ITET10(10)
C
      INTEGER NFBIDA,ICFA,NSF1,NSF2,NSF3
C***********************************************************************
C
      DATA ITRIA6 / 1,4,2,5,3,6 /
      DATA ITET10 / 1,8,4,9,2,5,7,10,6,3 /
C
      DO I=1,NELEMS*NBFACE
         IFACE(I) = 0
      ENDDO
C
C     0- INITIALISATIONS
C     ==================
      NDSR=0
C
C     1- TABLE DES NOEUDS
C     ===================
C
      CALL SECIDE(NFSGCT,2411)
C
      DO 140 N=1,NPOINS
        READ(NFSGCT,1200) NUM,NSYS,J,IREF(N)
        READ(NFSGCT,1201) CH
        NDSR  = MAX(NDSR,IREF(N))
  140 CONTINUE
C
C     4- TABLE DES ELEMENTS
C     =====================
C
      CALL SECIDE(NFSGCT,2412)
C
      DO 420 I=1,NELEMS
C
        READ(NFSGCT,4200,ERR=29,END=29) NUM,ID,N1,N2,IELT(I),NBNO
C
        ITYE   = ID
        IF (NDIELE.EQ.2) THEN
           IF (ID.EQ.92) THEN
              READ(NFSGCT,4201,ERR=29,END=29) 
     &             (INOEUD((ITRIA6(J)-1)*NELEMS+I),J=1,NBNO)
           ENDIF
        ELSEIF (NDIELE.EQ.3 ) THEN
           IF (ID.EQ.118) THEN
              READ(NFSGCT,4201,ERR=29,END=29) 
     &             (INOEUD((ITET10(J)-1)*NELEMS+I),J=1,NBNO)
           ELSE
              WRITE(NFECRA,5000) 
           ENDIF            
        ENDIF
C
  420 CONTINUE
C
   29 CONTINUE
C
C             On fait un traitement pour les faces des elements
      DO  I=1,NFBIDA
        READ(NFSGCT,4200,ERR=29,END=29) NUM,ID,N1,N2,ICFA,NBNO
C
        ITYE   = ID
        IF (NDIELE.EQ.3 .AND. ID.EQ.92) THEN
          READ(NFSGCT,4201,ERR=29,END=29) 
     &        NSF1,N1,NSF2,N1,NSF3,N1  
          CALL AFECTF(NSF1,NSF2,NSF3,ICFA,
     *                NDIM,NDIELE,NELEMS,NBNO,NBFACE,INOEUD,
     *                IFACE,NPOINS,IREF)
        ENDIF
        IF(NDIELE.EQ.2 .AND. ID.EQ.24) THEN
           NSF1 = 0
           NSF3 = 0
           READ(NFSGCT,4223) CH
           READ(NFSGCT,4224) NSF1,NSF3,NSF2
           CALL AFECTF(NSF1,NSF2,NSF3,ICFA,
     *          NDIM,NDIELE,NELEMS,NBNO,NBFACE,INOEUD,
     *          IFACE,NPOINS,IREF)      
        ENDIF
      ENDDO
chp        IF ((ID.EQ.92 .AND. NBNO.NE. 6) .OR.
chp     &      (ID.EQ.118 .AND. NBNO.NE. 10)) THEN
chp          WRITE(NFECRA,4210)
chp          STOP
chp        ENDIF       
C
C
chp      IF (ITYE.EQ.92) THEN
chp         NDIMEF = 2
chp      ELSE
chp         NDIMEF = 3
chp      ENDIF
C
C
C     5- REFERENCES SUR LES FACES
C     ===========================
C
      IF (LCFACE) THEN
        CALL INREFA (NDIM,NDIELE,NELEMS,NBNO,NBFACE,INOEUD,IFACE,
     *               NPOINS,IREF)
       ENDIF
C
C--------
C FORMATS
C--------
C 
 1200 FORMAT(4I10)
 1201 FORMAT(A80)
 1210 FORMAT(/,'  %% ERREUR LECID2 : LES COORDONNEES NE SONT PAS DANS',
     &       ' LE REPERE DE REFERENCE')
C
 1400 FORMAT(1P3D25.16)
C
 4200 FORMAT(6I10)
 4201 FORMAT(8I10)
 4223 FORMAT(A80)
 4224 FORMAT(3I10)
 4210 FORMAT(/,'  %% ERREUR LECID2 : LES ELEMENTS DOIVENT POSSEDER DES',
     &       ' NOEUDS MILIEUX')
C
 5000  FORMAT(/,' %% ERREUR LECID2 : Il y a une incoherence ')
C
      END
