C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C/MEMBR ADD NAME=ECRG1R,SSI=0
C
                        SUBROUTINE ECRG1R
C                       *****************
C
C     -------------------------------------------------
     *( NFIC,NDIM,NDIELE,NPOINR,NELRAY,NBNODE,
     *  COORAY,NODRAY,NRFRAY)
C     ------------------------------------------------
C***********************************************************************
C* SYRTHES 3.4.2                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C                                                                      *
C   FONCTION :                                                         *
C   --------                                                           *
C       GENERATION DU FICHIER GEOMETRIQUE POUR GRAFN3S                 *  
C       (destine uniquement au rayonnement)                            *
C       Triangle a 3 noeuds                                            *
C                                                                      *
C-----------------------------------------------------------------------
C               (*)   (*)                 ARGUMENTS
C   .________.______.____._____________________________________________.
C   !  NOM   ! TYPE !MODE!                  ROLE                       !
C   !________!______!____!_____________________________________________!
C   ! NFIC   !   E  ! D  ! NUMERO LOGIQUE DU FICHIER                   !
C   ! NDIM   !   E  ! D  ! DIMENSION DU PROBLEME (LOCAL)               !
C   ! NDIELE !   E  ! D  ! DIMENSION DES ELEMENTS DU MAILLAGE          !
C   !        !      !    !   1 -> segment                              !
C   !        !      !    !   2 -> triangle                             !
C   ! NPOINR !   E  ! D  ! NOMBRE DE NOEUDS DU MAILLAGE                !
C   ! NELRAY !   E  ! D  ! NOMBRE D'ELEMENTS DU MAILLAGE               !
C   ! NBNODE !   L  ! D  ! NOMBRE DE NOEUDS PAR ELEMENT                !
C   ! COORAY !  TR  !    ! TABLE DES COORDONNEES                       !
C   ! NODRAY !  TE  ! M  ! CONNECTIVITE DU MAILLAGE                    !
C   ! NRFRAY !  TE  ! D  ! REFERENCES DES FACES                        !
C   !________!______!____!_____________________________________________!
C   ! COMMONS                                                          !
C   !__________________________________________________________________!
C   !________!______!____!_____________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : ---
C                                   
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) : 
C
C***********************************************************************
C
      IMPLICIT NONE
C      
C**********************************************************************
C     DONNEES EN COMMON
C**********************************************************************
C
#include "nlofes.h"
C
C**********************************************************************
C.. Variables externes
      INTEGER NDIM,NDIELE,NPOINR,NELRAY,NBNODE 
      INTEGER NODRAY(NELRAY,NBNODE),NRFRAY(NELRAY),NFIC
      DOUBLE PRECISION  COORAY(NPOINR,NDIM)
C
C.. Variables internes
      INTEGER N,I,NNSOM,NG,ICOUL
      DOUBLE PRECISION XTCL
C
C**********************************************************************
C
C     0- INITIALISATIONS ET TRI DES NOEUDS
C     ====================================
C
C     0.1- Initialisations
C     --------------------
C
      XTCL   = 0
      ICOUL  = 0
C
C     0.2- differentiation des noeuds milieux et des noeuds sommets
C     -------------------------------------------------------------
C
      IF (NDIELE.EQ.1) THEN
         NNSOM = 2
      ELSEIF (NDIELE.EQ.2) THEN
         NNSOM = 3
      ELSE
         WRITE(NFECRA,999)
         STOP
      ENDIF
C
C        
C     1- ENTETE DU FICHIER (EN COMMENTAIRES)
C     ======================================
      WRITE(NFIC,1100)
      WRITE(NFIC,1110) NDIM,NDIELE,NPOINR,NELRAY,NBNODE
C
C
C     2- ECRITURE DE LA TABLE DES NOEUDS
C     ==================================
C
      WRITE(NFIC,2000)
C
      DO 209 NG = 1,NPOINR
         DO 210 I = 1,NDIM
            IF (ABS(COORAY(NG,I)) .LE. 1.E-10) COORAY(NG,I) = 0.D0
 210     CONTINUE
 209  CONTINUE
C
        IF (NDIM.EQ.2) THEN
C
          DO 211 N=1,NPOINR
            WRITE(NFIC,2100)
     &            N,ICOUL,(COORAY(N,I),I=1,2),XTCL
  211     CONTINUE
C
        ELSEIF (NDIM.EQ.3) THEN
C
          DO 212 N=1,NPOINR
            WRITE(NFIC,2100)
     &            N,ICOUL,(COORAY(N,I),I=1,3)
  212     CONTINUE
C
        ENDIF
C
  200 CONTINUE
C
C
C     3- ECRITURE DE LA TABLE DES ELEMENTS
C     ====================================
C
      WRITE(NFIC,3000)
C
C
C     3.1- Segements a 2 noeuds
C     -------------------------
      IF (NDIELE.EQ.1 .AND. NBNODE.EQ.2) THEN
        DO 310 N=1,NELRAY
           WRITE(NFIC,3100) N,NRFRAY(N),(NODRAY(N,I),I=1,2)
 310    CONTINUE

C     3.2- Triangles a 3 noeuds
C     -------------------------
      ELSEIF (NDIELE.EQ.2 .AND. NBNODE.EQ.3) THEN
        DO 320 N=1,NELRAY
           WRITE(NFIC,3200) N,NRFRAY(N),(NODRAY(N,I),I=1,3)
 320    CONTINUE
C
C     3.3- Elements inconnus
C     ----------------------
      ELSE
        WRITE(NFECRA,3300)
        STOP
C
      ENDIF
C
      CALL FLUSHF(NFIC)
C
C--------
C FORMATS
C--------
C
 999  FORMAT(' %% ERREUR ECRG1R : la dimension des elements (NDIELE)',
     &       ' est incorrecte') 
1100  FORMAT(
     &  'C************************************************C',/,
     &  'C   FICHIER GEOMETRIQUE SYRTHES - Rayonnement -  C',/,
     &  'C************************************************C')
      
1110  FORMAT(
     &  'C  DIMENSION = ',I1,'  DIMENSION DES ELTS = ',I1,/,
     &  'C  NOMBRE DE NOEUDS = ',I10,/,
     &  'C  NOMBRE D''ELEMENTS =',I10,/,
     &  'C  NOMBRE DE NOEUDS PAR ELEMENT = ',I3,/,
     &  'C************************************************C')
C
 2000 FORMAT('C',/,'C$ RUBRIQUE = NOEUDS',/,'C')
 2100 FORMAT(I10,I3,1X,3(E14.7,1X))
C
 3000 FORMAT('C',/,'C$ RUBRIQUE = ELEMENTS',/,'C')
 3100 FORMAT(I10,I3,2I10)
 3200 FORMAT(I10,I3,3I10)
 3300 FORMAT(/,'  %% ECRG1R : TYPE D''ELEMENTS INCONNUS')
C 
C
      END
