C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C                       *****************
                        SUBROUTINE CMPSOM
C                       *****************
C
C     -------------------------------------------------
     *(NDIELE,NBPOIN,NBELE,NBNODE,NODE,NBSOM,ITRAV)
C     ------------------------------------------------
C***********************************************************************
C* SYRTHES 3.4.2                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C                                                                      *
C   FONCTION :                                                         *
C   --------                                                           *
C       GENERATION DU FICHIER GEOMETRIQUE POUR GRAFN3S                 *  
C                                                                      *
C-----------------------------------------------------------------------
C               (*)   (*)                 ARGUMENTS
C   .________.______.____._____________________________________________.
C   !  NOM   ! TYPE !MODE!                  ROLE                       !
C   !________!______!____!_____________________________________________!
C   ! NDIELE !   E  ! D  ! DIMENSION DES ELEMENTS DU MAILLAGE          !
C   ! NBPOIN !   E  ! D  ! NOMBRE DE NOEUDS DU MAILLAGE                !
C   ! NBELE  !   E  ! D  ! NOMBRE D'ELEMENTS DU MAILLAGE               !
C   ! NBNODE !   L  ! D  ! NOMBRE DE NOEUDS PAR ELEMENT                !
C   ! NODE   !  TE  ! M  ! CONNECTIVITE DU MAILLAGE                    !
C   ! NBSOM  !   E  ! R  ! NOMBRE DE NOEUDS SOMMETS DU MAILLAGE        !
C   ! ITRAV  !  TE  ! M  ! TABLEAU DE TRAVAIL                          !
C   !________!______!____!_____________________________________________!
C   ! COMMONS                                                          !
C   !__________________________________________________________________!
C   !________!______!____!_____________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : ---
C                                   
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) : 
C
C***********************************************************************
C
      IMPLICIT NONE
C      
C**********************************************************************
C     DONNEES EN COMMON
C**********************************************************************
C
#include "nlofes.h"
C
C**********************************************************************
C.. Variables externes
      INTEGER NDIELE,NBPOIN,NBELE,NBNODE
      INTEGER NODE(NBELE,NBNODE),NBSOM
      INTEGER ITRAV(NBPOIN)
C
C.. Variables internes
      INTEGER N,I,NNSOM
C
C**********************************************************************
C
      DO N=1,NBPOIN
         ITRAV(N) = 0
      ENDDO
C
      IF (NDIELE.EQ.1) THEN
         NNSOM = 2
      ELSEIF (NDIELE.EQ.2) THEN
         NNSOM = 3
      ELSEIF (NDIELE.EQ.3) THEN
         NNSOM = 4
      ENDIF
C
      DO N=1,NBELE
        DO I=1,NNSOM
           ITRAV (NODE(N,I)) = 1
        ENDDO
      ENDDO
C
C
      NBSOM = 0
C      
      DO N=1,NBPOIN      
        IF (ITRAV(N).NE.0) THEN
           NBSOM = NBSOM + 1
        ENDIF
      ENDDO 
C
      END
