C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C/MEMBR ADD NAME=ASSEUS,SSI=0
C
                     SUBROUTINE ASSEUS
C                    *****************
C
C     -----------------------------------------------------
     *( VECTUS,NODEUS,NELEMS,NELEUS,NPOINS,NDMASS,NDIM,WCT)
C     -----------------------------------------------------
C***********************************************************************
C* SYRTHES 3.4.2                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C                                                                      *
C      FONCTION :                                                      *
C      ---------     ASSEMBLAGE DES VECTEURS DE BORD POUR LES FLUX     *
C                    CAS BIDIMENSIONNEL, AXISYMETRIQUE                 *
C                    ET TRIDIMENSIONNEL.                               *
C                    Vecteur non necessairement initialise a 0         *
C                                                                      *
C     ATTENTION : Dans ce sous-programme on force la vectorisation     *
C                 si l'instruction CDIR$ est active                    *  
C                 ce qui suppose un arrangement des elements adapte.   *
C                                                                      *
C-----------------------------------------------------------------------
C		    (*)    (*)			ARGUMENTS
C   .___________.______._______________________________________________.
C   !    NOM    ! TYPE !MODE!                    ROLE                  !
C   !___________!______!____!__________________________________________!
C   !   VECTUS  !  TR  ! R  ! VECTEUR CONTENANT LA CONTRIBUTION DE BORD!
C   !   NODEUS  !  TE  ! D  ! NUMERO DES NOEUDS ( LOCALE --> GLOBALE ) !
C   !   WCT     !  TR  ! M  ! TABLEAUX DE TRAVAIL  (NELEUS*NDMASS)     !
C   !___________!______!____!__________________________________________!
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C    SOUS PROGRAMME(S) APPELE(S)    : ????
C                                     ????
C-----------------------------------------------------------------------
C    SOUS PROGRAMME(S) APPELANT(S)  : ????
C
C***********************************************************************
C
	IMPLICIT NONE
C
C***********************************************************************
C	DONNEES EN COMMON
C***********************************************************************
C
#include "divct.h"
C
C***********************************************************************
C 
      INTEGER NPOINS,NDMASS,NELEMS,NELEUS,NDIM
C
      INTEGER NODEUS(NELEUS,NDMASS)
      DOUBLE PRECISION VECTUS(NPOINS)
      DOUBLE PRECISION WCT(NELEMS,NDMASS)
C    
C     variables internes  
      INTEGER I,INODE
C
C***********************************************************************
C
C     1. BOUCLE SUR CHAQUE ELEMENT
C        =========================
C     
       IF (LVECTB) THEN

          IF ( NDIM .EQ. 2 ) THEN
C
CDIR$ IVDEP
              DO I=1,NELEUS
                  INODE = NODEUS(I,1)
                  VECTUS(INODE) = VECTUS(INODE) + WCT(I,1)
              ENDDO
C 
CDIR$ IVDEP         
              DO I=1,NELEUS
                  INODE = NODEUS(I,2)
                  VECTUS(INODE) = VECTUS(INODE) + WCT(I,2)
              ENDDO
C 
CDIR$ IVDEP         
              DO I=1,NELEUS
                  INODE = NODEUS(I,3)
                  VECTUS(INODE) = VECTUS(INODE) + WCT(I,3)
              ENDDO                 
C          
          ELSE
C
CDIR$ IVDEP
              DO I=1,NELEUS
                  INODE = NODEUS(I,1)
                  VECTUS(INODE) = VECTUS(INODE) + WCT(I,1)
              ENDDO
C
CDIR$ IVDEP
              DO I=1,NELEUS
                  INODE = NODEUS(I,2)
                  VECTUS(INODE) = VECTUS(INODE) + WCT(I,2)
              ENDDO         
C
CDIR$ IVDEP
              DO I=1,NELEUS
                  INODE = NODEUS(I,3)
                  VECTUS(INODE) = VECTUS(INODE) + WCT(I,3)
              ENDDO
C
CDIR$ IVDEP
              DO I=1,NELEUS
                  INODE = NODEUS(I,4)
                  VECTUS(INODE) = VECTUS(INODE) + WCT(I,4)
              ENDDO
C
CDIR$ IVDEP
              DO I=1,NELEUS
                  INODE = NODEUS(I,5)
                  VECTUS(INODE) = VECTUS(INODE) + WCT(I,5)
              ENDDO
C
CDIR$ IVDEP
              DO I=1,NELEUS
                  INODE = NODEUS(I,6)
                  VECTUS(INODE) = VECTUS(INODE) + WCT(I,6)
              ENDDO
C
C         Fin du cas 3D
          ENDIF
C
       ELSE

          IF ( NDIM .EQ. 2 ) THEN
C
              DO I=1,NELEUS
                  INODE = NODEUS(I,1)
                  VECTUS(INODE) = VECTUS(INODE) + WCT(I,1)
              ENDDO
C 
              DO I=1,NELEUS
                  INODE = NODEUS(I,2)
                  VECTUS(INODE) = VECTUS(INODE) + WCT(I,2)
              ENDDO
C 
              DO I=1,NELEUS
                  INODE = NODEUS(I,3)
                  VECTUS(INODE) = VECTUS(INODE) + WCT(I,3)
              ENDDO                   
C          
          ELSE
C
              DO I=1,NELEUS
                  INODE = NODEUS(I,1)
                  VECTUS(INODE) = VECTUS(INODE) + WCT(I,1)
              ENDDO
C
              DO I=1,NELEUS
                  INODE = NODEUS(I,2)
                  VECTUS(INODE) = VECTUS(INODE) + WCT(I,2)
              ENDDO        
C
              DO I=1,NELEUS
                  INODE = NODEUS(I,3)
                  VECTUS(INODE) = VECTUS(INODE) + WCT(I,3)
              ENDDO
C
              DO I=1,NELEUS
                  INODE = NODEUS(I,4)
                  VECTUS(INODE) = VECTUS(INODE) + WCT(I,4)
              ENDDO
C
              DO I=1,NELEUS
                  INODE = NODEUS(I,5)
                  VECTUS(INODE) = VECTUS(INODE) + WCT(I,5)
              ENDDO
C
              DO I=1,NELEUS
                  INODE = NODEUS(I,6)
                  VECTUS(INODE) = VECTUS(INODE) + WCT(I,6)
              ENDDO
C
C         Fin du cas 3D
          ENDIF
C
       ENDIF
C
      RETURN
      END   
