// Copyright (C) 2006-2009 Kent-Andre Mardal and Simula Research Laboratory.
// Licensed under the GNU GPL Version 2, or (at your option) any later version.

#include "utilities.h"
#include "syfi_version.h"

#include <sstream>
#include <math.h>

using namespace std;

namespace SyFi
{

	/* Version information buried into the library */
	const int version_major = SYFILIB_MAJOR_VERSION;
	const int version_minor = SYFILIB_MINOR_VERSION;
	const int version_micro = SYFILIB_MICRO_VERSION;

	int dirac(unsigned int i, unsigned int j)
	{
		if (i==j) return 1;
		else return 0;
	}

	string int2string(int i)
	{
		ostringstream os;
		os << i;
		return os.str();
	}

	string istr(const string & a, int b)
	{
		ostringstream s;
		s << a << b;
		return s.str();
	}

	string istr(const string & a, int b, int c)
	{
		ostringstream s;
		s << a << b << "_" <<c;
		return s.str();
	}

	string lst2string(GiNaC::lst& l)
	{

		ostringstream s;
		GiNaC::lst::const_iterator i = l.begin();
		s <<"("<<*i;
		++i;

		for (; i != l.end() ; ++i)
		{
			s<< ","<< *i;
		}
		s <<");"<<endl;
		return s.str();
	}

	string exvector2string(GiNaC::exvector& v)
	{
		ostringstream s;
		s <<"[";
		for (unsigned int i=0; i< v.size()-1; i++)
		{
			s <<v[i]<<",";
		}
		s<<v[v.size()-1]<< "]";
		return s.str();
	}

	void print(GiNaC::lst& l)
	{
		//  for (GiNaC::lst::const_iterator i = l.begin(); i != l.end(); ++i)
		//    cout << *i << endl;
		//
		GiNaC::lst::const_iterator i = l.begin();
		cout <<"GiNaC::lst("<<*i;
		++i;

		for (; i != l.end() ; ++i)
		{
			cout << ","<< *i;
		}
		cout <<");"<<endl;
	}

	void print(GiNaC::exvector& v)
	{
		cout <<"v=[";
		for (unsigned int i=0; i< v.size()-1; i++)
		{
			cout <<v[i]<<"," <<endl;
		}
		cout <<v[v.size()-1]<< "]"<<endl;
	}

	void print(std::map<std::pair<unsigned int,unsigned int>, GiNaC::ex>& A)
	{
		map<std::pair<unsigned int,unsigned int>,GiNaC::ex>::iterator iter;
		for (iter = A.begin(); iter != A.end() ; iter++)
		{
			cout <<"A["<<(*iter).first.first<<","<<(*iter).first.second<<"]="<<(*iter).second<<endl;
		}
	}

	void print(ex_int_map map)
	{
		GiNaC::ex b;
		int c=0;
		ex_int_map::iterator iter;
		iter = map.begin();
		cout <<"{";
		for (iter = map.begin(); iter != map.end(); iter++)
		{
			b = (*iter).first; c = map[b];
			cout <<", "<<b<<":"<<c;
		}
		cout <<"}"<<endl;
	}

	void print(GiNaC::exmap map)
	{
		GiNaC::ex b;
		GiNaC::ex c;
		GiNaC::exmap::iterator iter;
		cout <<"{" <<b<<":"<<c;
		for (iter = map.begin(); iter != map.end(); iter++)
		{
			b = (*iter).first; c = map[b];
			cout <<", "<<b<<":"<<c;
		}
		cout <<"}"<<endl;
	}

}
