// Copyright (C) 2006-2009 Kent-Andre Mardal and Simula Research Laboratory.
// Licensed under the GNU GPL Version 2, or (at your option) any later version.

#ifndef GINAC_TOOLS_IS_INCLUDED
#define GINAC_TOOLS_IS_INCLUDED

#include <string>
#include <iostream>
#include <map>

#include <ginac/ginac.h>

#include "utilities.h"

namespace SyFi
{

	bool compare(const GiNaC::ex & e, const std::string & s);

	void EQUAL_OR_DIE(const GiNaC::ex & e, const std::string & s);

	// Read two archive files and compare the expressions.
	// If any expressions are not equal, prints them and
	// returns false. Returns true if all expressions are equal.
	bool compare_archives(const std::string & first, const std::string & second, std::ostream & os=std::cout);

	// using lst as a vector
	// inner product of vectors or lst
	GiNaC::ex inner(GiNaC::ex a, GiNaC::ex b, bool transposed = false);
	GiNaC::ex inner(GiNaC::exvector& v1, GiNaC::exvector& v2);
	GiNaC::ex inner(GiNaC::lst v1, GiNaC::lst v2);
	GiNaC::lst cross(GiNaC::lst& v1, GiNaC::lst& v2);
	// matrix vector product
	GiNaC::lst matvec(GiNaC::matrix& M, GiNaC::lst& x);
	GiNaC::ex  matvec(GiNaC::ex A, GiNaC::ex x);

	GiNaC::lst ex2equations(GiNaC::ex rel);
	GiNaC::lst collapse(GiNaC::lst l);

	GiNaC::matrix equations2matrix (const GiNaC::ex &eqns, const GiNaC::ex &symbols);
	void matrix_from_equations(const GiNaC::ex &eqns, const GiNaC::ex &symbols, GiNaC::matrix &A, GiNaC::matrix& b);

	GiNaC::ex  lst_to_matrix2(const GiNaC::lst & l);
	GiNaC::lst matrix_to_lst2(const GiNaC::ex & m );

	GiNaC::lst lst_equals(GiNaC::ex a, GiNaC::ex b);

	// FIXME bad name
	int find(GiNaC::ex e, GiNaC::lst list);

	// TODO: remove these two:
	void check_visitor(GiNaC::ex e, GiNaC::lst& exlist);
	void visitor_subst_pow(GiNaC::ex e, GiNaC::exmap& map, ex_int_map& intmap, std::string a);

	// generates a polynom of arbitrary order on a line, a triangle, or a tetrahedron
	GiNaC::ex pol(unsigned int order, unsigned int nsd, const std::string a);
	// generates a vector polynom of arbitrary order on a line, a triangle or a tetrahedron
	GiNaC::lst polv(unsigned int no_fields, unsigned int order, unsigned int nsd, const std::string a);
	// generates a polynom of arbitrary order on a square or a box
	GiNaC::ex polb(unsigned int order, unsigned int nsd, const std::string a);
	// generates a vector polynom of arbitrary order on a squart or a box
	//lst polbv(int order, int nsd, const std::string a);

	// generates a homogenous polynom of arbitrary order on a line, a triangle, or a tetrahedron
	GiNaC::ex homogenous_pol(unsigned int order, unsigned int nsd, const std::string a);
	// generates a homogenous vector polynom of arbitrary order
	GiNaC::lst homogenous_polv(unsigned int no_fields, unsigned int order, unsigned int nsd, const std::string a);

	// generates a Legendre polynom of arbitrary order
	GiNaC::ex legendre(unsigned int order, unsigned int nsd, const std::string a);
	// generates a Legendre vector polynom of arbitrary order
	GiNaC::lst legendrev(unsigned int no_fields, unsigned int order, unsigned int nsd, const std::string a);

	// extracts the coefficents from a polynomial
	GiNaC::exvector coeff(GiNaC::ex pol);
	GiNaC::lst      coeffs(GiNaC::ex pol);
	GiNaC::lst      coeffs(GiNaC::lst pols);

	// extract the basisfunctions and corresponding coefficents from a polynomial
	GiNaC::exmap  pol2basisandcoeff(GiNaC::ex e);
	GiNaC::exmap  pol2basisandcoeff(GiNaC::ex e, GiNaC::ex s);

	// Collect all symbols of an expression
	void collect_symbols(const GiNaC::ex & e, exset & v);

	GiNaC::exvector collect_symbols(const GiNaC::ex & e);

	// Builds a map with the number of occurrences of each symbol.
	// Highly dependent on the current form of the expression.
	GiNaC::exhashmap<int> count_symbols(const GiNaC::ex & e);

	// Extract all symbols into a lst. Useful for comparing
	// expressions to other ex read from an archive.
	GiNaC::ex extract_symbols(const GiNaC::ex & e);

	//std::list<GiNaC::ex> get_symbols(const GiNaC::ex & e);
	//GiNaC::exvector get_symbols(const GiNaC::ex & e);
	//void get_symbols(const GiNaC::ex & e, GiNaC::exmap & em);

	// Utility class to collect statistics about an expression.
	class ExStats
	{
		public:
			ExStats(): muls(0), adds(0), pows(0), functions(0), flops(0) {}

			inline const ExStats & operator+=(const ExStats & rhs)
			{
				muls      += rhs.muls;
				adds      += rhs.adds;
				pows      += rhs.pows;
				functions += rhs.functions;
				flops     += rhs.flops;
				return *this;
			}

			int muls;
			int adds;

			int pows;
			int functions;

			// flops = sum of multiplications and additions, with integer powers interpreted as many multiplications
			int flops;
	};

	// Count the number of operations in an expression.
	ExStats count_ops(const GiNaC::ex & e);

	// ===== expression manipulation

	GiNaC::ex replace_powers(const GiNaC::ex & e, const std::list<GiNaC::symbol> & symbols, std::list<symexpair> & sel, const std::string & tmpsymbolprefix="p_");

};								 // namespace SyFi
#endif
