// Copyright (C) 2006-2009 Kent-Andre Mardal and Simula Research Laboratory.
// Licensed under the GNU GPL Version 2, or (at your option) any later version.

#ifndef SYFI_IS_INCLUDED
#define SYFI_IS_INCLUDED

// misc
#include "syfi_version.h"
#include "tools.h"

// dof mapping
#include "Dof.h"
#include "DofT.h"

// base classes for element hierarchy
#include "Polygon.h"
#include "FE.h"
#include "MixedFE.h"

// concrete element implementations
#include "Lagrange.h"
#include "CrouzeixRaviart.h"
#include "P0.h"
#include "RaviartThomas.h"
#include "BrezziDouglasMarini.h"
#include "DiscontinuousLagrange.h"
#include "Hermite.h"
#include "Nedelec.h"
#include "Nedelec2Hdiv.h"
#include "Bubble.h"
#include "ArnoldFalkWintherWeakSym.h"
#include "Robust.h"
#include "SpaceTimeElement.h"

// example code
#include "ElementComputations.h"

// code generation related
/*
#include "TempSymbolHandler.h"
#include "ExpressionCollection.h"
#include "ExpressionSimplifier.h"
*/
#endif
