/***************************************************************************
 *   Copyright (C) 2004 by Ivan Forcada Atienza                            *
 *   ivan@forcada.info                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef FRMCONFIGINI_H
#define FRMCONFIGINI_H

#include "dlgConfigIni.h"
#include "swsconfig.h"

#include <klocale.h>
#include <kiconloader.h>
#include <kdialogbase.h>
#include <kfiledialog.h>
#include <kmessagebox.h>

#include <qlineedit.h>
#include <qobjectlist.h>
#include <qcombobox.h>
#include <qcheckbox.h>
#include <qpushbutton.h>

class frmConfigIni : public KDialogBase {
  Q_OBJECT
  	//configIni 	conf;		// obsolete
	SWSconfig 	conf;		// configuration parameters
	dlgConfigIni *	d;		// Main dialog
	
public:
	frmConfigIni(QWidget* parent = 0, const char* name = 0, bool modal = true);
	~frmConfigIni();
	/*$PUBLIC_FUNCTIONS$*/
	QComboBox * getCmbParity() { return d->cmbParity; };
	QComboBox * getCmbStop() { return d->cmbStop; };
	QComboBox * getCmbBits() { return d->cmbBits; };
	QComboBox * getCmbBaud() { return d->cmbBaud; };
	
	
public slots:
	/*$PUBLIC_SLOTS$*/
	virtual void	slotApply();
	virtual void	findDevice();
	virtual void	findFile();
	virtual void	findDHCP();
	virtual void	findTerminal();
	virtual void	chkTerminalChanged(bool checked);

protected:
	/*$PROTECTED_FUNCTIONS$*/

protected slots:
	/*$PROTECTED_SLOTS$*/

};

#endif

