/*
 *  dixchange.h
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#ifndef __DIXCHANGE_H__
#define __DIXCHANGE_H__

#include <glib.h>

#define DIXCHANGE_URI "http://dixchange.sourceforge.jp/dixchange.dtd"

typedef struct _dixchange_usage dixchange_usage;
typedef struct _dixchange_word dixchange_word;

struct _dixchange_word {
    gchar *literal;
    gchar *phonetic;
    gchar *pos;
    gchar *cclass;
    gchar *score;
    GList *usage;
};

struct _dixchange_usage {
    gchar *category;
    gchar *score;
};

GList *dixchange_parse        (const char* filename);
GList *dixchange_append_word  (GList *, gchar *, gchar *, gchar *, gchar *, gchar *);
void   dixchange_append_usage (GList *, gchar *, gchar *);
void   dixchange_word_free    (GList *);
void   dixchange_usage_free   (GList *);

#endif /* __DIXCHANGE__H__ */
