/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_ADDPARAM_H
#define _SC_ADDPARAM_H

// sc
#include "ScParam.h"
#include "svn/ClientTypes.h"
#include "util/String.h"


/**
 * Parameter class for AddCmd.
 */
class AddParam : public ScParam
{
public:
  AddParam( const svn::Paths& paths, bool recurse, bool force )
    : _paths(paths), _recurse(recurse), _force(force)
  {
  }

  const svn::Paths& getPaths() const
  {
    return _paths;
  }

  bool getRecurse() const
  {
    return _recurse;
  }

  bool getForce() const
  {
    return _force;
  }

  ScParamAccept(AddParam);

private:
  // in
  svn::Paths _paths;
  bool       _recurse;
  bool       _force;
};

#endif // _SC_ADDPARAM_H
