/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "ScLvi.h"
#include "ProjectLvi.h"
#include "events/LoggingEvent.h"
#include "events/EventSupport.h"
#include "sublib/TargetId.h"
#include "sublib/TargetRepository.h"

// sys
#include <cassert>

// qt
#include <QtGui/QWidget>


// id factory
static long ScLviId = 0;


ScLvi::ScLvi( QListView* parent, QString string )
  : super(parent,string), _inRename(false)
{
  initId();

  setDragEnabled(true);
  setDropEnabled(true);

  setRenameEnabled(0,true);
}

ScLvi::ScLvi( QListViewItem* parent, QString string )
  : super(parent,string), _inRename(false)
{
  initId();

  setDragEnabled(true);
  setDropEnabled(true);

  setRenameEnabled(0,true);
}

ScLvi::~ScLvi()
{
}

void ScLvi::initId()
{
  ScLviId++;
  _id = ScLviId;
}

void ScLvi::onItem()
{
}

void ScLvi::expanded()
{
  //printf("ScLvi:expanded()\n");
}

void ScLvi::collapsed()
{
  //printf("ScLvi:collapsed()\n");
}

void ScLvi::pressed( bool refresh )
{
  //printf("ScLvi:pressed()\n");
}

void ScLvi::clicked()
{
  //printf("ScLvi:clicked()\n");
}

void ScLvi::doubleClicked()
{
  //printf("ScLvi:doubleClicked()\n");
}

void ScLvi::selectionChanged()
{
  //printf("ScLvi:selectionChanged()\n");
}

void ScLvi::rightButtonClicked( const QPoint& pos )
{
  //printf("ScLvi:rightButtonClicked()\n");
}

void ScLvi::returnPressed()
{
  //printf("ScLvi:returnPressed()\n");
}

void ScLvi::contextMenuRequest( const QPoint& p, int col )
{
  //printf("ScLvi:contextMenuRequest()\n");
}

void ScLvi::renamed( const QString& text )
{
}

void ScLvi::setSelected( bool b )
{
  //printf("ScLvi:setSelected(%p %s)\n", this, b ? "true" : "false" );

  if( b )
  {
    enableActions();
  }
  else
  {
    disableActions();
  }

  super::setSelected(b);
}

void ScLvi::clear()
{
  QListViewItem* ilvi = 0;
  while( (ilvi = this->firstChild()) )
  {
    takeItem(ilvi);
    delete ilvi;
  }
}

void ScLvi::enableActions()
{
  //printf("ScLvi::enableActions()\n");
}

void ScLvi::disableActions()
{
  //printf("ScLvi::disableActions()\n");
}

ID ScLvi::getTid() const
{
  return TargetId::getTid(listView());
}

QObject* ScLvi::getTidObj() const
{
  return listView();
}

void ScLvi::dropEvent( QDropEvent* e )
{
  dropped(e);
}

ProjectLvi* ScLvi::getProjectLvi()
{
  ProjectLvi* lvi = dynamic_cast<ProjectLvi*>(this);
  if( lvi )
  {
    return lvi;
  }
  else
  {
    ScLvi* sclvi = dynamic_cast<ScLvi*>(parent());
    return sclvi->getProjectLvi();
  }
}

void ScLvi::okRename( int col )
{
  _inRename = true;
  super::okRename(col);
  _inRename = false;
}

bool ScLvi::isRename() const
{
  return _inRename;
}

long ScLvi::getId() const
{
  return _id;
}

bool ScLvi::isSelectable( QListViewItem* prev ) const
{
  return this != prev;
}
