/* ====================================================================
 * Copyright (c) 2003-2007, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "uuid.h"
#include "apr.h"
#include "AprException.h"

// sys
#include <string.h>


Uuid Uuid::createEmpty()
{
  return Uuid(false);
}

Uuid Uuid::createUuid()
{
  return Uuid(true);
}

Uuid::Uuid( const Uuid& src )
{
  this->operator =(src);
}

void Uuid::operator=( const Uuid& src )
{
  _uuid = src._uuid;
}

Uuid::Uuid( bool init )
{
  if( init )
  {
    apr_uuid_get( &_uuid );
  }
}

Uuid::Uuid( const char* uuid )
{
  apr_status_t status = apr_uuid_parse( &_uuid, uuid );

  if( status != APR_SUCCESS )
  {
    sc::String val(uuid);
    throw apr::Exception( status, val );
  }
}

bool Uuid::operator==( const Uuid& src ) const
{
  return 0 == ::memcmp( _uuid.data, src._uuid.data, 16 );
}

sc::String Uuid::toString() const
{
  char* uuid = new char[APR_UUID_FORMATTED_LENGTH+1];
  apr_uuid_format( uuid, &_uuid );
  sc::String result = sc::String(uuid);
  delete[] uuid;
  return result;
}
