/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "config.h"
#include "apr.h"
#include "AprException.h"

// apr
#include <apr.h>
#include <apr_general.h>
#include <apr_portable.h>


namespace apr
{

void initialize( int argc, char* argv[] )
{
  int                argc_utf8 = argc;
  const char* const *argv_utf8 = argv;

  apr_status_t status = apr_app_initialize( &argc_utf8, &argv_utf8, NULL );
  if( status != APR_SUCCESS )
  {
    throw Exception( status, _s("failed to initialize apr") );
  }

  if( atexit(apr_terminate) )
  {
    throw Exception( 0, _s("failed to register apr_terminate (atexit)") );
  }
}


apr_pool_t* createPool( apr_pool_t* parent )
{
  apr_pool_t*  pool   = 0;
  apr_status_t status = apr_pool_create( &pool, parent );
  
  if( status != APR_SUCCESS )
  {
    throw Exception( status, _s("failed to create pool") );
  }
  return pool;
}

void destroyPool( apr_pool_t* pool )
{
  apr_pool_destroy(pool);
}

sc::String getDefaultEncoding()
{
  Pool p;
  const char* encoding = apr_os_default_encoding(p);
  //printf("default encoding: %s\n",encoding);
  return sc::String(encoding);    
}

sc::String getLocaleEncoding()
{
  Pool p;
  const char* encoding = apr_os_locale_encoding(p);
  //printf("locale encoding: %s\n",encoding);
  return sc::String(encoding);  
}


} // namespace
