/* ------------------------------------------------------------------------ */
/*                                                                          */
/* [prs_abs.h]              Abstract LR Parser Interface                    */
/*                                                                          */
/* Copyright (c) 2002 by D\olle, Manns                                      */
/* ------------------------------------------------------------------------ */

/* File generated by 'ctoh'. Don't change manually. */

#ifndef prs_abs_INCL
#define prs_abs_INCL


#include "prs_dfn.h"


#ifdef __cplusplus
extern "C" {
#endif


/* 
   <p>This module [prs_abs] provides an abstract LR parser interface for the
   term generation module <a href="ptm_gen.htm">[ptm_gen]</a>.
   <p>It can be used to integrate an externally defined parser with the STYX term
   generation facility.
*/

/* ----------------------------- The Types --------------------------------- */

AbstractType(AbsPlr_T); /* Abstract parser interface type */

/*  
  Types of the parser (interface and configuration) functions
*/

typedef int      (*PF_cfgsize )(Abs_T parser);
typedef int      (*PF_symType )(Abs_T parser, int symID);
typedef c_string (*PF_symName )(Abs_T parser, int symID);
typedef int      (*PF_startSym)(Abs_T parser, int startID);
typedef int      (*PF_prodNT  )(Abs_T parser, int prodID);
typedef c_string (*PF_prodName)(Abs_T parser, int prodID);
typedef int      (*PIF_nextTok)(AbsPlr_T pconfig);
typedef c_string (*PIF_curTok )(AbsPlr_T pconfig);
typedef Any_T    (*PIF_topVal )(AbsPlr_T pconfig);
typedef Any_T    (*PIF_shift  )(AbsPlr_T pconfig, int symID);
typedef Any_T    (*PIF_reduce )
                 (
                   AbsPlr_T pconfig, int symcnt, int prodID, c_bool accept
                 );
typedef c_bool   (*PIF_parse  )
                 (
                   AbsPlr_T pconfig, c_string symStart, c_bool early
                 );
typedef c_bool   (*PIF_accept )(AbsPlr_T pconfig);
typedef void     (*PIF_error  )(AbsPlr_T pconfig);
typedef void     (*PIF_debug  )(AbsPlr_T pconfig, Any_T value);

/* ---------------------------- Init & Quit -------------------------------- */

AbsPlr_T AP_init(void);             /* creates an abstract parser interface */

void AP_quit(AbsPlr_T pconfig)
/* removes abstract parser interface 'pconfig' */
;


/* --------------- Specification of the external parser interface ---------- */

void AP_setParser(AbsPlr_T pconfig, Abs_T parser)
/* specifies the external 'parser' of the abstract interface 'pconfig' */
;


/* 
  <p>An external defined parser must provide the following interface
     functions. They have to be assigned to the abstract parser interface
     before initializing the term generation. That module calls them
     during the construction of the derivation tree.
*/

void AP_setFunSymCnt(AbsPlr_T pconfig, PF_cfgsize symCnt)
/* specifies 'symCnt' as corresponding function for PLR_symbolCnt
   in the abstract interface 'pconfig'
*/
;

void AP_setFunTokCnt(AbsPlr_T pconfig, PF_cfgsize tokCnt)
/* specifies 'tokCnt' as corresponding function for PLR_tokenCnt
   in the abstract interface 'pconfig'
*/
;

void AP_setFunProdCnt(AbsPlr_T pconfig, PF_cfgsize prodCnt)
/* specifies 'prodCnt' as corresponding function for PLR_prodCnt
   in the abstract interface 'pconfig'
*/
;

void AP_setFunSymType(AbsPlr_T pconfig, PF_symType symType)
/* specifies 'symType' as corresponding function for PLR_symType
   in the abstract interface 'pconfig'
*/
;

void AP_setFunSymName(AbsPlr_T pconfig, PF_symName symName)
/* specifies 'symName' as corresponding function for PLR_symName
   in the abstract interface 'pconfig'
*/
;

void AP_setFunStartSym(AbsPlr_T pconfig, PF_startSym startSym)
/* specifies 'startSym' as corresponding function for PLR_startSymbol
   in the abstract interface 'pconfig'
*/
;

void AP_setFunProdNT(AbsPlr_T pconfig, PF_prodNT prodNT)
/* specifies 'prodNT' as corresponding function for PLR_prodNonTerm
   in the abstract interface 'pconfig'
*/
;

void AP_setFunProdName(AbsPlr_T pconfig, PF_prodName prodName)
/* specifies 'prodName' as corresponding function for PLR_prodName
   in the abstract interface 'pconfig'
*/
;

void AP_setFunTopVal(AbsPlr_T pconfig, PIF_topVal topVal)
/* specifies 'topVal' as corresponding function for PLR_topVal
   in the abstract interface 'pconfig'
*/
;

void AP_setFunParse(AbsPlr_T pconfig, PIF_parse parse)
/* specifies 'parse' as corresponding function for PLR_parse
   in the abstract interface 'pconfig'
*/
;

void AP_setFunAccept(AbsPlr_T pconfig, PIF_accept accept)
/* specifies 'accept' as corresponding function for PLR_accept
   in the abstract interface 'pconfig'
*/
;


/* --------------- Specification of the external parser configuration ------ */

void AP_setExtCfg(AbsPlr_T pconfig, Abs_T extcfg)
/* specifies the external configuration 'extcfg'
   of the abstract interface 'pconfig'
*/
;


/* 
  <p>An external defined parser must be configurable by the following callback
     functions. These handlers will be defined and assigned by the term
     generation module and must be called by the parser during processing.
*/

void AP_setFunNextTok(AbsPlr_T pconfig, PIF_nextTok nextTok)
/* specifies 'nextTok' as "get next token" handler
   in the abstract interface 'pconfig'
*/
;

void AP_setFunCurTok(AbsPlr_T pconfig, PIF_curTok curTok)
/* specifies 'curTok' as "get current token name" handler
   in the abstract interface 'pconfig'
*/
;

void AP_setFunShift(AbsPlr_T pconfig, PIF_shift shift)
/* specifies 'shift' as "shift operation" handler
   in the abstract interface 'pconfig'
*/
;

void AP_setFunReduce(AbsPlr_T pconfig, PIF_reduce reduce)
/* specifies 'reduce' as "reduce operation" handler
   in the abstract interface 'pconfig'
*/
;

void AP_setFunError(AbsPlr_T pconfig, PIF_error error)
/* specifies 'error' as "error reporting" handler
   in the abstract interface 'pconfig'
*/
;

void AP_setFunDebug(AbsPlr_T pconfig, PIF_debug debug)
/* specifies 'debug' as "debugging" handler
   in the abstract interface 'pconfig'
*/
;


/* --------------- Accessing the external parser interface ----------------- */

Abs_T AP_getParser(AbsPlr_T pconfig)
/* get the external parser of the abstract interface 'pconfig' */
;

PF_cfgsize AP_getFunSymCnt(AbsPlr_T pconfig)
/* get the corresponding function for PLR_symbolCnt
   in the abstract interface 'pconfig'
*/
;

PF_cfgsize AP_getFunTokCnt(AbsPlr_T pconfig)
/* get the corresponding function for PLR_tokenCnt
   in the abstract interface 'pconfig'
*/
;

PF_cfgsize AP_getFunProdCnt(AbsPlr_T pconfig)
/* get the corresponding function for PLR_prodCnt
   in the abstract interface 'pconfig'
*/
;

PF_symType AP_getFunSymType(AbsPlr_T pconfig)
/* get the corresponding function for PLR_symType
   in the abstract interface 'pconfig'
*/
;

PF_symName AP_getFunSymName(AbsPlr_T pconfig)
/* get the corresponding function for PLR_symName
   in the abstract interface 'pconfig'
*/
;

PF_startSym AP_getFunStartSym(AbsPlr_T pconfig)
/* get the corresponding function for PLR_startSymbol
   in the abstract interface 'pconfig'
*/
;

PF_prodNT AP_getFunProdNT(AbsPlr_T pconfig)
/* get the corresponding function for PLR_prodNonTerm
   in the abstract interface 'pconfig'
*/
;

PF_prodName AP_getFunProdName(AbsPlr_T pconfig)
/* get the corresponding function for PLR_prodName
   in the abstract interface 'pconfig'
*/
;

PIF_topVal AP_getFunTopVal(AbsPlr_T pconfig)
/* get the corresponding function for PLR_topVal
   in the abstract interface 'pconfig'
*/
;

PIF_parse AP_getFunParse(AbsPlr_T pconfig)
/* get the corresponding function for PLR_parse
   in the abstract interface 'pconfig'
*/
;

PIF_accept AP_getFunAccept(AbsPlr_T pconfig)
/* get the corresponding function for PLR_accept
   in the abstract interface 'pconfig'
*/
;


/* --------------- Accessing the external parser configuration ------------- */

Abs_T AP_getExtCfg(AbsPlr_T pconfig)
/* get the external configuration
   of the abstract interface 'pconfig'
*/
;

PIF_nextTok AP_getFunNextTok(AbsPlr_T pconfig)
/* get the "get next token" handler
   in the abstract interface 'pconfig'
*/
;

PIF_curTok AP_getFunCurTok(AbsPlr_T pconfig)
/* get the "get current token name" handler
   in the abstract interface 'pconfig'
*/
;

PIF_shift AP_getFunShift(AbsPlr_T pconfig)
/* get the "shift operation" handler
   in the abstract interface 'pconfig'
*/
;

PIF_reduce AP_getFunReduce(AbsPlr_T pconfig)
/* get the "reduce operation" handler
   in the abstract interface 'pconfig'
*/
;

PIF_error AP_getFunError(AbsPlr_T pconfig)
/* get the "error reporting" handler
   in the abstract interface 'pconfig'
*/
;

PIF_debug AP_getFunDebug(AbsPlr_T pconfig)
/* get the "debugging" handler
   in the abstract interface 'pconfig'
*/
;



#ifdef __cplusplus
}
#endif

#endif
