set(GLIB_REQUIRED_VERSION 2.26.0)
set(GTK_REQUIRED_VERSION 2.16.0)
message("-- Checking for Glib >= ${GLIB_REQUIRED_VERSION}...")
pkg_check_modules(GLIB2 glib-2.0>=${GLIB_REQUIRED_VERSION})
message("-- Checking for GTK+ >= ${GTK_REQUIRED_VERSION}...")
pkg_check_modules(GTK2 gtk+-2.0>=${GTK_REQUIRED_VERSION})
message("-- Checking for GModule...")
pkg_check_modules(GMODULE gmodule-2.0)

if(GLIB2_FOUND AND GTK2_FOUND AND GMODULE_FOUND)
    set(GTK2_ALL_INCLUDES ${GLIB2_INCLUDE_DIRS} ${GTK2_INCLUDE_DIRS} ${GMODULE_INCLUDE_DIRS})
    set(GTK2_ALL_CFLAGS ${GLIB2_CFLAGS_OTHER} ${GTK2_CFLAGS_OTHER} ${GMODULE_CFLAGS_OTHER})
    set(GTK2_ALL_LIBS ${GLIB2_LDFLAGS} ${GTK2_LDFLAGS} ${GMODULE_LDFLAGS})
else()
    message(FATAL_ERROR "Glib/GTK+ not found")
endif()
