#ifndef _h_ktst_test_tools_
#define _h_ktst_test_tools_

////////////////////////////////////////////////////////////////////////////////

#define LOG(log_level, msg) \
if (log_level >= ncbi::NK::TestEnv::verbosity) std::cerr << msg

#define TEST_MESSAGE(M) \
{ ncbi_NK_saveLocation(__FILE__,__LINE__); \
    LOG(ncbi::NK::LogLevel::e_message, M << std::endl); }

#define TEST_CHECKPOINT(M) TEST_MESSAGE(M)

#define CHECK(exp)       \
  ( (exp)                      \
      ? report_passed((#exp), __FILE__, __LINE__) \
      : report_error ((#exp), __FILE__, __LINE__) )

/* TODO #define CHECK_MESSAGE(exp, M)       \
  std::ostringstream s, s << M, \
  ( (exp)                      \
      ? report_passed(s.str(),__FILE__,__LINE__) \
      : report_error (s.str(),__FILE__,__LINE__) )*/

#define REQUIRE(exp)     \
  ( (exp)                      \
      ? report_passed        ((#exp), __FILE__, __LINE__) \
      : _REPORT_CRITICAL_ERROR_((#exp), __FILE__, __LINE__) )

#define CHECK_CLOSE(left, right, tolerance) \
( (ncbi::NK::abs((left) - (right)) < (tolerance)) \
?report_passed_close(#left,#right,(left),(right),(tolerance),__FILE__,__LINE__)\
: report_error_close(#left,#right,(left),(right),(tolerance), \
    ncbi::NK::abs((left) - (right)), __FILE__, __LINE__) )

#define REQUIRE_CLOSE(left, right, tolerance) \
( (ncbi::NK::abs((left) - (right)) < (tolerance)) \
?report_passed_close(#left,#right,(left),(right),(tolerance),__FILE__,__LINE__)\
: report_error_close(#left,#right,(left),(right),(tolerance), \
    ncbi::NK::abs((left) - (right)), __FILE__, __LINE__, true) )

#define CHECK_EQUAL(e1, e2)  \
  ( ((e1) == (e2))                      \
      ? report_passed2(#e1,#e2,(e1),(e2),__FILE__,__LINE__, "==", "!=") \
      : report_error2 (#e1,#e2,(e1),(e2),__FILE__,__LINE__, "==", "!=") )

#define REQUIRE_EQUAL(e1, e2)  \
  ( ((e1) == (e2))                      \
      ? report_passed2(#e1,#e2,(e1),(e2),__FILE__,__LINE__, "==", "!=") \
      : report_error2 (#e1,#e2,(e1),(e2),__FILE__,__LINE__, "==", "!=", true) )

#define CHECK_GE(e1, e2) \
  ( ((e1) >= (e2))                      \
      ? report_passed2(#e1,#e2,(e1),(e2),__FILE__,__LINE__, ">=", "<") \
      : report_error2 (#e1,#e2,(e1),(e2),__FILE__,__LINE__, ">=", "<") )

#define REQUIRE_GE(e1, e2) \
  ( ((e1) >= (e2))                      \
      ? report_passed2(#e1,#e2,(e1),(e2),__FILE__,__LINE__, ">=", "<") \
      : report_error2 (#e1,#e2,(e1),(e2),__FILE__,__LINE__, ">=", "<", true) )

#define CHECK_GT(e1, e2) \
  ( ((e1) > (e2))                      \
      ? report_passed2(#e1,#e2,(e1),(e2),__FILE__,__LINE__, ">", "<=") \
      : report_error2 (#e1,#e2,(e1),(e2),__FILE__,__LINE__, ">", "<=") )

#define REQUIRE_GT(e1, e2) \
  ( ((e1) > (e2))                      \
      ? report_passed2(#e1,#e2,(e1),(e2),__FILE__,__LINE__, ">", "<=") \
      : report_error2 (#e1,#e2,(e1),(e2),__FILE__,__LINE__, ">", "<=", true) )

#define CHECK_LE(e1, e2) \
  ( ((e1) <= (e2))                      \
      ? report_passed2(#e1,#e2,(e1),(e2),__FILE__,__LINE__, "<=", ">") \
      : report_error2 (#e1,#e2,(e1),(e2),__FILE__,__LINE__, "<=", ">") )

#define REQUIRE_LE(e1, e2) \
  ( ((e1) <= (e2))                      \
      ? report_passed2(#e1,#e2,(e1),(e2),__FILE__,__LINE__, "<=", ">") \
      : report_error2 (#e1,#e2,(e1),(e2),__FILE__,__LINE__, "<=", ">", true) )

#define CHECK_LT(e1, e2) \
  ( ((e1) < (e2))                      \
      ? report_passed2(#e1,#e2,(e1),(e2),__FILE__,__LINE__, "<", ">=") \
      : report_error2 (#e1,#e2,(e1),(e2),__FILE__,__LINE__, "<", ">=") )

#define REQUIRE_LT(e1, e2) \
  ( ((e1) < (e2))                      \
      ? report_passed2(#e1,#e2,(e1),(e2),__FILE__,__LINE__, "<", ">=") \
      : report_error2 (#e1,#e2,(e1),(e2),__FILE__,__LINE__, "<", ">=", true) )

#define CHECK_NE(e1, e2)  \
  ( ((e1) != (e2))                      \
      ? report_passed2(#e1,#e2,(e1),(e2),__FILE__,__LINE__, "!=", "==") \
      : report_error2 (#e1,#e2,(e1),(e2),__FILE__,__LINE__, "!=", "==") )

#define REQUIRE_NE(e1, e2)  \
  ( ((e1) != (e2))                      \
      ? report_passed2(#e1,#e2,(e1),(e2),__FILE__,__LINE__, "!=", "==") \
      : report_error2 (#e1,#e2,(e1),(e2),__FILE__,__LINE__, "!=", "==", true) )

#define ERROR( msg_ )    \
      report_error( (msg_), __FILE__, __LINE__, true )

#define FAIL( msg_ )     \
      _REPORT_CRITICAL_ERROR_( (msg_), __FILE__, __LINE__, true )

#define GET_TEST_SUITE ncbi::NK::GetTestSuite

#endif// _h_ktst_test_tools_
