##############################################################################  
#   
# This software is released under the Zope Public License (ZPL) Version 1.0
#
# Copyright (c) Digital Creations.  All rights reserved.  
# Portions Copyright (c) 1999 by Butch Landingin.
# Portions Copyright (c) 2000-2001 by Chris Withers.
#   
##############################################################################  
     
__version__='$Revision: 1.19 $'[11:-2]     
     
import Globals
from time import time     
from Utility import tagRegex
from SquishPermissions import View
from Posting import Posting
from string import join

from AccessControl import ClassSecurityInfo

class Article(Posting):     
    """ """

    security = ClassSecurityInfo()
    
    meta_type  ='Article'     
    icon   ='misc_/Squishdot/posting_img'
    _fields    =['title','author','body','email','subject','summary','dept']
    
    security.declarePrivate('textToSearch')
    def textToSearch(self):
        # returns the text to search for a ZCatalog
        text=''
        try:
            for line in self.summary:
                # strip out HTML and append a newline to each line.
                text = text+tagRegex.sub("",line)+'\n'
        except TypeError:
            pass
        try:
            for line in self.body:
                # strip out HTML and append a newline to each line.
                text = text+tagRegex.sub("",line)+'\n'
        except TypeError:
            pass
        return text
    
    security.declareProtected(View, 'prev_item')
    def prev_item(self):     
        #""" return previous id in the item list"""     
        parent = self.site()[0]     
        currtime = int(time())     
        rlist = list(parent.id_list(currtime))     
        currpos = 0     
        try:     
            currpos = rlist.index(int(self.id))     
        except:     
            currpos = -1     
        if (currpos == 0) or (currpos < 0):     
            return None     
        else:     
            previd = rlist[currpos - 1]     
            obj = self.data[previd]     
            return (obj.__of__(self),)     
     
    security.declareProtected(View, 'next_item')
    def next_item(self):     
        #""" return next id in the item list """     
        parent = self.site()[0]     
        currtime = int(time())     
        rlist = list(parent.id_list(currtime))     
        currpos = 0     
        try:     
            currpos = rlist.index(int(self.id))     
        except:     
            currpos = -1     
        lastpos = len(rlist) - 1     
        if (currpos == lastpos) or (currpos < 0):     
            return None     
        else:     
            nextid = rlist[currpos + 1]     
            obj = self.data[nextid]     
            return (obj.__of__(self),)     
     
    security.declareProtected(View, 'showSummary')
    def showSummary(self):
        # Used to display the summary of the article with the appropriate formatting    
        return self.render(self.summary,self.encoding)
     
    # Return the plain text body of a posting suitable for mailing...
    security.declareProtected(View, 'plain_text')
    def plain_text(self):
        if self.encoding == 'HTML':
            summary = self.html2text(join(self.summary,''))
        else:
            summary = join(self.summary,'\n')
        return "%s\n\n%s" % (summary,Posting.plain_text(self))

    def _processReviewed(self,reviewed):
        if self.moderated:     
            self.set_reviewed(self,reviewed)         
        
Globals.InitializeClass(Article)





