/*
  watchlog -- reads lines from logfile. checks if name has changed
              and if file has new data.
  Copyright (C) 2003  Pedro Zorzenon Neto <pzn@autsens.com>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef _WATCHLOG_H
#define _WATCHLOG_H

#include <stdio.h> /* for FILE type */

struct watchlog {
  char * fn;        /* logfile name */
  struct stat * fs; /* logfile status */
  int is_at_eof;    /* indicates that fileposition is at eof */
  char * data;      /* last line read from logfile */
  FILE * fh;        /* logfile handle */
};

#define watchlog_t struct watchlog

/* this function does not fail. it retries if failed and returns
 * only when it succeeds */
watchlog_t * watchlog_init (char * logfilename);

/* this function blocks the program until there is data available */
void watchlog_getline (watchlog_t * self);

void watchlog_destroy (watchlog_t * self);

#endif
