#!/usr/local/bin/perl
#
# This is a simple class which just represents some information that is
# provided by the spong administrator about the hosts that are being
# monitored.  The administrator can provide documentation in any number of
# formats depending on how energetic he/she is.  He/she can also choose not to
# provide this information at all, and nothing will be displayed.
#
# There is only one Info class associated with each Host, so this class knows
# how to load itself from the database.
#
#   host          - string FQDN of the machine its associated with
#
# + new()         - constructor (sets instance vars to arguments passed in)
# + gets/sets()   - magical set/get functions (autoloaded based on func name)
# + display()     - output format and view
#
# History:
# (1) Cleaned up (Ed July 31, 1997);

package Spong::Info;

# Object creation... Just checks to see if any of the required documentation
# files have been provided by the spong administrator, and if not it returns
# undef rather then a real life object...

sub new {
   my( $class, $host ) = @_;
   my $self = {};
   my $ok;

   if( -f "$main::SPONGDB/$host/info/info.txt" )  { $ok = 1; }
   if( -f "$main::SPONGDB/$host/info/info.html" ) { $ok = 1; }

   if( -f "$main::SPONGDB/$host/info/info.brief.txt" )    { $ok = 1; }
   if( -f "$main::SPONGDB/$host/info/info.standard.txt" ) { $ok = 1; }
   if( -f "$main::SPONGDB/$host/info/info.full.txt" )     { $ok = 1; }

   if( -f "$main::SPONGDB/$host/info/info.brief.html" )    { $ok = 1; }
   if( -f "$main::SPONGDB/$host/info/info.standard.html" ) { $ok = 1; }
   if( -f "$main::SPONGDB/$host/info/info.full.html" )     { $ok = 1; }

   return undef if ! $ok;

   $self->{'host'} = $host;
   bless $self;
   return $self;
}


# Get/Set methods, nothing fancy here...

sub host { my $var = 'host';
   if( defined $_[1] ) { $_[0]->{$var} = $_[1]; } return $_[0]->{$var}; }


# Display summary.  Does both text and html, doesn't make any calls to 
# sub-objects or other helper objects, just spits out the data that it has.
#
# This object is a little different in that it shows the best possible
# documentation based on what is provided.  It checks to see if the
# administrator has provided a specific view of documentation, but if it
# doesn't exist then it just keep looking for documentation until it finds
# some to print.

sub display {
   my( $self, $type, $view ) = @_;

   if( $type eq "text" ) { return $self->display_text( $view ); }
   if( $type eq "html" ) { return $self->display_html( $view ); }
}

sub display_text {
   my( $self, $format ) = @_;
   my $host = $self->host();
   my( @cycle );

   if( $format eq "brief" ) {
      @cycle = ( "brief.txt", "txt", "standard.txt", "full.txt" );
   } elsif( $format eq "standard" ) {
      @cycle = ( "standard.txt", "txt", "full.txt", "brief.txt" );
   } elsif( $format eq "full" ) {
      @cycle = ( "full.txt", "txt", "brief.txt", "standard.txt" );
   }
   
   foreach( @cycle ) {
      if( -f "$main::SPONGDB/$host/info/info.$_" ) {
	 open( FILE, "$main::SPONGDB/$host/info/info.$_" );
	 while( <FILE> ) { print $_; }
	 close( FILE );
	 return;
      }
   }
   
   print "Only information in HTML is provided.\n";
}

sub display_html {
   my( $self, $format ) = @_;
   my $host = $self->host();
   my( @cycle );

   if( $format eq "brief" ) {
      @cycle = ( "brief.html", "html", "brief.txt", "standard.html", 
		 "standard.txt", "full.html", "full.txt" ); 
   } elsif( $format eq "standard" ) {
      @cycle = ( "standard.html", "html", "standard.txt", "full.html", 
		 "full.txt", "brief.html", "brief.txt" );
   } elsif( $format eq "full" ) {
      @cycle = ( "full.html", "html", "full.txt", "brief.html", "brief.txt", 
		 "standard.html", "standard.txt" );
   }

   foreach( @cycle ) {
      if( -f "$main::SPONGDB/$host/info/info.$_" ) {
	 open( FILE, "$main::SPONGDB/$host/info/info.$_" );
	 while( <FILE> ) { print $_; }
	 close( FILE );
	 return;
      }
   }
}

1;

