-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

with E_Strings;

--# inherit E_Strings,
--#         ScreenEcho,
--#         SPARK_IO;

package SystemErrors is
   type Sys_Err_Type is (
                         String_Table_Overflow,
                         Syntax_Tree_Overflow,
                         Parse_Stack_Overflow,
                         Symbol_Table_Overflow_Static,
                         Symbol_Table_Overflow_Dynamic,
                         Invalid_Syntax_Tree,
                         Invalid_Symbol_Table,
                         Empty_Heap,
                         Relation_Stack_Underflow,
                         Relation_Stack_Overflow,
                         Invalid_Init,
                         Error_Position_Wrong,
                         Expression_Stack_Corrupt,
                         Expression_Stack_Underflow,
                         Expression_Stack_Overflow,
                         Type_Context_Stack_Corrupt,
                         Type_Context_Stack_Underflow,
                         Type_Context_Stack_Overflow,
                         List_Overflow_In_Expression,
                         List_Overflow_In_Dependency_Clause,
                         List_Overflow_In_Procedure_Call,
                         Case_Stack_Underflow,
                         Case_Stack_Overflow,
                         VCG_Graph_Size_Exceeded,
                         VCG_Heap_Is_Exhausted,
                         VCG_Heap_Is_Corrupted,
                         Ref_List_Key_Cell_Missing,
                         Flow_Analyser_Expression_Limit,
                         Case_Statement_Nesting_Limit,
                         Error_Handler_Temporary_Files,
                         Error_Handler_Source,
                         Disk_Full_Error,
                         Math_Error,
                         Too_Many_Nested_Arrays,
                         Too_Many_Nested_Records,
                         Context_Unit_Stack_Overflow,
                         Context_Unit_Stack_Underflow,
                         Context_File_Heap_Overflow,
                         Context_Unit_Heap_Overflow,
                         Too_Many_File_Lines,
                         Index_Stack_Full,
                         Index_Component_List_Full,
                         Too_Many_Errors,
                         Warning_Name_Too_Long,
                         Unit_Name_In_Index_Too_Long,
                         File_Name_In_Index_Too_Long,
                         Too_Many_Suppressed_Warnings,
                         Unit_Nesting_Too_Deep,
                         Statement_Stack_Underflow,
                         Statement_Stack_Overflow,
                         Wf_Compilation_Unit_Stack_Overflow,
                         Wf_Compilation_Unit_Stack_Underflow,
                         Too_Many_Flow_Analyser_Expressions,
                         Too_Many_Params_In_Procedure_Call,
                         Statistics_Usage_Greater_Than_Table_Size,
                         Aggregate_Stack_Under_Flow,
                         Aggregate_Stack_Over_Flow,
                         Meta_File_Stack_Overflow,
                         Lex_Stack_Overflow,
                         Lex_Stack_Underflow,
                         Component_Manager_Overflow,
                         Component_Error_Overflow,
                         Syntax_Tree_Walk_Error,
                         Precondition_Failure,
                         Postcondition_Failure,
                         Assertion_Failure,
                         Unimplemented_Feature,
                         XML_Schema_Error,
                         XML_Generation_Error,
                         Illegal_XML_Generation_Attempt,
                         String_Over_Flow,
                         Queue_Overflow,
                         XRef_Table_Full,
                         -- Add additional specific entries here...
                         Other_Internal_Error);

   type Start_Err_Type is (
                           No_Lmgrd,
                           No_Licence_File,
                           Cant_Read_Licence,
                           Expired,
                           Too_Many_Examiner_Users,
                           Too_Many_Raven_SPARKUsers,
                           Too_Many_VDSUsers,
                           Too_Many_Ada_Magic_Users,
                           Corrupted_Licence,
                           Obsolete_Licence,
                           Unexpected_FLEX,
                           Wrong_Machine,
                           Wrong_Examiner_Licence_File,
                           Wrong_Raven_SPARK_Licence_File,
                           Wrong_VDS_Licence_File,
                           Wrong_Ada_Magic_Licence_File,
                           No_Spex);

   -- Proof function can be asserted true and, on paths where SystemErrors is called
   -- this will appear in hypotheses; this helps understand what is going on.

   --# function Halted return Boolean;

   procedure Startup_Error (Start_Err  : in Start_Err_Type;
                            Version    : in E_Strings.T;
                            Flex_Error : in Integer);
   --# global in out SPARK_IO.File_Sys;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Flex_Error,
   --#                                Start_Err,
   --#                                Version;
   --# post Halted and -- this helps us understand VCs where SystemError called
   --#   False;        -- this ensures that such paths are provable by contradiction

   -- Raises Sys_Err with Msg
   procedure Fatal_Error (Sys_Err : in Sys_Err_Type;
                          Msg     : in String);
   --# derives null from Msg,
   --#                   Sys_Err;
   --# post Halted and -- this helps us understand VCs where SystemError called
   --#   False;        -- this ensures that such paths are provable by contradiction

   -- if C if False, then Raises Sys_Err with Msg
   -- if C is True, then returns
   procedure RT_Assert (C       : in Boolean;
                        Sys_Err : in Sys_Err_Type;
                        Msg     : in String);
   --# derives null from C,
   --#                   Msg,
   --#                   Sys_Err;
   --# post C or (not C and Halted and False);

end SystemErrors;
