

#ifndef RIPPERPLUGINLOADER_H
#define RIPPERPLUGINLOADER_H

#include "pluginloaderbase.h"


/**
 * @short The complete data, how to use the backend
 * @author Daniel Faust <hessijames@gmail.com>
 * @version 0.3
 */
class RipperPlugin
{
public:
    /**
     * Constructor
     */
    RipperPlugin();

    /**
     * Destructor
     */
    virtual ~RipperPlugin();

    QString filePathName; // the file name of th plugin (needed to detect write permissions)

    struct Info
    {
        int version;    // the version of our plugin (v0.2.1 = 201, v11.3 = 110300)
        QString name;   // the name of our plugin
        QString author; // the author of the plugin
        QString about;  // a short information aboue the plugin
    } info;

    struct Rip
    {
        //PluginLoaderBase::FeatureLevel level;
        int rank;
        QString bin;
        QString param;
        QString silent_param;
        QString out_file;
        QString track;
        QString device;
        QString overwrite;
        QString output;

        struct FullDisc
        {
            bool enabled;
            QString param;
            QString output;
        } full_disc;
    } rip;
};

/**
 * @short The plugin loader for the ripper plugins
 * @author Daniel Faust <hessijames@gmail.com>
 * @version 0.3
 */
class RipperPluginLoader : public PluginLoaderBase
{
    Q_OBJECT
public:
    /**
     * Constructor
     */
    RipperPluginLoader();

    /**
     * Destructor
     */
    virtual ~RipperPluginLoader();

    /** is this file a ripper plugin and loadable? */
    int verifyFile( QString );
    /** load a given file */
    RipperPlugin* loadFile( QString );
};

#endif // RIPPERPLUGINLOADER_H
