/*
 * ----------------------------------------------------
 *
 * cliserver: Accept data from a terminal and feed it
 *            into an interpreter 
 *
 * (C) 2004 2005 2008 Jochen Karrer 
 *   Author: Jochen Karrer
 *
 *
 *  This program is free software; you can distribute it and/or modify it
 *  under the terms of the GNU General Public License (Version 2) as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope it will be useful, but WITHOUT
 *  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 *  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston MA 02111-1307, USA.
 *
 * ----------------------------------------------------
 */


#include <fio.h>
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <unistd.h>
#include <configfile.h>
#include "telnetd.h"
#include "interpreter.h"
#include "cliserver.h"
#include "sgstring.h"

#if 1
#define dbgprintf(x...) { fprintf(stderr,x); }
#else
#define dbgprintf(x...)
#endif

#define MAX_LINELEN (1000)

struct CliServer {
	TelnetServer *tserv;
};

static void 
CliSess_Accept(void *clientData,Channel *chan,char *hostName,int port) 
{
	Interp_New(chan);
}


CliServer *
CliServer_New(const char *name) {
	CliServer *cserv = sg_new(CliServer);
	char *host=Config_ReadVar(name,"host");	
	int port;	
	if(!cserv) {
		fprintf(stderr,"Out of memory for debugger\n");
		return NULL;
	}
	if(Config_ReadInt32(&port,name,"port")<0) {
		fprintf(stderr,"CLI not configured\n");
		return NULL;
	} 
	if(!host) {
		fprintf(stderr,"No host for TCP server of CLI\n");
		return NULL;
	}
	cserv->tserv = TelnetServer_New(host,port,CliSess_Accept,cserv);
	return cserv;
}
