/*
 * ----------------------------------------------------------
 * boards.c
 *	Register and Find Boards
 *
 * (C) 2005  Lightmaze Solutions AG
 *   Author: Jochen Karrer
 *
 *  This program is free software; you can distribute it and/or modify it
 *  under the terms of the GNU General Public License (Version 2) as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope it will be useful, but WITHOUT
 *  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 *  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston MA 02111-1307, USA.
 *
 * ----------------------------------------------------------
 */
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <stdint.h>
#include "boards.h"
#include "ns9750dev.h"
#include "lacc.h"
#include "facc.h"
#include "uzebox.h"
#include "alt9.h"


static Board *first_board = NULL;

Board * 
Board_Find(const char *name) 
{
	Board *cursor;
	for(cursor=first_board;cursor;cursor=cursor->next) {
		if(!strcmp(name,cursor->name)) {
			return cursor;
		}
	}	
	fprintf(stderr,"Board \"%s\" does not exist.\nList of available boards:\n",name);
	for(cursor=first_board;cursor;cursor=cursor->next) {
		fprintf(stderr,"Board %-15s: %s\n",cursor->name,cursor->description);
	}	
	return NULL;
}

void
Board_Register(Board *board) 
{
	board->next=first_board;
	first_board=board;
}

/*
 * -----------------------------------------
 * Boards init
 *	Register all boards	
 *	Change this function when adding
 *	a new board
 * -----------------------------------------
 */

void
Boards_Init() {
	Board_Register(&board_lacc);
	Board_Register(&board_ns9750dev);
	Board_Register(&board_uzebox);
	Board_Register(&board_alt9);
}

void
Board_Create(Board *board)  {
	board->createBoard();
}
