/*
 * -------------------------------------------------------------
 *
 * Emulation on Logical Signal Level
 * (C) 2007 Jochen Karrer 
 *	Author: Jochen Karrer
 *
 * Basic processing elements for digital signals: Inverter, And, Or
 *
 * Status:
 *      Not useful 
 *
 *
 *  This program is free software; you can distribute it and/or modify it
 *  under the terms of the GNU General Public License (Version 2) as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope it will be useful, but WITHOUT
 *  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 *  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston MA 02111-1307, USA.
 *
 * -------------------------------------------------------------
 */

#include <stdio.h>
#include <stdint.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <logical.h>
#include <signode.h>

typedef struct SigNot 
{
	//SigNode *in;
	SigNode *out;
	SigTrace *trace;
} SigNot;


static int 
do_invert(SigNode *node,int value,void *clientData) 
{
	SigNot *inv = (SigNot *)clientData;	
	if(value == SIG_HIGH) {
		SigNode_Set(inv->out,SIG_LOW);	
	} else if(value == SIG_LOW) {
		SigNode_Set(inv->out,SIG_HIGH);	
	}
	return 0;
}

char *
SigNot_New(const char *inname) 
{
	SigNot *inv;
	SigNode *out;
	SigNode *in;
	char *outname;
	in = SigNode_Find(inname);
	if(!in) {
		return NULL;
	}
	outname = alloca(strlen(inname)+4);
	sprintf(outname,"n%s",inname);
	out = SigNode_New(outname);
	if(!out) {
		return NULL;
	}
	inv = malloc(sizeof(*inv));
	if(!inv) {
		fprintf(stderr,"Out of memory error\n");
		exit(1);
	}
	memset(inv,0,sizeof(*inv));
	inv->out = out;
	inv->trace = SigNode_Trace(in,do_invert,inv);
	// trace unsets  is missing here
	return SigName(inv->out);
}
