/*
 * ----------------------------------------------------
 *
 * Configuration File Access
 * (C) 2004  Lightmaze Solutions AG
 *   Author: Jochen Karrer
 *
 *
 *  This program is free software; you can distribute it and/or modify it
 *  under the terms of the GNU General Public License (Version 2) as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope it will be useful, but WITHOUT
 *  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 *  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston MA 02111-1307, USA.
 * ----------------------------------------------------
 */

#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <string.h>
#include <fcntl.h>
#include <ctype.h>
#include "configfile.h"

#if 0 
#define dprintf(x...) { if(unlikely(debugflags&DEBUG_INSTRUCTIONS)) { fprintf(stderr,x); } }
#else
#define dprintf(x...)
#endif


#define MAX_LINELEN 256

typedef struct ConfigVar {
	char *section;
	char *name;
	char *value;
	struct ConfigVar *next;	
} ConfigVar;

typedef struct Configuration {
	char curr_section[MAX_LINELEN];
	ConfigVar *firstVar;
} Configuration;

static Configuration config;

char *
Config_ReadVar(const char *section,const char *name) {
	Configuration *cfg=&config;
	ConfigVar *var;
	for(var=cfg->firstVar;var;var=var->next) {
		if(!strcmp(var->section,section) && !strcmp(var->name,name)) {
			return var->value;
		}
	}
	return NULL;
}

static void 
add_var(Configuration *cfg,char *section, char *name,char *value) 
{
	ConfigVar *var;
	int namelen;
	//fprintf(stderr,"add sec \"%s\" var \"%s\" value \"%s\"\n",section,name,value);
	var=malloc(sizeof(ConfigVar));
	if(!var) {
		fprintf(stderr,"Out of memory\n");
		return;
	}
	namelen=strlen(name)+strlen(section)+3;	
	var->name=strdup(name);
	if(!var) {
		fprintf(stderr,"Out of memory");	
		return;
	}
	var->section=strdup(section);
	if(!var) {
		fprintf(stderr,"Out of memory");	
		return;
	}
	var->value=strdup(value);
	if(!var->value) {
		return;
	}
	var->next=cfg->firstVar;
	cfg->firstVar=var;
}
static void 
add_line(Configuration *cfg,char *line) 
{
	char *name_start;
	char *value_start;
	char *value_end;
	char *section;
	while(isspace(*line)) {
		line++;
	}
	if((*line=='\n') || (*line==0) ) {
		return;
	}	
	//fprintf(stderr,"Add \"%s\"\n",line); // jk
	if(*line=='[') {
		char *end;
		end=line;
		while(*end) {
			if(*end==']') {
				*end=0;
				dprintf("Curr section %s\n",line+1); // jk
				strcpy(cfg->curr_section,line+1);
				return;
			}
			end++;
		}
	} else if (*line=='#') {
		return;
	}
	name_start=line;
	while(1) {
		if(!*line) {
			dprintf("Line end before colon\n"); // jk
			return;
		}
		if(*line==':') {
			*line=0;
			value_start=line+1;
			break;
		}
		line++;
	} 
	while(isspace(*value_start)) {
		value_start++;
	}
	if(!strlen(value_start)) {
		dprintf("Value is empty\n"); // jk
		return;
	}
	value_end=value_start+strlen(value_start)-1;
	while(isspace(*value_end)) {
		*value_end=0;
		value_end--;
	}
	section=cfg->curr_section;
	if(!*section) {
		dprintf("No current section\n"); // jk
		return;
	}
	//fprintf(stderr,"section \"%s\" var \"%s\", value \"%s\"\n",cfg->curr_section,name_start,value_start);
	if(!Config_ReadVar(cfg->curr_section,name_start)) {
		add_var(cfg,cfg->curr_section, name_start,value_start) ;
	}
}

void
remove_comment(char *line) {
	while(*line) {
		if(*line=='#') {
			*line=0;	
			return;
		}
		line++;
	}
}
/*
 * ------------------------------------------
 * Read a configfile
 * returns -1 if file is not readable
 * ------------------------------------------
 */
int
Config_ReadFile(char *filename) {
	Configuration *cfg=&config;
	FILE *file;
	char line[MAX_LINELEN];
	file=fopen(filename,"r");
	if(!file) {
		return -1;
	}
	while(1) {
		if(!fgets(line,MAX_LINELEN,file)) {
			break;
		}
		if(feof(file)) {
			break;
		}
		remove_comment(line);
		add_line(cfg,line);
	}
	fprintf(stderr,"Configuration file \"%s\" loaded\n",filename);
	return 0;
}

void
Config_AddString(const char *cfgstr) {
	Configuration *cfg=&config;
	int i,end=0;
	char line[MAX_LINELEN];
	while(1) {
		for(i=0;i<MAX_LINELEN-1;i++) {
			line[i]=*cfgstr++;	
			if(line[i]==0) {
				end=1;
			}
			if((line[i]=='\n') || (line[i]==0)) {
				line[i]=0;	
				//fprintf(stderr,"Line is \"%s\"\n",line);
				add_line(cfg,line);
				break;
			}
		}
		if(end)
			return;
	}
	
}

int
Config_ReadInt32(int32_t *retval,const char *section,const char *name) {
	char *value=Config_ReadVar(section,name);
	if(!value) {
		//fprintf(stderr,"Warning: Variable %s::%s not found in configfile\n",section,name);	
		return -1;
	}
	if(sscanf(value,"%d",retval)!=1) {
		fprintf(stderr,"Warning: Variable %s::%s is should be an Integer\n",section,name);	
		return -2;
	}
	return 0; 
}

int
Config_ReadUInt32(uint32_t *retval,const char *section,const char *name) {
	char *value=Config_ReadVar(section,name);
	if(!value) {
		//fprintf(stderr,"Warning: Variable \"%s\"::\"%s\" not found in configfile\n",section,name);	
		return -1;
	}
	if(sscanf(value,"0x%x",retval)==1) {
		return 0; 
	}
	if(sscanf(value,"%u",retval)==1) {
		return 0; 
	}
	fprintf(stderr,"Warning: Variable %s::%s should be an unsigned integer\n",section,name);
	return -2;
}

#ifdef CONFTEST
int main(int argc,char *argv[]) 
{
	if(argc>1) {
		Config_Read(argv[1]);	
	} else {
		Config_Read(".config");	
	}
	printf("%s\n",Config_ReadVar("affe","sau"));
	exit(0);
}
#endif
