/*
 * ------------------------------------------------------------------------------
 *
 * Emulation of ADS7828 I2C  A/D Converter
 *
 * (C) 2004  Lightmaze Solutions AG
 *   Author: Jochen Karrer
 *
 *  State:
 *	Working, but shows constant values
 *
 *  This program is free software; you can distribute it and/or modify it
 *  under the terms of the GNU General Public License (Version 2) as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope it will be useful, but WITHOUT
 *  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 *  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston MA 02111-1307, USA.
 * ------------------------------------------------------------------------------
 */

#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <string.h>
#include <sys/time.h>
#include <time.h>
#include "i2c.h"
#include "ads7828.h"

#if 0
#define dprintf(x...) { fprintf(stderr,x); }
#else
#define dprintf(x...)
#endif

struct ADS7828 {
	I2C_Slave i2c_slave;
	uint16_t reg_address;
	int state;
	uint8_t cmd;
	uint16_t ad;
	uint16_t ain[8];
};

#define ADS_STATE_DATA0 (0)
#define ADS_STATE_DATA1 (1)
/*
 * ------------------------------------
 * ADS7828 Write state machine 
 * ------------------------------------
 */
static int 
ads7828_write(void *dev,uint8_t data) {
	ADS7828 *ads = dev;
	dprintf("ADS7828 Addr 0x%02x\n",data);
	ads->cmd = data;
	return I2C_ACK;
};

#define PCF_AUTO_INC (8)
#define PCF_AIN_MODE 	     (0x30)
#define PCF_AIN_SINGLE_ENDED 	(0)
#define PCF_AIN_THREE_DIFF 	(0x10)
#define PCF_AIN_MIXED 		(0x20)
#define PCF_AIN_TWO_DIFF 	(0x30)
static int 
ads7828_read(void *dev,uint8_t *data) 
{
	ADS7828 *ads = dev;
	int chsel = (ads->cmd&0xf0) >> 4;
	int pd = (ads->cmd & 0xc) >> 2;
	if(ads->state==ADS_STATE_DATA0) {
		if(pd!=3) {
			fprintf(stderr,"ADS7828 Power Down mode %d not implemented\n",pd);
		}
		switch (chsel) {
			case 0: 
				ads->ad = ads->ain[0]-ads->ain[1];
				break;
			case 1: 
				ads->ad = ads->ain[2]-ads->ain[3];
				break;
			case 2: 
				ads->ad = ads->ain[4]-ads->ain[5];
				break;
			case 3: 
				ads->ad = ads->ain[6]-ads->ain[7];
				break;
			case 4: 
				ads->ad = ads->ain[1]-ads->ain[0];
				break;
			case 5: 
				ads->ad = ads->ain[3]-ads->ain[2];
				break;
			case 6: 
				ads->ad = ads->ain[5]-ads->ain[4];
				break;
			case 7: 
				ads->ad = ads->ain[7]-ads->ain[6];
				break;
			case 8: 
				ads->ad = ads->ain[0];
				break;
			case 9: 
				ads->ad = ads->ain[2];
				break;
			case 10: 
				ads->ad = ads->ain[4];
				break;
			case 11: 
				ads->ad = ads->ain[6];
				break;
			case 12: 
				ads->ad = ads->ain[1];
				break;
			case 13: 
				ads->ad = ads->ain[3];
				break;
			case 14: 
				ads->ad = ads->ain[5];
				break;
			case 15: 
				ads->ad = ads->ain[7];
				break;
		}
		*data = (ads->ad >> 8)&0xf;
		ads->state = ADS_STATE_DATA1;
	} else if (ads->state == ADS_STATE_DATA1) {
		*data = ads->ad & 0xff;
		ads->state = ADS_STATE_DATA0;
	}
	dprintf("ADS7828 read 0x%02x\n",*data);
	return I2C_DONE;
};

static int
ads7828_start(void *dev,int i2c_addr,int operation) {
	ADS7828 *ads = dev;
	dprintf("ads7828 start\n");
	ads->state = ADS_STATE_DATA0;
	return I2C_ACK;
}

static void 
ads7828_stop(void *dev) {
	ADS7828 *ads = dev;
	dprintf("ads7828 stop\n");
	ads->state = ADS_STATE_DATA0;
}


static I2C_SlaveOps ads7828_ops = {
	.start = ads7828_start,
	.stop =  ads7828_stop,
	.read =  ads7828_read,	
	.write = ads7828_write	
};

I2C_Slave *
ADS7828_New(char *name) {
	ADS7828 *ads = malloc(sizeof(ADS7828)); 
	I2C_Slave *i2c_slave;
	if(!ads) {
		fprintf(stderr,"Out of memory\n");
		exit(8152);
	}
	memset(ads,0,sizeof(ADS7828));
	ads->ain[0]= 3277; // 5
	ads->ain[1]= 3700; // apd
	ads->ain[2]= 789; 
	ads->ain[3]= 1234;
	ads->ain[4]= 3604; // 3v3
	ads->ain[5]= 2334;
	ads->ain[6]= 2534;
	ads->ain[7]= 2500;
	i2c_slave = &ads->i2c_slave;
	i2c_slave->devops = &ads7828_ops; 
	i2c_slave->dev = ads;
	i2c_slave->speed = I2C_SPEED_FAST;
	fprintf(stderr,"ADS7828 12Bit 8-Channel A/D Converter \"%s\" created\n",name);
	return i2c_slave;
}
