/***************************************************************************
    smb4knetworkbrowsertooltip  -  Tool tip for the network browser.
                             -------------------
    begin                : Sa Jan 20 2007
    copyright            : (C) 2007 by Alexander Reinholdt
    email                : dustpuppy@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,   *
 *   MA  02111-1307 USA                                                    *
 ***************************************************************************/

// Qt includes
#include <qtooltip.h>
#include <qdesktopwidget.h>
#include <qapplication.h>
#include <qtimer.h>

// KDE includes
#include <klocale.h>

// application specific includes
#include "smb4knetworkbrowsertooltip.h"
#include "smb4knetworkbrowseritem.h"

Smb4KNetworkBrowserToolTip::Smb4KNetworkBrowserToolTip( Smb4KNetworkBrowserItem *item )
: QLabel( 0, "NetworkBrowserToolTip", WStyle_StaysOnTop | WStyle_Customize | WStyle_NoBorder | WStyle_Tool | WX11BypassWM | WDestructiveClose ), m_item( item )
{
  setPalette( QToolTip::palette() );
  setLineWidth( 1 );
  setMidLineWidth( 1 );
  setFrameShape( Box );
  setFrameShadow( Plain );
  setMouseTracking( true );

  m_layout = new QGridLayout( this );
  m_layout->setMargin( 10 );
  m_layout->setSpacing( 3 );

  // We will set up the tip in the showTip() function.
}


Smb4KNetworkBrowserToolTip::~Smb4KNetworkBrowserToolTip()
{
  // Never touch the Smb4KNetworkBrowserItem object here
}


void Smb4KNetworkBrowserToolTip::showTip( const QPoint &pos )
{
  if ( !m_item || isShown() )
  {
    return;
  }

  setupTip();

  adjustSize();

  QPoint p( pos );

  QDesktopWidget *d = QApplication::desktop();

  if ( p.x() + width() > d->width() )
  {
    p.setX( p.x() - width() - 5 );
  }
  else
  {
    p.setX( p.x() + 5 );
  }

  if ( p.y() + height() > d->height() )
  {
    p.setY( p.y() - height() - 5 );
  }
  else
  {
    p.setY( p.y() + 5 );
  }

  setGeometry( p.x(), p.y(), width(), height() );
  polish();
  show();
  QTimer::singleShot( 10000, this, SLOT( slotHideToolTip() ) );
}


void Smb4KNetworkBrowserToolTip::setupTip()
{
  switch ( m_item->type() )
  {
    case Smb4KNetworkBrowserItem::Workgroup:
    {
      QLabel *workgroup_label =    new QLabel( i18n( "Workgroup:" ), this );
      QLabel *workgroup =          new QLabel( m_item->workgroupItem()->name() , this );

      QString master_label_entry = m_item->workgroupItem()->hasPseudoMaster() ? i18n( "Pseudo master browser:" ) : i18n( "Master browser:" );
      QLabel *master_label =       new QLabel( master_label_entry, this );

      QString master_entry =       m_item->workgroupItem()->masterIP().isEmpty() ?
                                   (m_item->workgroupItem()->master().isEmpty() ? i18n( "Unknown" ) : m_item->workgroupItem()->master()) :
                                   m_item->workgroupItem()->master() + " ("+m_item->workgroupItem()->masterIP()+")";
      QLabel *master =             new QLabel( master_entry, this, "MasterBrowser" );

      m_layout->addWidget( workgroup_label, 0, 1, 0 );
      m_layout->addWidget( workgroup, 0, 2, 0 );
      m_layout->addWidget( master_label, 1, 1, 0 );
      m_layout->addWidget( master, 1, 2, 0 );

      break;
    }
    case Smb4KNetworkBrowserItem::Host:
    {
      QLabel *host_label =       new QLabel( i18n( "Host:" ), this );
      QLabel *host =             new QLabel( m_item->hostItem()->name(), this );

      QLabel *comment_label =    new QLabel( i18n( "Comment:" ), this );
      QLabel *comment =          new QLabel( m_item->hostItem()->comment(), this );

      QLabel *ip_label =         new QLabel( i18n( "IP address:" ), this );
      QString ip_entry =         m_item->hostItem()->ip().isEmpty() ? i18n( "Unknown" ) : m_item->hostItem()->ip();
      QLabel *ip_address =       new QLabel( ip_entry, this, "IPAddress" );

      QLabel *os_label =         new QLabel( i18n( "Operating system:" ), this );
      QLabel *operating_system = new QLabel( m_item->hostItem()->osString().isEmpty() ? i18n( "Unknown" ) :
                                             m_item->hostItem()->osString(), this, "OSString" );

      QLabel *server_label =     new QLabel( i18n( "Server string:" ), this );
      QLabel *server_string =    new QLabel( m_item->hostItem()->serverString().isEmpty() ? i18n( "Unknown" ) :
                                             m_item->hostItem()->serverString(), this, "ServerString" );

      QFrame *line = new QFrame( this );
      line->setLineWidth( 1 );
      line->setMidLineWidth( 0 );
      line->setFixedWidth( 100 );
      line->setFrameShape( QFrame::HLine );
      line->setFrameShadow( QFrame::Plain );

      QLabel *workgroup_label =  new QLabel( i18n( "Workgroup:" ), this );
      QLabel *workgroup =        new QLabel( m_item->hostItem()->workgroup(), this );

      Smb4KWorkgroupItem *workgroup_item = static_cast<Smb4KNetworkBrowserItem *>( m_item->parent() )->workgroupItem();
      QLabel *master_label =     new QLabel( i18n( "Master browser:" ), this );
      QLabel *master_yes_no =    new QLabel( (workgroup_item && !workgroup_item->master().isEmpty()) ?
                                             workgroup_item->master() : i18n( "Unknown" ), this );

      m_layout->addWidget( host_label, 0, 1, 0 );
      m_layout->addWidget( host, 0, 2, 0 );
      m_layout->addWidget( comment_label, 1, 1, 0 );
      m_layout->addWidget( comment, 1, 2, 0 );
      m_layout->addWidget( ip_label, 2, 1, 0 );
      m_layout->addWidget( ip_address, 2, 2, 0 );
      m_layout->addWidget( os_label, 3, 1, 0 );
      m_layout->addWidget( operating_system, 3, 2, 0 );
      m_layout->addWidget( server_label, 4, 1, 0 );
      m_layout->addWidget( server_string, 4, 2, 0 );
      m_layout->addMultiCellWidget( line, 5, 5, 1, 2, Qt::AlignCenter );
      m_layout->addWidget( workgroup_label, 6, 1, 0 );
      m_layout->addWidget( workgroup, 6, 2, 0 );
      m_layout->addWidget( master_label, 7, 1, 0 );
      m_layout->addWidget( master_yes_no, 7, 2, 0 );

      break;
    }
    case Smb4KNetworkBrowserItem::Share:
    {
      QLabel *share_label =   new QLabel( i18n( "Share:" ), this );
      QLabel *share =         new QLabel( m_item->shareItem()->name(), this );

      QLabel *comment_label = new QLabel( i18n( "Comment:" ), this );
      QLabel *comment =       new QLabel( m_item->shareItem()->comment(), this );

      QLabel *type_label =    new QLabel( i18n( "Type:" ), this );
      QLabel *type =          new QLabel( m_item->shareItem()->translatedType(), this );

      QLabel *mounted_label = NULL;
      QLabel *mounted = NULL;

      if ( !m_item->isPrinter() )
      {
        mounted_label = new QLabel( i18n( "Mounted:" ), this );
        mounted =       new QLabel( m_item->isMounted() ? i18n( "Yes" ) : i18n( "No" ), this );
      }

      QFrame *line = new QFrame( this );
      line->setLineWidth( 1 );
      line->setMidLineWidth( 0 );
      line->setFixedWidth( 100 );
      line->setFrameShape( QFrame::HLine );
      line->setFrameShadow( QFrame::Plain );

      QLabel *host_label =    new QLabel( i18n( "Host:" ), this );
      QLabel *host =          new QLabel( m_item->shareItem()->host(), this );

      Smb4KHostItem *host_item = static_cast<Smb4KNetworkBrowserItem *>( m_item->parent() )->hostItem();
      QLabel *ip_label =      new QLabel( i18n( "IP address:" ), this );
      QLabel *ip_address =    new QLabel( (host_item && !host_item->ip().isEmpty()) ?
                                          host_item->ip() : i18n( "Unknown" ), this, "IPAddress" );

      m_layout->addWidget( share_label, 0, 1, 0 );
      m_layout->addWidget( share, 0, 2, 0 );
      m_layout->addWidget( comment_label, 1, 1, 0 );
      m_layout->addWidget( comment, 1, 2, 0 );
      m_layout->addWidget( type_label, 2, 1, 0 );
      m_layout->addWidget( type, 2, 2, 0 );

      if ( !m_item->isPrinter() )
      {
        m_layout->addWidget( mounted_label, 3, 1, 0 );
        m_layout->addWidget( mounted, 3, 2, 0 );
        m_layout->addMultiCellWidget( line, 4, 4, 1, 2, Qt::AlignCenter );
        m_layout->addWidget( host_label, 5, 1, 0 );
        m_layout->addWidget( host, 5, 2, 0 );
        m_layout->addWidget( ip_label, 6, 1, 0 );
        m_layout->addWidget( ip_address, 6, 2, 0 );
      }
      else
      {
        m_layout->addMultiCellWidget( line, 3, 3, 1, 2, Qt::AlignCenter );
        m_layout->addWidget( host_label, 4, 1, 0 );
        m_layout->addWidget( host, 4, 2, 0 );
        m_layout->addWidget( ip_label, 5, 1, 0 );
        m_layout->addWidget( ip_address, 5, 2, 0 );
      }

      break;
    }
    default:
    {
      break;
    }
  }

  QLabel *pix_label = new QLabel( this );
  pix_label->setPixmap( m_item->desktopIcon() );

  m_layout->addMultiCellWidget( pix_label, 0, m_layout->numRows(), 0, 0, Qt::AlignCenter );
}


void Smb4KNetworkBrowserToolTip::update()
{
  // This function updates a tool tip that
  // is shown. So, if the tool tip exists, but
  // is not shown, stop here.
  if ( !isShown() )
  {
    return;
  }

  switch ( m_item->type() )
  {
    case Smb4KNetworkBrowserItem::Workgroup:
    {
      QLabel *master_label = static_cast<QLabel *>( child( "MasterBrowser", "QLabel", true ) );

      if ( master_label )
      {
        QString master_string = m_item->workgroupItem()->masterIP().isEmpty() ?
                                m_item->workgroupItem()->master() :
                                m_item->workgroupItem()->master() + " ("+m_item->workgroupItem()->masterIP()+")";

        master_label->setText( master_string );
      }

      break;
    }
    case Smb4KNetworkBrowserItem::Host:
    {
      QLabel *os_label =     static_cast<QLabel *>( child( "OSString", "QLabel", true ) );
      QLabel *server_label = static_cast<QLabel *>( child( "ServerString", "QLabel", true ) );
      QLabel *ip_label =     static_cast<QLabel *>( child( "IPAddress", "QLabel", true ) );

      if ( os_label )
      {
        QString os_string = m_item->hostItem()->osString().isEmpty() ?
                            i18n( "Unknown" ) :
                            m_item->hostItem()->osString();

        os_label->setText( os_string );
      }

      if ( server_label )
      {
        QString server_string = m_item->hostItem()->serverString().isEmpty() ?
                                i18n( "Unknown" ) :
                                m_item->hostItem()->serverString();

        server_label->setText( server_string );
      }

      if ( ip_label )
      {
        QString ip_string = m_item->hostItem()->ip().isEmpty() ?
                            i18n( "Unknown" ) :
                            m_item->hostItem()->ip();

        ip_label->setText( ip_string );
      }

      break;
    }
    case Smb4KNetworkBrowserItem::Share:
    {
      QLabel *ip_label = static_cast<QLabel *>( child( "IPAddress", "QLabel", true ) );

      if ( ip_label )
      {
        Smb4KHostItem *host = static_cast<Smb4KNetworkBrowserItem *>( m_item->parent() )->hostItem();
        QString ip_string;

        if ( host )
        {
          ip_string = (host && !host->ip().isEmpty()) ?
                      host->ip() :
                      i18n( "Unknown" );
        }
        else
        {
          ip_string = i18n( "Unknown" );
        }

        ip_label->setText( ip_string );
      }

      break;
    }
    default:
    {
      break;
    }
  }
}


void Smb4KNetworkBrowserToolTip::mousePressEvent( QMouseEvent *e )
{
  hide();
  QLabel::mousePressEvent( e );
}


void Smb4KNetworkBrowserToolTip::leaveEvent( QEvent *e )
{
  hide();
  QLabel::leaveEvent( e );
}


/////////////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATIONS
/////////////////////////////////////////////////////////////////////////////

void Smb4KNetworkBrowserToolTip::slotHideToolTip()
{
  if ( isShown() )
  {
    hide();
  }
}


#include "smb4knetworkbrowsertooltip.moc"
