
from smart.report import Report
from smart.transaction import ChangeSet

from smart.const import *

import sys

import platform

def _distribution():
    if platform.system() == 'Linux':
        if hasattr(platform, 'linux_distribution'):
            distribution = platform.linux_distribution()
        else:
            distribution = platform.dist()
        return "-".join(distribution) + "-" + platform.machine()
    else:
        return platform.platform()

try:
    from hashlib import md5
except ImportError:
    from md5 import md5

try:
    from xml.etree import ElementTree
except ImportError:
    try:
        from elementtree import ElementTree
    except ImportError:
        from smart.util.elementtree import ElementTree

try:
    from uuid import uuid1
except ImportError:
    from smart.util.uuid import uuid1

from datetime import datetime

def _rfc822(dt):
    # Can't use strftime because that's locale dependent
    return "%s, %02d %s %04d %02d:%02d:%02d GMT" % (
            ["Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun"][dt.weekday()],
            dt.day,
            ["Jan", "Feb", "Mar", "Apr", "May", "Jun",
             "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"][dt.month-1],
            dt.year, dt.hour, dt.minute, dt.second)

class DistributionUpgradeabilityDescription:
    """ Distribution Upgradeability Description Format (DUDF) """

    def __init__(self, changeset=None):
        self._changeset = changeset
    
    def dump(self, success=True):
        dudf = ElementTree.Element("dudf")
        dudf.attrib["version"] = "1.0"
        dudf.attrib["xmlns"] = "http://www.mancoosi.org/2008/cudf/dudf"
        dudf.attrib["xmlns:dudf"] = "http://www.mancoosi.org/2008/cudf/dudf"
        timestamp = ElementTree.SubElement(dudf, "timestamp")
        timestamp.text = _rfc822(datetime.utcnow())
        uid = ElementTree.SubElement(dudf, "uid")
        uid.text = str(uuid1())
        distribution = ElementTree.SubElement(dudf, "distribution")
        distribution.text = _distribution()
        installer = ElementTree.SubElement(dudf, "installer")
        name = ElementTree.SubElement(installer, "name")
        version = ElementTree.SubElement(installer, "version")
        metainstaller = ElementTree.SubElement(dudf, "meta-installer")
        name = ElementTree.SubElement(metainstaller, "name")
        name.text = "smart"
        version = ElementTree.SubElement(metainstaller, "version")
        version.text = VERSION

        changeset = self._changeset
        problem = ElementTree.SubElement(dudf, "problem")
        status = ElementTree.SubElement(problem, "package-status")
        if changeset:
            list = ElementTree.SubElement(problem, "package-list")
            list.attrib["dudf:format"] = "smart"
            for pkg in changeset.getCache().getPackages():
                list.text += pkg.__getstate__()
        
        
        installer = ElementTree.SubElement(status, "installer")
        metainstaller = ElementTree.SubElement(status, "meta-installer")
        metainstaller.text = ""
        universe = ElementTree.SubElement(problem, "package-universe")
        action = ElementTree.SubElement(problem, "action")
        action.text = ""
        desiderata = ElementTree.SubElement(problem, "desiderata")
        desiderata.text = ""
        # TODO
        outcome = ElementTree.SubElement(dudf, "outcome")
        if success:
            dudf.attrib["xmlns:result"] = "success"
            status = ElementTree.SubElement(outcome, "package-status")
            installer = ElementTree.SubElement(status, "installer")
            metainstaller = ElementTree.SubElement(status, "meta-installer")
            metainstaller.text = ""
            # TODO
        else:
            dudf.attrib["xmlns:result"] = "failure"
            error = ElementTree.SubElement(outcome, "error")
            # TODO
        comment = ElementTree.SubElement(dudf, "comment")
        ElementTree.ElementTree(dudf).write(sys.stdout)

class CommonUpgradeabilityDescription:
    """ Common Upgradeability Description Format (CUDF) """

    def __init__(self, changeset=None):
        self._changeset = changeset
    
    def dump(self):
        changeset = self._changeset
        report = Report(changeset)
        report.compute()
        for pkg in changeset.getCache().getPackages():
            print "Package: %s" % pkg.name
            print "Version: %s" % pkg.version
            reqs = []
            for req in pkg.requires:
                reqs.append(str(req))
            if reqs:
                print "Depends: %s" % ", ".join(reqs)
            prvs = []
            for prv in pkg.provides:
                if prv.name == pkg.name: continue
                prvs.append(str(prv))
            if prvs:
                print "Provides: %s" % ", ".join(prvs)
            cnfs = []
            for cnf in pkg.conflicts:
                cnfs.append(str(cnf))
            if cnfs:
                print "Conflicts: %s" % ", ".join(cnfs)
            if pkg.installed:
                print "Installed: true"
            print
        
        md5sum = md5()
        print "Problem: source: Smart/DUDF %s" % md5sum.hexdigest()
        pkgs = []
        for pkg in report.installing.keys():
            pkgs.append(str(pkg))
        if pkgs:
            print "Install: %s" % ", ".join(pkgs)
        pkgs = []
        for pkg in report.upgrading.keys():
            pkgs.append(str(pkg))
        if pkgs:
            print "Upgrade: %s" % ", ".join(pkgs)


if __name__ == "__main__":
    DistributionUpgradeabilityDescription().dump()
