
#ifndef STRIDE
#define STRIDE 1
#endif

static void NAME (TYPE *image, int w, int h, int which_axes)
{
   /* Reflects the image about X=width/2 OR Y=height/2 OR both, per the
      which_axes bit values.  Vertical flip can be useful, for example,
      to adjust image formats like FITS, which uses a Cartesian coord
      system where (0,0) is in the lower left corner, to match the
      "usual" comp sci notion that (0,0) is in the upper left corner. */

   register int half, i, j;
   register TYPE v;
   register TYPE *chunk1, *chunk2;
   register TYPE *pixels = image;
   register int nx = w*STRIDE, ny = h;
 
   if (which_axes & 0x01) {				/* X axis */

	half = w / 2;

	for (i=0; i < ny; i++) {
	   chunk1 = pixels + i*nx;
	   chunk2 = chunk1 + nx - STRIDE;
	   for (j=0; j < half; j++) {
#if STRIDE > 1
		memcpy(buf, chunk1, STRIDE);
		memcpy(chunk1, chunk2, STRIDE);
		memcpy(chunk2, buf, STRIDE);
		chunk2 -= STRIDE;
		chunk1 += STRIDE;
#else
		v = *chunk1;
		*(chunk1++) = *chunk2;
		*(chunk2--) = (TYPE)v;
#endif
	   }
	}
  }

  if (which_axes & 0x02) {				/* Y axis */

	half = ny / 2;

	for (i=0; i < half; i++) {
	   chunk1 = &pixels[i*nx];
	   chunk2 = &pixels[(ny-1-i) * nx];
	   for (j=0; j < nx; j++) {
		v = *chunk1;
		*(chunk1++) = *chunk2;
		*(chunk2++) = v;
	   }
	}
  }
}

#undef NAME
#undef TYPE
#undef STRIDE
