static variable window = NULL;

static define toggle_frame (checkbutton, entry)
{
   gtk_entry_set_has_frame (entry, gtk_toggle_button_get_active(checkbutton));
}

static define toggle_sensitive (checkbutton, entry)
{
   gtk_widget_set_sensitive (entry, gtk_toggle_button_get_active(checkbutton));
}

static define activate_cb(entry)
{
  vmessage("Text area contains: '%s'", gtk_entry_get_text(entry));
}

define create_entry (test)
{
   if (window == NULL) {

	window = gtk_window_new (GTK_WINDOW_TOPLEVEL);

	() = g_signal_connect (window, "destroy",
			  &gtk_widget_destroyed,
			  &window);

	gtk_window_set_title (window, "entry");
	gtk_window_set_default_size(window, 350, 250);
	gtk_container_set_border_width (window, 20);

	variable vbox = gtk_vbox_new (FALSE, 10);
	gtk_container_add ( window, vbox);

	% Note that this example is much simpler than the testgtk.c
	% version shipped with Gtk because the latter uses GtkCombo,
	% which not only requires the deprecated GtkList, but will
	% soon be deprecated itself.

	variable entry = gtk_entry_new ();
	gtk_entry_set_text(entry, "hello world السلام عليكم");
	gtk_editable_select_region (entry, 0, 5);
	() = g_signal_connect(entry, "activate", &activate_cb );
	gtk_container_add(vbox, entry);

	variable align = gtk_alignment_new(0.5, 0.5, 0.0, 0.0);
	gtk_container_add(vbox,align);

	variable sensitive_check = gtk_check_button_new_with_label("Sensitive");
	gtk_container_add(align, sensitive_check);
	() = g_signal_connect (sensitive_check, "toggled",
			  		&toggle_sensitive, entry);
	gtk_toggle_button_set_active(sensitive_check, TRUE);

	align = gtk_alignment_new(0.5, 0.5, 0.0, 0.0);
	gtk_container_add(vbox,align);
	variable has_frame_check = gtk_check_button_new_with_label("Has Frame");
	gtk_container_add(align, has_frame_check);
	() = g_signal_connect (has_frame_check,"toggled",&toggle_frame,entry);
	gtk_toggle_button_set_active(has_frame_check, TRUE);

	variable label = gtk_label_new("Click within the text entry field "+
		"and press\nENTER to trigger the 'activate' signal");
	gtk_container_add(vbox, label);

	test.lower = generic_close_button(vbox,window);
   }

   if (gtk_widget_visible (window))
	gtk_widget_destroy (window);
   else
	gtk_widget_show_all (window);
}
