/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE support@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * A widget selector.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgwidgetselector.h"

#include <QToolButton>
#include <qpropertyanimation.h>

SKGWidgetSelector::SKGWidgetSelector(QWidget* parent)
    : QWidget(parent), m_currentMode(-1), m_alwaysOneOpen(false)
{
    ui.setupUi(this);
}

SKGWidgetSelector::~SKGWidgetSelector()
{
}

void SKGWidgetSelector::addButton(const QIcon& iIcon, const QString& iTitle, const QString& iToolTip, QWidget* iWidgets)
{
    SKGListQWidget list;
    list.push_back(iWidgets);
    addButton(iIcon, iTitle, iToolTip, list);
}

void SKGWidgetSelector::addButton(const QIcon& iIcon, const QString& iTitle, const QString& iToolTip, const SKGWidgetSelector::SKGListQWidget& iListOfShownWidgets)
{
    //Create button
    QToolButton* btn = new QToolButton(this);
    btn->setCheckable(true);
    btn->setToolButtonStyle(Qt::ToolButtonTextBesideIcon);
    btn->setAutoRaise(true);
    btn->setText(iTitle);
    btn->setToolTip(iToolTip);
    btn->setIcon(iIcon);

    ui.horizontalLayout->insertWidget(m_listButton.count(), btn);

    QObject::connect(btn, SIGNAL(clicked()), this, SLOT(onButtonClicked()));

    //Memorize items
    m_listButton.push_back(btn);
    m_listWidgets.push_back(iListOfShownWidgets);

    //Hide widgets
    foreach(QWidget * w, iListOfShownWidgets) {
        if (w) w->hide();
    }
}

int SKGWidgetSelector::getSelectedMode() const
{
    return m_currentMode;
}

void SKGWidgetSelector::setSelectedMode(int iMode)
{
    if (iMode != m_currentMode) {
        //Hide current widgets
        if (m_currentMode >= 0) {
            m_listButton.at(m_currentMode)->setChecked(false);
            SKGListQWidget list = m_listWidgets.at(m_currentMode);

            foreach(QWidget * w, list) {
                if (w) w->hide();

                /*{
                            QPropertyAnimation *anim1 = new QPropertyAnimation(w, "size");
                            anim1->setStartValue(QSize(w->width(), w->height()));
                            anim1->setEndValue(QSize(w->width(), 0));
                            anim1->setEasingCurve(QEasingCurve::InOutSine);
                            anim1->setDuration(500);
                            anim1->start();
                }*/
            }
        }

        //Set current mode
        m_currentMode = iMode;
        if (m_currentMode >= m_listWidgets.count()) m_currentMode = -1;

        //Show widgets
        if (m_currentMode >= 0) {
            m_listButton.at(m_currentMode)->setChecked(true);
            foreach(QWidget * w, m_listWidgets.at(m_currentMode)) {
                if (w) w->show();
                /*{
                            QPropertyAnimation *anim1 = new QPropertyAnimation(w, "size");
                            anim1->setStartValue(QSize(w->width(), 0));
                            anim1->setEndValue( w->sizeHint());
                            anim1->setEasingCurve(QEasingCurve::InOutSine);
                            anim1->setDuration(500);
                            anim1->start();
                w->show();
                }*/
            }
        }

        if (m_currentMode < -1) this->hide();

        emit selectedModeChanged(m_currentMode);
    }
}

void SKGWidgetSelector::setEnabledMode(int iMode, bool iEnabled)
{
    if (iMode >= 0 && iMode < m_listButton.count()) m_listButton.at(iMode)->setEnabled(iEnabled);
}

void SKGWidgetSelector::onButtonClicked()
{
    QToolButton* clickedButton = qobject_cast<QToolButton*>(sender());
    int newMode = m_listButton.indexOf(clickedButton);
    if (m_currentMode == newMode) {
        if (getAlwaysOneOpen()) {
            --newMode;
            if (newMode == -1) newMode = m_listButton.count() - 1;
        } else newMode = -1;
    }

    setSelectedMode(newMode);
}

bool SKGWidgetSelector::getAlwaysOneOpen() const
{
    return m_alwaysOneOpen;
}
void SKGWidgetSelector::setAlwaysOneOpen(bool iMode)
{
    m_alwaysOneOpen = iMode;
}

#include "skgwidgetselector.moc"

