/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE support@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the impgnced warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * This file is Skrooge plugin for for XML import / export.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgimportpluginxml.h"
#include "skgtraces.h"
#include "skgdocumentbank.h"
#include <skgservices.h>

#include <klocale.h>
#include <ksavefile.h>

#include <qfileinfo.h>

/**
 * This plugin factory.
 */
K_PLUGIN_FACTORY(SKGImportPluginXmlFactory, registerPlugin<SKGImportPluginXml>();)
/**
 * This plugin export.
 */
K_EXPORT_PLUGIN(SKGImportPluginXmlFactory("skrooge_import_xml", "skrooge_import_xml"))

SKGImportPluginXml::SKGImportPluginXml(QObject* iImporter, const QVariantList& iArg)
    : SKGImportPlugin(iImporter)
{
    SKGTRACEIN(10, "SKGImportPluginXml::SKGImportPluginXml");
    Q_UNUSED(iArg);
}

SKGImportPluginXml::~SKGImportPluginXml()
{
}

bool SKGImportPluginXml::isExportPossible()
{
    SKGTRACEIN(10, "SKGImportPluginCsv::isExportPossible");
    return (!m_importer ? true : QFileInfo(m_importer->getFileName()).suffix().toUpper() == "XML");
}

SKGError SKGImportPluginXml::exportFile()
{
    SKGError err;
    QDomDocument doc;
    err = SKGServices::copySqliteDatabaseToXml(m_importer->getDocument()->getDatabase(), doc);
    if (!err) {
        KSaveFile file(m_importer->getFileName());
        if (!file.open()) {
            err.setReturnCode(ERR_INVALIDARG);
            err.setMessage(i18nc("Error message",  "Save file '%1' failed", m_importer->getFileName()));
        } else {
            QTextStream stream(&file);
            if (!m_importer->getCodec().isEmpty()) stream.setCodec(m_importer->getCodec().toAscii().constData());
            stream << doc.toString() << endl;
        }

        //Close file
        file.finalize();
        file.close();
    }
    return err;
}

QString SKGImportPluginXml::getMimeTypeFilter() const
{
    return "*.xml|" % i18nc("A file format", "XML file");
}

#include "skgimportpluginxml.moc"
