/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE support@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * A plugin to highlight objects
 *
 * @author Stephane MANKOWSKI
 */
#include "skghighlightplugin.h"
#include "skgtraces.h"
#include "skgmainpanel.h"
#include "skgtransactionmng.h"

#include <kactioncollection.h>
#include <kstandardaction.h>
#include <kaboutdata.h>

/**
 * This plugin factory.
 */
K_PLUGIN_FACTORY(SKGHighlightPluginFactory, registerPlugin<SKGHighlightPlugin>();)
/**
 * This plugin export.
 */
K_EXPORT_PLUGIN(SKGHighlightPluginFactory("skg_highlight", "skg_highlight"))

SKGHighlightPlugin::SKGHighlightPlugin(QObject* iParent, const QVariantList& /*iArg*/) : SKGInterfacePlugin(iParent)
{
    SKGTRACEIN(10, "SKGHighlightPlugin::SKGHighlightPlugin");
}

SKGHighlightPlugin::~SKGHighlightPlugin()
{
    SKGTRACEIN(10, "SKGHighlightPlugin::~SKGHighlightPlugin");
    m_currentDocument = NULL;
    m_switchHighLight = NULL;
}

bool SKGHighlightPlugin::setupActions(SKGDocument* iDocument, const QStringList& iArgument)
{
    SKGTRACEIN(10, "SKGHighlightPlugin::setupActions");
    Q_UNUSED(iArgument);

    m_currentDocument = iDocument;

    setComponentData(KGlobal::mainComponent());
    setXMLFile("../skg_highlight/skg_highlight.rc");

    //------------
    m_switchHighLight = new KAction(KIcon("rating"), i18nc("Verb", "Switch highlight"), this);
    connect(m_switchHighLight, SIGNAL(triggered(bool)), this, SLOT(actionSwitchHighLight()));
    actionCollection()->addAction(QLatin1String("edit_switch_highlight"), m_switchHighLight);
    m_switchHighLight->setShortcut(Qt::CTRL + Qt::Key_H);

    if (SKGMainPanel::getMainPanel()) SKGMainPanel::getMainPanel()->registedGlobalAction("edit_switch_highlight", m_switchHighLight);


    //Create yours actions here
    return true;
}

void SKGHighlightPlugin::refresh()
{
    SKGTRACEIN(10, "SKGOperationPlugin::refresh");
    if (m_currentDocument && SKGMainPanel::getMainPanel()) {
        SKGObjectBase::SKGListSKGObjectBase selection = SKGMainPanel::getMainPanel()->getSelectedObjects();
        if (selection.count() > 0) {
            if (m_switchHighLight) m_switchHighLight->setEnabled(selection.at(0).getAttributes().contains("t_bookmarked"));
        } else {
            if (m_switchHighLight) m_switchHighLight->setEnabled(false);
        }
    }
}

QString SKGHighlightPlugin::title() const
{
    return toolTip();
}

QString SKGHighlightPlugin::icon() const
{
    return "rating";
}

QString SKGHighlightPlugin::toolTip() const
{
    return i18nc("The tool tip", "Highlight");
}

int SKGHighlightPlugin::getOrder() const
{
    return 6;
}

void SKGHighlightPlugin::actionSwitchHighLight()
{
    SKGError err;
    SKGTRACEINRC(10, "SKGHighlightPlugin::actionSwitchHighLight", err);
    //Get Selection
    if (SKGMainPanel::getMainPanel() && m_currentDocument) {
        SKGObjectBase::SKGListSKGObjectBase selection = SKGMainPanel::getMainPanel()->getSelectedObjects();
        int nb = selection.count();
        {
            SKGBEGINLIGHTPROGRESSTRANSACTION(*m_currentDocument, i18nc("Noun, name of the user action", "Highlight"), err, nb);
            for (int i = 0; !err && i < nb; ++i) {
                SKGObjectBase obj = selection.at(i);
                if (!err) err = obj.setAttribute("t_bookmarked", obj.getAttribute("t_bookmarked") == "Y" ? "N" : "Y");
                if (!err) err = obj.save();
                if (!err) err = m_currentDocument->stepForward(i + 1);
            }
        }

        //status bar
        if (!err)  err = SKGError(0, i18nc("Successful message after an user action", "Highlighted."));
        else err.addError(ERR_FAIL, i18nc("Error message",  "Highlight failed"));

        //Display error
        SKGMainPanel::displayErrorMessage(err);
    }
}

#include "skghighlightplugin.moc"
