/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE support@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * This file implements classes SKGPropertyObject.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgpropertyobject.h"


SKGPropertyObject::SKGPropertyObject(SKGDocument* iDocument, int iID): SKGNamedObject(iDocument, "parameters", iID)
{
}

SKGPropertyObject::~SKGPropertyObject()
{
}

SKGPropertyObject::SKGPropertyObject(const SKGPropertyObject& iObject)
    : SKGNamedObject(iObject)
{
}
SKGPropertyObject::SKGPropertyObject(const SKGObjectBase& iObject)
    : SKGNamedObject(iObject.getDocument(), "parameters", iObject.getID())
{
}

const SKGPropertyObject& SKGPropertyObject::operator= (const SKGObjectBase & iObject)
{
    copyFrom(iObject);
    return *this;
}

SKGError SKGPropertyObject::setParentId(const QString& iParentId)
{
    return setAttribute("t_uuid_parent", iParentId);
}

QString SKGPropertyObject::getParentId() const
{
    return getAttribute("t_uuid_parent");
}

SKGError SKGPropertyObject::setValue(const QString& iValue)
{
    return setAttribute("t_value", iValue);
}

QString SKGPropertyObject::getValue() const
{
    return getAttribute("t_value");

}

QString SKGPropertyObject::getWhereclauseId() const
{
    //Could we use the id
    QString output = SKGObjectBase::getWhereclauseId();
    if(output.isEmpty()) {
        if(!(getAttribute("t_name").isEmpty())) {
            output = "t_name='" % SKGServices::stringToSqlString(getAttribute("t_name")) % '\'';
        }
        if(!(getAttribute("t_uuid_parent").isEmpty())) {
            if(!output.isEmpty()) output += " AND ";
            output += "t_uuid_parent='" % getAttribute("t_uuid_parent") % '\'';
        }
    }
    return output;
}

#include "skgpropertyobject.moc"
