/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE support@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
#ifndef SKGMONTHLYPLUGINWIDGET_H
#define SKGMONTHLYPLUGINWIDGET_H
/** @file
 * A skrooge plugin for monthly report
*
* @author Stephane MANKOWSKI
*/
#include "ui_skgmonthlypluginwidget_base.h"
#include "skgtabpage.h"
#include "skginterfaceplugin.h"

class SKGDocumentBank;
/**
 * A skrooge plugin for monthly report
 */
class SKGMonthlyPluginWidget : public SKGTabPage
{
    Q_OBJECT
    /**
     * The current month
     */
    Q_PROPERTY(QString month READ getMonth)

    /**
     * The previous month
     */
    Q_PROPERTY(QString previous_month READ getPreviousMonth)

    /**
     * The budget table
     */
    Q_PROPERTY(QVariantList budget_table READ getBudgetTable)

    /**
     * The unit table
     */
    Q_PROPERTY(QVariantList unit_table READ getUnitTable)

    /**
     * The account table
     */
    Q_PROPERTY(QVariantList account_table READ getAccountTable)

    /**
     * The main categories of the month
     */
    Q_PROPERTY(QVariantList categories_month READ get5MainCategoriesMonth)

    /**
     * The main categories of the previous month
     */
    Q_PROPERTY(QVariantList categories_previous_month READ get5MainCategoriesPreviousMonth)

    /**
     * The income versus expenditure
     */
    Q_PROPERTY(QVariantList income_vs_expenditure READ getIncomeVsExpenditure)

    /**
     * The main categories variations
     */
    Q_PROPERTY(QStringList categories_variations READ get5MainCategoriesVariation)

    /**
     * The main nls strings
     */
    Q_PROPERTY(QStringList titles READ getTitles)

    /**
     * The current advices
     */
    Q_PROPERTY(QVariant advices READ getAdvices)
public:
    /**
     * Default Constructor
     */
    SKGMonthlyPluginWidget(SKGDocument* iDocument);

    /**
     * Default Destructor
     */
    virtual ~SKGMonthlyPluginWidget();

    /**
     * Get the current state
     * MUST BE OVERWRITTEN
     * @return a string containing all information needed to set the same state.
     * Could be an XML stream
     */
    virtual QString getState();

    /**
     * Set the current state
     * MUST BE OVERWRITTEN
     * @param iState must be interpreted to set the state of the widget
     */
    virtual void setState(const QString& iState);

    /**
     * Get attribute name to save the default state
     * MUST BE OVERWRITTEN
     * @return attribute name to save the default state.
     */
    virtual QString getDefaultStateAttribute();

    /**
     * Get the main widget
     * @return a widget
     */
    virtual QWidget* mainWidget() const;

    /**
     * Get the current month
     * @return the current month
     */
    virtual QString getMonth();

    /**
     * Get the previous month
     * @return the previous month
     */
    virtual QString getPreviousMonth();

    /**
     * Get the budget table
     * @return the budget table
     */
    virtual QVariantList getBudgetTable();

    /**
     * Get the unit table
     * @return the unit table
     */
    virtual QVariantList getUnitTable();

    /**
     * Get the account table
     * @return the account table
     */
    virtual QVariantList getAccountTable();

    /**
     * Get the main categories of the month
     * @return the main categories of the month
     */
    virtual QVariantList get5MainCategoriesMonth();

    /**
     * Get the main categories of the previous month
     * @return the main categories of the previous month
     */
    virtual QVariantList get5MainCategoriesPreviousMonth();

    /**
     * Get the main categories variations
     * @return the main categories variations
     */
    virtual QStringList get5MainCategoriesVariation();

    /**
     * Get the main titles
     * @return the main titles
     */
    virtual QStringList getTitles();

    /**
     * Get the income versus expenditure
     * @return the income versus expenditure
     */
    virtual QVariantList getIncomeVsExpenditure();

    /**
     * Get advices
     * @return the advices
     */
    virtual QVariant getAdvices();

private Q_SLOTS:
    void dataModified(const QString& iTableName, int iIdTransaction);
    void onMonthChanged();
    void onGetNewHotStuff();
    QString getReport();

private:
    Q_DISABLE_COPY(SKGMonthlyPluginWidget);
    void fillTemplateList();

    Ui::skgmonthlyplugin_base ui;

    QHash<QString, QVariant> m_cache;
};

#endif // SKGMonthlyPLUGINWIDGET_H
