/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE support@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
#ifndef SKGIMPORTEXPORTPLUGIN_H
#define SKGIMPORTEXPORTPLUGIN_H
/** @file
 * This file is Skrooge plugin for import and export operation.
*
* @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skginterfaceplugin.h"
#include "skgimportexportmanager.h"
#include "ui_skgimportexportpluginwidget_pref.h"

#include <QObject>
#include <QVariantList>
#include <kgenericfactory.h>

class KAction;
class SKGDocumentBank;
class SKGMainPanel;

/**
 * This file is Skrooge plugin for import and export operation
 */
class SKGImportExportPlugin : public SKGInterfacePlugin
{
    Q_OBJECT
    Q_INTERFACES(SKGInterfacePlugin);

public:
    /**
     * Default Constructor
     */
    SKGImportExportPlugin(QObject* iParent, const QVariantList& iArg);

    /**
     * Default Destructor
     */
    virtual ~SKGImportExportPlugin();

    /**
     * Called to initialise the plugin
     * @param iDocument the main document
     * @param iArgument the arguments
     * @return true if the plugin is compatible with the document
     */
    virtual bool setupActions(SKGDocument* iDocument, const QStringList& iArgument);

    /**
     * This function is called when the application is launched again with new arguments
     * @param iArgument the arguments
     */
    virtual void processArguments(const QStringList& iArgument);

    /**
     * Must be modified to refresh widgets after a modification.
     */
    virtual void refresh();

    /**
     * The preference widget of the plugin.
     * @return The preference widget of the plugin
     */
    virtual QWidget* getPreferenceWidget();

    /**
     * The preference skeleton of the plugin.
     * @return The preference skeleton of the plugin
     */
    virtual KConfigSkeleton* getPreferenceSkeleton();

    /**
     * The title of the plugin.
     * @return The title of the plugin
     */
    virtual QString title() const;

    /**
     * The icon of the plugin.
     * @return The icon of the plugin
     */
    virtual QString icon() const;

    /**
     * The toolTip of the plugin.
     * @return The toolTip of the plugin
     */
    virtual QString toolTip() const;

    /**
     * Must be implemented to set the position of the plugin.
     * @return integer value between 0 and 999 (default = 999)
     */
    virtual int getOrder() const;

    /**
     * The tips list of the plugin.
     * @return The tips list of the plugin
     */
    virtual QStringList tips() const;

    /**
     * The advice list of the plugin.
     * @return The advice list of the plugin
     */
    virtual SKGAdviceList advices() const;

    /**
     * Must be implemented to execute the automatic correction for the advice.
     * @param iAdviceIdentifier the identifier of the advice
     * @param iSolution the identifier of the possible solution
     * @return an object managing the error. MUST return ERR_NOTIMPL if iAdviceIdentifier is not known
     *   @see SKGError
     */
    virtual SKGError executeAdviceCorrection(const QString& iAdviceIdentifier, int iSolution) const;

Q_SIGNALS:
    /**
     * request to import a file
     * @param iFile file name
     */
    void importFile(const QString& iFile);

private Q_SLOTS:
    void import(const QString& iFile = "");
    void exportFile();
    void foundTransfer();
    void anonymize();
    void cleanBanks();
    void validateImportedOperations();
    void openNotValidated() const;
    void mergeImportedOperation();
private:
    Q_DISABLE_COPY(SKGImportExportPlugin);
    void openLastModifiedIfSetting();

    KAction *m_importAction;
    KAction *m_importCsvUnitAction;
    KAction *m_exportFileAction;
    KAction *m_processingFoundTransfert;
    KAction *m_processingBank;
    KAction *m_processingAnonymize;
    KAction *m_validateImportedOperationsAction;
    KAction *m_openNotValidatedAction;
    KAction *m_mergeImportedOperationAction;

    SKGDocumentBank* m_currentBankDocument;

    Ui::skgimportexportplugin_pref ui;
};

#endif // SKGDEBUGPLUGIN_H
