/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * A zoom selector.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgzoomselector.h"
#include "skglineedit.h"

#include <qtextstream.h>

SKGZoomSelector::SKGZoomSelector ( QWidget *parent )
        : QWidget ( parent )
{
    ui.setupUi ( this );

    //Set icons
    ui.kZoomIn->setIcon ( KIcon ( "zoom-in" ) );
    ui.kZoomOut->setIcon ( KIcon ( "zoom-out" ) );
    ui.kZoomOriginal->setIcon ( KIcon ( "zoom-original" ) );
}

SKGZoomSelector::~SKGZoomSelector()
{
}

void SKGZoomSelector::setValue(int iValue)
{
    ui.kZoomSlider->setValue(iValue);
}

int SKGZoomSelector::value() const
{
    return ui.kZoomSlider->value();
}

void SKGZoomSelector::onZoomIn()
{
    ui.kZoomSlider->setValue ( ui.kZoomSlider->value() + 1 );
}

void SKGZoomSelector::onZoomOut()
{
    ui.kZoomSlider->setValue ( ui.kZoomSlider->value() - 1 );
}

void SKGZoomSelector::onZoomInit()
{
    ui.kZoomSlider->setValue ( 0 );
}

void SKGZoomSelector::onZoomChanged()
{
    int val=ui.kZoomSlider->value();
    if (ui.kZoomIn) ui.kZoomIn->setEnabled(val<10);
    if (ui.kZoomOut) ui.kZoomOut->setEnabled(val>-10);
    if (ui.kZoomOriginal) ui.kZoomOriginal->setChecked(val==0);

    emit changed(val);
}
#include "skgzoomselector.moc"

