/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * This file is a test script.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgtestmacro.h"
#include "skgimportexportmanager.h"
#include "skgbankincludes.h"

/**
 * The main function of the unit test
 * @param argc the number of arguments
 * @param argv the list of arguments
 */
int main ( int argc, char** argv )
{
    Q_UNUSED ( argc );
    Q_UNUSED ( argv );

    //Init test
    SKGINITTEST ( true );

    {
        //Test import GNUCASH
        SKGDocumentBank document1;
        SKGTESTERROR ( "document1.initialize()", document1.initialize(), true );
        SKGError err;
        {
            //Scope of the transaction
            SKGBEGINTRANSACTION ( document1, "IMPORT_GNUCASH", err );

            SKGImportExportManager imp1 ( &document1, getTestPath ( "IN" ) +"/skgtestimportgnucash/test_data.uncompressed" );
            SKGTESTERROR ( "GNUCASH.importFile", imp1.importFile(), true );
        }

        {
            SKGAccountObject account ( &document1 );
            SKGTESTERROR ( "GNUCASH.setName", account.setName ( "Accounts Receivable" ), true );
            SKGTESTERROR ( "GNUCASH.load", account.load(), true );
            SKGTEST ( "GNUCASH:getCurrentAmount", SKGServices::doubleToString ( account.getCurrentAmount() ), "231.11" );

        }
    }

    {
        //Test import GNUCASH
        SKGDocumentBank document1;
        SKGTESTERROR ( "document1.initialize()", document1.initialize(), true );
        SKGError err;
        {
            //Scope of the transaction
            SKGBEGINTRANSACTION ( document1, "IMPORT_GNUCASH", err );

            SKGImportExportManager imp1 ( &document1, getTestPath ( "IN" ) +"/skgtestimportgnucash/all.uncompressed" );
            SKGTESTERROR ( "GNUCASH.importFile", imp1.importFile(), true );
        }

        {
            SKGAccountObject account ( &document1 );
            SKGTESTERROR ( "GNUCASH.setName", account.setName ( "COMPTE COURANT" ), true );
            SKGTESTERROR ( "GNUCASH.load", account.load(), true );
            SKGTEST ( "GNUCASH:getCurrentAmount", SKGServices::doubleToString ( account.getCurrentAmount() ), "-700" );

        }

        {
            SKGAccountObject account ( &document1 );
            SKGTESTERROR ( "GNUCASH.setName", account.setName ( "COMPTE EPARGNE" ), true );
            SKGTESTERROR ( "GNUCASH.load", account.load(), true );
            SKGTEST ( "GNUCASH:getCurrentAmount", SKGServices::doubleToString ( account.getCurrentAmount() ), "250" );

        }

        {
            SKGAccountObject account ( &document1 );
            SKGTESTERROR ( "GNUCASH.setName", account.setName ( "Actif" ), true );
            SKGTESTERROR ( "GNUCASH.load", account.load(), true );
            SKGTEST ( "GNUCASH:getCurrentAmount", SKGServices::doubleToString ( account.getCurrentAmount() ), "-420" );
        }

        {
            SKGAccountObject account ( &document1 );
            SKGTESTERROR ( "GNUCASH.setName", account.setName ( "TITRE" ), true );
            SKGTESTERROR ( "GNUCASH.load", account.load(), true );
            SKGTEST ( "GNUCASH:getCurrentAmount", SKGServices::doubleToString ( account.getCurrentAmount() ), "520" );
        }
    }

    {
        //Test import GNUCASH
        SKGDocumentBank document1;
        SKGTESTERROR ( "document1.initialize()", document1.initialize(), true );
        SKGError err;
        {
            //Scope of the transaction
            SKGBEGINTRANSACTION ( document1, "IMPORT_GNUCASH", err );

            SKGImportExportManager imp1 ( &document1, getTestPath ( "IN" ) +"/skgtestimportgnucash/initial_balance.uncompressed" );
            SKGTESTERROR ( "GNUCASH.importFile", imp1.importFile(), true );
        }

        {
            SKGAccountObject account ( &document1 );
            SKGTESTERROR ( "GNUCASH.setName", account.setName ( "CCP" ), true );
            SKGTESTERROR ( "GNUCASH.load", account.load(), true );
            SKGTEST ( "GNUCASH:getCurrentAmount", SKGServices::doubleToString ( account.getCurrentAmount() ), "100" );
        }

        int nb=0;
        SKGTESTERROR ( "GNUCASH:getNbObjects(unit, PRIMARY)", SKGObjectBase::getNbObjects ( &document1, "unit", "t_type='1'", nb ), true );
        SKGTEST ( "GNUCASH:getNbObjects(unit, PRIMARY)", nb, 1 );
        SKGTESTERROR ( "GNUCASH:getNbObjects(unit, SHARE)", SKGObjectBase::getNbObjects ( &document1, "unit", "t_type='S'", nb), true );
        SKGTEST ( "GNUCASH:getNbObjects(unit, SHARE)", nb, 13 );
    }

    {
        //Test import GNUCASH
        SKGDocumentBank document1;
        SKGTESTERROR ( "document1.initialize()", document1.initialize(), true );
        SKGError err;
        {
            //Scope of the transaction
            SKGBEGINTRANSACTION ( document1, "IMPORT_GNUCASH", err );

            SKGImportExportManager imp1 ( &document1, getTestPath ( "IN" ) +"/skgtestimportgnucash/transfert-CPP-vers-PEE.uncompressed" );
            SKGTESTERROR ( "GNUCASH.importFile", imp1.importFile(), true );
        }

        {
            SKGAccountObject account ( &document1 );
            SKGTESTERROR ( "GNUCASH.setName", account.setName ( "CCP" ), true );
            SKGTESTERROR ( "GNUCASH.load", account.load(), true );
            SKGTEST ( "GNUCASH:getCurrentAmount", SKGServices::doubleToString ( account.getCurrentAmount() ), "750" );
        }

        {
            SKGAccountObject account ( &document1 );
            SKGTESTERROR ( "GNUCASH.setName", account.setName ( "CEL Donald" ), true );
            SKGTESTERROR ( "GNUCASH.load", account.load(), true );
            SKGTEST ( "GNUCASH:getCurrentAmount", SKGServices::doubleToString ( account.getCurrentAmount() ), "150" );
        }

        {
            SKGAccountObject account ( &document1 );
            SKGTESTERROR ( "GNUCASH.setName", account.setName ( "PEEs" ), true );
            SKGTESTERROR ( "GNUCASH.load", account.load(), true );
            SKGTEST ( "GNUCASH:getCurrentAmount", SKGServices::doubleToString ( account.getCurrentAmount() ), "190" );
        }

        {
            int nb=0;
            SKGTESTERROR ( "GNUCASH:getNbObjects", SKGObjectBase::getNbObjects ( &document1, "category","", nb  ), true );
            SKGTEST ( "GNUCASH:getNbObjects", nb , 27 );
        }
    }

    {
        //Test import GNUCASH
        SKGDocumentBank document1;
        SKGTESTERROR ( "document1.initialize()", document1.initialize(), true );
        SKGError err;
        {
            //Scope of the transaction
            SKGBEGINTRANSACTION ( document1, "IMPORT_GNUCASH", err );

            SKGImportExportManager imp1 ( &document1, getTestPath ( "IN" ) +"/skgtestimportgnucash/transfert-PEE-vers-CCP.uncompressed" );
            SKGTESTERROR ( "GNUCASH.importFile", imp1.importFile(), true );
        }

        {
            SKGAccountObject account ( &document1 );
            SKGTESTERROR ( "GNUCASH.setName", account.setName ( "CCP" ), true );
            SKGTESTERROR ( "GNUCASH.load", account.load(), true );
            SKGTEST ( "GNUCASH:getCurrentAmount", SKGServices::doubleToString ( account.getCurrentAmount() ), "1140" );
        }

        {
            SKGAccountObject account ( &document1 );
            SKGTESTERROR ( "GNUCASH.setName", account.setName ( "CEL Donald" ), true );
            SKGTESTERROR ( "GNUCASH.load", account.load(), true );
            SKGTEST ( "GNUCASH:getCurrentAmount", SKGServices::doubleToString ( account.getCurrentAmount() ), "150" );
        }

        {
            SKGAccountObject account ( &document1 );
            SKGTESTERROR ( "GNUCASH.setName", account.setName ( "PEEs" ), true );
            SKGTESTERROR ( "GNUCASH.load", account.load(), true );
            SKGTEST ( "GNUCASH:getCurrentAmount", SKGServices::doubleToString ( account.getCurrentAmount() ), "100" );
        }

        {
            SKGBEGINTRANSACTION ( document1, "IMPORT_GNUCASH", err );
            SKGCategoryObject cat;
            SKGTESTERROR ( "GNUCASH.createPathCategory", SKGCategoryObject::createPathCategory (&document1, "Depenses > Frais bancaires", cat ), true );
            SKGTEST ( "GNUCASH:getCurrentAmount", SKGServices::doubleToString ( cat.getCurrentAmount() ), "-10" );
        }

        SKGTESTERROR("DOC:dump",document1.dump(DUMPCATEGORY), true);
    }

    {
        //Test import GNUCASH
        SKGDocumentBank document1;
        SKGTESTERROR ( "document1.initialize()", document1.initialize(), true );
        SKGError err;
        {
            //Scope of the transaction
            SKGBEGINTRANSACTION ( document1, "IMPORT_GNUCASH", err );

            SKGImportExportManager imp1 ( &document1, getTestPath ( "IN" ) +"/skgtestimportgnucash/interet-revenue-frais.gnucash" );
            SKGTESTERROR ( "GNUCASH.importFile", imp1.importFile(), true );
        }

        {
            SKGAccountObject account ( &document1 );
            SKGTESTERROR ( "GNUCASH.setName", account.setName ( "CCP" ), true );
            SKGTESTERROR ( "GNUCASH.load", account.load(), true );
            SKGTEST ( "GNUCASH:getCurrentAmount", SKGServices::doubleToString ( account.getCurrentAmount() ), "750" );
        }

        {
            SKGAccountObject account ( &document1 );
            SKGTESTERROR ( "GNUCASH.setName", account.setName ( "CEL Donald" ), true );
            SKGTESTERROR ( "GNUCASH.load", account.load(), true );
            SKGTEST ( "GNUCASH:getCurrentAmount", SKGServices::doubleToString ( account.getCurrentAmount() ), "150" );
        }

        {
            SKGAccountObject account ( &document1 );
            SKGTESTERROR ( "GNUCASH.setName", account.setName ( "PEEs" ), true );
            SKGTESTERROR ( "GNUCASH.load", account.load(), true );
            SKGTEST ( "GNUCASH:getCurrentAmount", SKGServices::doubleToString ( account.getCurrentAmount() ), "640" );
        }
    }

    {
        //Test import GNUCASH
        SKGDocumentBank document1;
        SKGTESTERROR ( "document1.initialize()", document1.initialize(), true );
        SKGError err;
        {
            //Scope of the transaction
            SKGBEGINTRANSACTION ( document1, "IMPORT_GNUCASH", err );

            SKGImportExportManager imp1 ( &document1, getTestPath ( "IN" ) +"/skgtestimportgnucash/rapprochement-incorrect.uncompressed" );
            SKGTESTERROR ( "GNUCASH.importFile", imp1.importFile(), true );
        }

        {
            int nb=0;
            SKGTESTERROR ( "GNUCASH:getNbObjects", SKGObjectBase::getNbObjects ( &document1, "operation","t_status='Y'", nb  ), true );
            SKGTEST ( "GNUCASH:getNbObjects", nb , 7 );
        }

    }

    {
        //Test import GNUCASH
        SKGDocumentBank document1;
        SKGTESTERROR ( "document1.initialize()", document1.initialize(), true );
        SKGError err;
        {
            //Scope of the transaction
            SKGBEGINTRANSACTION ( document1, "IMPORT_GNUCASH", err );

            SKGImportExportManager imp1 ( &document1, getTestPath ( "IN" ) +"/skgtestimportgnucash/scheduled-action.uncompressed" );
            SKGTESTERROR ( "GNUCASH.importFile", imp1.importFile(), true );
        }


        {
            SKGObjectBase::SKGListSKGObjectBase recurrentoperations;
            SKGTESTERROR ( "GNUCASH:SKGListSKGObjectBase", SKGObjectBase::getObjects ( &document1, "recurrentoperation","", recurrentoperations  ), true );
            SKGTEST ( "GNUCASH:nb", recurrentoperations.count() , 1 );
            if (recurrentoperations.count()==1)
            {
                SKGRecurrentOperationObject recu=recurrentoperations.at(0);
                SKGTEST ( "GNUCASH:getDate", recu.getDate().toString() , QDate(2010,03,02).toString() );
                SKGTEST ( "GNUCASH:getAutoWriteDays", recu.getAutoWriteDays() , 10 );
                SKGTEST ( "GNUCASH:getPeriodIncrement", recu.getPeriodIncrement() , 1 );
                SKGTEST ( "GNUCASH:getPeriodUnit", recu.getPeriodUnit() , SKGRecurrentOperationObject::MONTH );
                SKGTEST ( "GNUCASH:getWarnDays", recu.getWarnDays() , 0 );
                SKGTEST ( "GNUCASH:isAutoWriteEnabled", recu.isAutoWriteEnabled() , false );
                SKGTEST ( "GNUCASH:isWarnEnabled", recu.isWarnEnabled() , false );
                SKGTEST ( "GNUCASH:hasTimeLimit", recu.hasTimeLimit() , false );
            }
        }
    }

    {
        //Test import GNUCASH - bug 228808
        SKGDocumentBank document1;
        SKGTESTERROR ( "document1.initialize()", document1.initialize(), true );
        SKGError err;
        {
            //Scope of the transaction
            SKGBEGINTRANSACTION ( document1, "IMPORT_GNUCASH", err );

            SKGImportExportManager imp1 ( &document1, getTestPath ( "IN" ) +"/skgtestimportgnucash/228808.gnc" );
            SKGTESTERROR ( "GNUCASH.importFile", imp1.importFile(), true );
        }


        {
            SKGObjectBase::SKGListSKGObjectBase recurrentoperations;
            SKGTESTERROR ( "GNUCASH:SKGListSKGObjectBase", SKGObjectBase::getObjects ( &document1, "recurrentoperation","1=1 ORDER BY d_date", recurrentoperations  ), true );
            SKGTEST ( "GNUCASH:nb", recurrentoperations.count() , 2 );
            if (recurrentoperations.count()==2)
            {
                SKGRecurrentOperationObject recu=recurrentoperations.at(0);
                SKGOperationObject op;
                SKGTESTERROR ( "GNUCASH:getParentOperation", recu.getParentOperation(op), true );
                SKGTEST ( "GNUCASH:getCurrentAmount", op.getCurrentAmount() , -50 );

                recu=recurrentoperations.at(1);
                SKGTESTERROR ( "GNUCASH:getParentOperation", recu.getParentOperation(op), true );
                SKGTEST ( "GNUCASH:getCurrentAmount", op.getCurrentAmount() , -18.75 );
            }
        }
    }

    {
        //Test import GNUCASH - bug 228904
        SKGDocumentBank document1;
        SKGTESTERROR ( "document1.initialize()", document1.initialize(), true );
        SKGError err;
        {
            //Scope of the transaction
            SKGBEGINTRANSACTION ( document1, "IMPORT_GNUCASH", err );

            SKGImportExportManager imp1 ( &document1, getTestPath ( "IN" ) +"/skgtestimportgnucash/228904.gnucash" );
            SKGTESTERROR ( "GNUCASH.importFile", imp1.importFile(), true );
        }


        {
            SKGObjectBase::SKGListSKGObjectBase recurrentoperations;
            SKGTESTERROR ( "GNUCASH:SKGListSKGObjectBase", SKGObjectBase::getObjects ( &document1, "recurrentoperation","1=1 ORDER BY d_date", recurrentoperations  ), true );
            SKGTEST ( "GNUCASH:nb", recurrentoperations.count() , 2 );
        }
    }

    {
        //Test import 228901
        SKGDocumentBank document1;
        SKGTESTERROR ( "document1.initialize()", document1.initialize(), true );
        SKGError err;
        {
            //Scope of the transaction
            SKGBEGINTRANSACTION ( document1, "IMPORT_GNUCASH", err );

            SKGImportExportManager imp1 ( &document1, getTestPath ( "IN" ) +"/skgtestimportgnucash/228901.gnucash" );
            SKGTESTERROR ( "GNUCASH.importFile", imp1.importFile(), true );
        }

        {
            SKGAccountObject account ( &document1 );
            SKGTESTERROR ( "GNUCASH.setName", account.setName ( "Compte emprunt" ), true );
            SKGTESTERROR ( "GNUCASH.load", account.load(), true );
            SKGTEST ( "GNUCASH:getCurrentAmount", SKGServices::doubleToString ( account.getCurrentAmount() ), "-9476.01" );
        }

        //Test second import
        {
            //Scope of the transaction
            SKGBEGINTRANSACTION ( document1, "IMPORT_GNUCASH", err );

            SKGImportExportManager imp1 ( &document1, getTestPath ( "IN" ) +"/skgtestimportgnucash/228901.gnucash" );
            SKGTESTERROR ( "GNUCASH.importFile", imp1.importFile(), true );
        }
    }

    {
        //Test import 234608
        SKGDocumentBank document1;
        SKGTESTERROR ( "document1.initialize()", document1.initialize(), true );
        SKGError err;
        {
            //Scope of the transaction
            SKGBEGINTRANSACTION ( document1, "IMPORT_GNUCASH", err );

            SKGImportExportManager imp1 ( &document1, getTestPath ( "IN" ) +"/skgtestimportgnucash/234608.gnc" );
            SKGTESTERROR ( "GNUCASH.importFile", imp1.importFile(), true );
        }
    }

    {
        //Test import 234597
        SKGDocumentBank document1;
        SKGTESTERROR ( "document1.initialize()", document1.initialize(), true );
        SKGError err;
        {
            //Scope of the transaction
            SKGBEGINTRANSACTION ( document1, "IMPORT_GNUCASH", err );

            SKGImportExportManager imp1 ( &document1, getTestPath ( "IN" ) +"/skgtestimportgnucash/234597.gnc" );
            SKGTESTERROR ( "GNUCASH.importFile", imp1.importFile(), true );
        }
        {
            int nb=0;
            SKGTESTERROR ( "GNUCASH:getNbObjects", SKGObjectBase::getNbObjects ( &document1, "account","", nb  ), true );
            SKGTEST ( "GNUCASH:getNbObjects", nb , 2 );
        }
    }

    {
        //Test import 243738
        SKGDocumentBank document1;
        SKGTESTERROR ( "document1.initialize()", document1.initialize(), true );
        SKGError err;
        {
            //Scope of the transaction
            SKGBEGINTRANSACTION ( document1, "IMPORT_GNUCASH", err );

            SKGImportExportManager imp1 ( &document1, getTestPath ( "IN" ) +"/skgtestimportgnucash/243738.gnucash" );
            SKGTESTERROR ( "GNUCASH.importFile", imp1.importFile(), true );
        }
    }
    //End test
    SKGENDTEST();
}
