/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
#ifndef SKGDASHBOARDPLUGINWIDGET_H
#define SKGDASHBOARDPLUGINWIDGET_H
/** @file
 * A dashboard
*
* @author Stephane MANKOWSKI
*/
#include "ui_skgdashboardpluginwidget_base.h"
#include "skgtabpage.h"

#include <QGridLayout>
#include <QList>
#include <QStringList>

class KMenu;
class QSpacerItem;
class SKGInterfacePlugin;

/**
 * A dashboard
 */
class SKGDashboardPluginWidget : public SKGTabPage
{
    Q_OBJECT

public:
    /**
     * Default Constructor
     */
    SKGDashboardPluginWidget(SKGDocument* iDocument);

    /**
     * Default Destructor
     */
    virtual ~SKGDashboardPluginWidget();

    /**
     * Get the current state
     * MUST BE OVERWRITTEN
     * @return a string containing all information needed to set the same state.
     * Could be an XML stream
     */
    virtual QString getState();

    /**
     * Set the current state
     * MUST BE OVERWRITTEN
     * @param iState must be interpreted to set the state of the widget
     */
    virtual void setState(const QString& iState);

    /**
     * Get attribute name to save the default state
     * MUST BE OVERWRITTEN
     * @return attribute name to save the default state.
     */
    virtual QString getDefaultStateAttribute();

    /**
     * Get the widget must be printed
     * @return a widget
     */
    virtual QWidget* getWidgetForPrint();

    /**
     * Get the zoomable widget. MUST BE OVERWRITTEN
     * By Overwritting this function, you don't have to implement following ones.
     * @return the tree view.
     */
    virtual QWidget* zoomableWidget() const;

public slots:
    /**
    * Refresh the content.
     */
    virtual void refresh();

private slots:
    void showHeaderMenu ( const QPoint& pos );
    void onAddWidget();
    void onRemoveWidget();
    void onColumnNbChanged();
    void onMoveAfterWidget();
    void onMoveBeforeWidget();

private:
    Q_DISABLE_COPY(SKGDashboardPluginWidget);

    void addItem(SKGInterfacePlugin* iDashboard, int iIndex, const QString& iState="");

    Ui::skgdashboardplugin_base ui;
    QGridLayout* gridLayout;
    QSpacerItem* hSpacer;
    QSpacerItem* vSpacer;

    QStringList items;
    QList<SKGWidget*> itemsPointers;;
    KMenu* menu;
    QMenu* addMenu;
    QMenu* removeMenu;
    QMenu* previousMenu;
    QMenu* nextMenu;
    int col;
    int row;
    int nbMaxCol;
};

#endif // SKGDASHBOARDPLUGINWIDGET_H
