/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
#ifndef SKGBOOKMARKPLUGINDOCKWIDGET_H
#define SKGBOOKMARKPLUGINDOCKWIDGET_H
/** @file
* This file is a plugin for bookmarks management.
*
* @author Stephane MANKOWSKI / Guillaume DE BURE
*/
#include "ui_skgbookmarkplugindockwidget_base.h"
#include "skgtabpage.h"
#include "skgnodeobject.h"

class KMenu;

/**
 * This file is a plugin for undoredo management
 */
class SKGBookmarkPluginDockWidget : public SKGTabPage
{
    Q_OBJECT

public:
    /**
     * Default Constructor
     */
    SKGBookmarkPluginDockWidget(SKGDocument* iDocument);

    /**
     * Default Destructor
     */
    virtual ~SKGBookmarkPluginDockWidget();

    /**
     * Get the current selected bookmarks
     * @return selected bookmarks
     */
    virtual SKGObjectBase::SKGListSKGObjectBase getSelectedObjects();

    /**
     * Get the number of seleted bookmarks
     * @return number of selected bookmarks
     */
    virtual int getNbSelectedObjects();

    /**
     * Open a bookmark
     * @param iNode bookmark object to open
     * @param iFirstInNewPage to open first object in new page
     */
    static void openBookmark(const SKGNodeObject& iNode, bool iFirstInNewPage=false);

protected:
    /**
     * This event handler can be reimplemented in a subclass to receive widget resize events which are passed in the event parameter.
     * When resizeEvent() is called, the widget already has its new geometry. The old size is accessible through QResizeEvent::oldSize().
     * @param event the event pointer
     */
    virtual void resizeEvent(QResizeEvent *event);

public slots:
    /**
     * Refresh the content.
     */
    virtual void refresh();

private slots:
    void showMenu(const QPoint& pos);
    void onAddBookmarkGroup();
    void onAddBookmark();
    void onRemoveBookmark();
    void onRenameBookmark();
    void onBeforeOpenBookmark();
    void onOpenBookmark(const QModelIndex & index );
    void onOpenBookmarkFolder(const QModelIndex & index );
    void onBookmarkEditorChanged();
    void onSetAutostart();
    void onUnsetAutostart();

private:
    Q_DISABLE_COPY(SKGBookmarkPluginDockWidget);

    void setAutostart(const QString& value);

    Ui::skgbookmarkplugindockwidget_base ui;
    KMenu* mainMenu;
    QAction* actDelete;
    QAction* actRename;
    QAction* actAddBookmark;
    QAction* actAddBookmarkGroup;
    QAction* actSetAutostart;
    QAction* actUnsetAutostart;
    static bool middleClick;
};

#endif // SKGBOOKMARKPLUGINDOCKWIDGET_H
