/* # skkinput (Simple Kana-Kanji Input)
 * skkldrec.c --- 
 * This file is part of skkinput.
 * Copyright (C) 1997
 * Takashi SAKAMOTO (sakamoto@yajima.kuis.kyoto-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/* 񤫤֤ä褿δԤʬ*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <X11/Intrinsic.h>

#include "commondef.h"
#include "buffers.h"

/*
 * 
 */
#define HENKANKAKUTEIHASHSIZE	(128)
#define	HASHKEY_ASCIIETC	(0)
#define HASHKEY_ALPHABET	(1)
#define HASHKEY_ALPHABETSIZE	('z'-'a'+1)
#define HASHKEY_KANJI		(HASHKEY_ALPHABET+HASHKEY_ALPHABETSIZE)
#define HASHKEY_KANJISIZE	(HENKANKAKUTEIHASHSIZE-HASHKEY_KANJI)

/*
 * ɬפʤΤϡ̤ؤȺǤǶѤ줿Ѵ줿ʸפ򵭲
 * ǡ¤ȡѴ줿ɤΨŪΤǡ¤Ǥ롣
 * Ԥϥꥹȹ¤ѤơƬ˶ᤤǶǤȤˤɤ
 * Ԥϥϥåʬڤˤɬפġ ϥåʬڤ
 * ϻޤο­ʤ(;_;) Ͽǡ¤ȤȤ
 */
typedef struct _tmp_listUndHash {
  struct _tmp_listUndHash *left ;	/* λҶء*/
  struct _tmp_listUndHash *right ;	/* λҶء*/
  struct _tmp_listUndHash *past ;	/* ء*/
  struct _tmp_listUndHash *future ;	/* ء*/
  SkkinpSearchVector *henkankey ;	/* ХåեؤΥݥ󥿡*/
  int position, length ;		/* ֡Ĺ*/
  VectorIndex *henkanresults ;		/* Ѵ̤Ǽ*/
} SkkinpHenkanKakuteiKouho ;

/*
 * ץȥ
 */
/* skksvect.c */
SkkinpSearchVector *makeNewSkkinpSearchVectorNode( void ) ;
extern int copyCandidate
( struct myChar *dest, SkkinpSearchVector *sNode,
  int position, int length ) ;
VectorIndex *alloc_NewVectorIndexNode( void ) ;
int cmpCandidate
( SkkinpSearchVector *sNode1, int pos1, int len1,
  SkkinpSearchVector *sNode2, int pos2, int len2 ) ;
extern SkkinpSearchVector *add_SkkinpSearchVector
( SkkinpSearchVector *topp,   struct myChar *str,
  SkkinpSearchVector **rnode, int *pos ) ;
VectorIndex *makeSearchVectorIndex
( SkkinpSearchVector *top, int *totalnum, int flag ) ;
void free_SkkinpSearchVector( SkkinpSearchVector **top ) ;
void free_VectorIndex( VectorIndex **top ) ;
/* skkldic.c */
void writeVectorIndexToFile( FILE *fp, VectorIndex *vNode ) ;
SkkinpSearchVector *j_search_skkinput_jisyo_with_fileptr
( struct myChar *key, SkkinpSearchVector *top, int okuri, FILE *fp ) ;
/* skkldrec.c */
static int searchHNodeWithHenkanKeyAndResult
( SkkinpHenkanKakuteiKouho **hTop,
  struct myChar *henkankey, struct myChar *hresult,
  SkkinpHenkanKakuteiKouho **rhpNode,
  SkkinpHenkanKakuteiKouho **rhNode,
  VectorIndex **rvNode ) ;
static int searchHNodeWithHenkanKeyAndResultWithVI
( SkkinpHenkanKakuteiKouho **hTop,
  struct myChar *henkankey, VectorIndex *keyVNode,
  SkkinpHenkanKakuteiKouho **rhpNode,
  SkkinpHenkanKakuteiKouho **rhNode,
  VectorIndex **rvNode ) ;
static void delete_NodeInBinaryTree
( SkkinpHenkanKakuteiKouho **top,
  SkkinpHenkanKakuteiKouho **rTop,
  SkkinpHenkanKakuteiKouho *parentNode,
  SkkinpHenkanKakuteiKouho *deleteNode ) ;
static void skkinput_KakoToMiraiWoIrekaeru
( SkkinpHenkanKakuteiKouho **top ) ;

#ifdef DEBUG
static void debug_dump_kouhotree
( SkkinpHenkanKakuteiKouho *top ) ;
#endif

/*
 * Хѿ
 */
/* Ѵꤵ褿ʸ򵭲뤿ѤХåեꥹȤ *
 * Ƭ*/
static SkkinpSearchVector *henkanKakuteiBufferListTop ;

/* ǤǶѴꤵ줿ʸ򵭲ꥹȡꥹȤƬ *
 * ǶǤꡢعԤˤʤ롣겾̾ͭξˤϡˤ *
 * Ĥʤʤ*/
static SkkinpHenkanKakuteiKouho *recentlyKakuteiKouho ;

/* Ѵꤵ줿ʸ򸡺뤿Ѥϥåơ֥ *
 * (겾̵̾)
 */
static SkkinpHenkanKakuteiKouho *henkanKakuteiHash[ HENKANKAKUTEIHASHSIZE ] ;

/* Ѵꤵ줿ʸ򸡺뤿Ѥϥåơ֥ *
 * (겾̾ͭ)
 */
static SkkinpHenkanKakuteiKouho
*okuriHenkanKakuteiHash[ HENKANKAKUTEIHASHSIZE ] ;
/*
 * Ѵꤵ줿ФƤꥹ(겾̾)
 */
static SkkinpHenkanKakuteiKouho *recentlyOkuriariKakuteiKouho ;

/*
 * ιե饰
 */
extern Boolean skkinput_jisyo_dirty ;
extern Boolean skkinput_autosave_jisyo_dirty ;

/*
 * purge 줿Ф뤿Υꥹȡ
 *----
 * 겾̾ѴȤǤʤΤȤΤɬפǤ롣
 */
static SkkinpHenkanKakuteiKouho *purgeSaretaKouho[ HENKANKAKUTEIHASHSIZE ] ;
static SkkinpHenkanKakuteiKouho *purgeSaretaOkuriKouho[ HENKANKAKUTEIHASHSIZE ] ;
static SkkinpHenkanKakuteiKouho *recentlyPurgeKouho ;
static SkkinpHenkanKakuteiKouho *recentlyOkuriariPurgeKouho ;

/*
 * Хåե
 */
static struct myChar hashTempBuffer[ TEXTBUFSIZE ] ;

/*
 * ϥåơ֥ν򤹤ؿưɬƤ֤ȡ
 */
void initHenkanKakuteiHashTable( void )
{
  int i ;
  /* ϥåơ֥뼫Τν*/
  for( i = 0 ; i < HENKANKAKUTEIHASHSIZE ; i ++ ){
    henkanKakuteiHash[ i ]      = NULL ;
    okuriHenkanKakuteiHash[ i ] = NULL ;
    purgeSaretaKouho[ i ]       = NULL ;
    purgeSaretaOkuriKouho[ i ]  = NULL ;
  }
  /* ¾ΥꥹȤν*/
  recentlyKakuteiKouho         = NULL ;
  recentlyOkuriariKakuteiKouho = NULL ;
  recentlyPurgeKouho           = NULL ;
  recentlyOkuriariPurgeKouho   = NULL ;
  henkanKakuteiBufferListTop   = NULL ;
  return ;
}

/*
 * ϥåؿ
 */
static int henkanKakuteiHashFunction( struct myChar *henkankey )
{
  unsigned int ret ;
  int len = myCharStrlen( henkankey ) ;

  /* ѴĹʸ̤Ǥ뤫ǽʸǤʤʤ顣*/
  switch( henkankey->charset ){
  case CHARSET_ISO8859_1 :
  case CHARSET_ISO8859_2 :
  case CHARSET_ISO8859_3 :
  case CHARSET_ISO8859_4 :
  case CHARSET_ISO8859_5 :
  case CHARSET_ISO8859_6 :
  case CHARSET_ISO8859_7 :
  case CHARSET_ISO8859_8 :
  case CHARSET_ISO8859_9 :
  case CHARSET_JISX0201_1976 :
    /* Ǥʤƥե٥åȡ */
    if( 'a' <= henkankey->chara && henkankey->chara <= 'z' )
      return HASHKEY_ALPHABET -'a' + henkankey->chara ;
    if( 'A' <= henkankey->chara && henkankey->chara <= 'Z' )
      return HASHKEY_ALPHABET -'A' + henkankey->chara ;
    return HASHKEY_ASCIIETC ;
  case CHARSET_JISX0208_1978 :
  case CHARSET_JISX0208_1983 :
  case CHARSET_JISX0212_1990 :
  case CHARSET_GB2312_1980 :
  case CHARSET_KSC5601_1987 :
    if( len < 2 ){
      ret = ( henkankey->chara & 0x00FF ) + len * 21 + HASHKEY_KANJI ;
    } else {
      ret = ( henkankey->chara & 0x00FF ) + len * 17 ;
      henkankey ++ ;
      ret = ( ret + ( henkankey->chara & 0x00FF ) ) % HENKANKAKUTEIHASHSIZE ;
    }
    return ret % HENKANKAKUTEIHASHSIZE ;
  default :
    return HASHKEY_ASCIIETC ;
  }
}

static SkkinpHenkanKakuteiKouho *allocate_NewHenkanKakuteiKouhoSub
( void )
{
  SkkinpHenkanKakuteiKouho *hNode;

  /* malloc Ƥ*/
  hNode = ( SkkinpHenkanKakuteiKouho *)
    malloc( sizeof( SkkinpHenkanKakuteiKouho ) ) ;
  if( hNode == NULL ){
    fprintf( stderr, "Memory fault.\n" ) ;
    exit( 1 ) ;
  }
  hNode->left = hNode->right = hNode->past = hNode->future = NULL ;
  hNode->henkanresults = NULL ;
  return hNode ;
}

/*
 * ѴϿơѴФꥹȤΥΡɤݤؿ
 */
static SkkinpHenkanKakuteiKouho *allocate_NewHenkanKakuteiKouho
( struct myChar *henkankey )
{
  SkkinpHenkanKakuteiKouho *hNode ;
  /* ޤmalloc 롣*/
  hNode = allocate_NewHenkanKakuteiKouhoSub() ;
  /* ѴϿ롣*/
  henkanKakuteiBufferListTop = add_SkkinpSearchVector
    ( henkanKakuteiBufferListTop, henkankey,
      &hNode->henkankey, &hNode->position ) ;
  hNode->length    = myCharStrlen( henkankey ) ;
  /* ֤*/
  return hNode ;
}

/*
 * ʸ SkkinpSearchVector ʸӤؿ
 * ----
 * ա int  24 bit ʲưޤ
 */
static int cmpStringAndCandidate
( struct myChar *string, SkkinpSearchVector *sNode, int pos, int len )
{
  int ret ;
  struct myChar *ptr = sNode->text + pos ;
  int lchara1, lchara2 ;

  /* 괺ĹʬäƤ sNode->text 롣*/
  while( len > 0 ){
    if( IS_END_OF_STRING( *ptr ) ){
      sNode = sNode->next ;
      /* ξ硢string ³ɡ sNode->text Ԥ *
       * Τǡstring 礭*/
      if( sNode == NULL )
	return ( 1 ) ;
      ptr = sNode->text ;
    }
    if( IS_END_OF_STRING( *string ) ){
      /* ξ硢sNode->text ޤĤäƤΤǡstring  *
       * */
      return ( -1 ) ;
    }
    /* κ롣*/
    if( IS_ASCII_CHARA( *string ) ){
      lchara1 = ( CHARSET_ASCII << 16 ) | string->chara ;
    } else {
      lchara1 = ( string->charset << 16 ) | string->chara ;
    }
    if( IS_ASCII_CHARA( *string ) ){
      lchara2 = ( CHARSET_ASCII << 16 ) | ptr->chara ;
    } else {
      lchara2 = ( ptr->charset << 16 ) | ptr->chara ;
    }
    if( ( ret = lchara1 - lchara2 ) )
      return ret ;
    /* θܤ*/
    string ++ ;
    ptr ++ ;
    len -- ;
  }
  if( !IS_END_OF_STRING( *string ) )
    return 1 ;
  return 0 ;
}

/*
 * ѴϤĤѴ˻Ȥ줿Ĵ٤ؿ
 */
static SkkinpHenkanKakuteiKouho *sudeniHenkanKakuteiShitaNo
( struct myChar *henkankey, SkkinpHenkanKakuteiKouho **hTable )
{
  int hashkey ;
  int ret ;
  SkkinpHenkanKakuteiKouho *hNode ;

  /* ɤΥϥåؿѤɤΡ */
  hashkey = henkanKakuteiHashFunction( henkankey ) ;

  /* ϥåˤʤʤ顢Ф̵*/
  if( ( hNode = hTable[ hashkey ] ) == NULL )
    return NULL ;

  /* ʬõԤ*/
  while( hNode != NULL ){
    ret = cmpStringAndCandidate
      ( henkankey, hNode->henkankey, hNode->position, hNode->length ) ;
    if( ret == 0 ){
      /* ǤȤդޤĥѥѥѡ*/
      return hNode ;
    } else if( ret > 0 ){
      /* դޤǤĤ㤢˹ԤäƤߤޤ礦 */
      hNode = hNode->right ;
    } else {
      hNode = hNode->left ;
    }
  }
  /* ǸޤǸդޤǤġ*/
  return NULL ;
}

/*
 * ϿƤäʸ skkserv ֻΤ褦˸Ƥޤ
 * ؿʤȤ򤹤ΤϡȤľΤݤġ
 * äȡΨ뤫ʡ 
 */
static SkkinpSearchVector *makeSkkSearchVectorFromVectorIndex
( SkkinpSearchVector *top, VectorIndex *vNode )
{
  int len, rest ;
  struct myChar *ptr ;

  /* ɽѿν*/
  ptr = hashTempBuffer ;
  MYCHAR_SET_CHARA( *ptr, '/' ) ;
  ptr ++ ;
  MYCHAR_SET_END_OF_STRING( *ptr ) ;
  len     = 1 ;

  /* ᥤ롼סVectorIndex ³¤ޤ롣*/
  while( vNode != NULL ){
    if( vNode->length > TEXTMAXLEN ){
      /* ϤääƤĹѴ̤ϤȤƤѤǤʤΤ̵ *
       * 뤹롣*/
      vNode = vNode->next ;
      continue ;
    }
    /* ̤ΰ򸫤롣*/
    rest = TEXTMAXLEN - len - vNode->length ;
    if( rest == 0 ){
      /* ȴФ*/
      copyCandidate( ptr, vNode->node, vNode->position, vNode->length ) ;
      /* ХåեäѤˤʤäΤǡ괺Ͽ롣*/
      top = add_SkkinpSearchVector( top, hashTempBuffer, NULL, NULL ) ;
      /* Ƭ᤹*/
      ptr  = hashTempBuffer ;
      /* δ֤ζڤʸ롣*/
      MYCHAR_SET_CHARA( *ptr, '/' ) ;
      ptr ++ ;
      /* Ƚü롣*/
      MYCHAR_SET_END_OF_STRING( *ptr ) ;
      /* ʸäƤ֡*/
      len     = 1 ;
    } else if( rest > 0 ){
      /* ȴФ*/
      copyCandidate( ptr, vNode->node, vNode->position, vNode->length ) ;
      /* ʬĹʤ롣*/
      ptr += vNode->length ;
      len += vNode->length ;
      /* δ֤ζڤʸ롣*/
      MYCHAR_SET_CHARA( *ptr, '/' ) ;
      ptr ++ ;
      /* Ƚü롣*/
      MYCHAR_SET_END_OF_STRING( *ptr ) ;
      /* "/" 줿顢ʸȤФ롣*/
      len  ++ ;
    } else {
      /* ХåեäѤˤʤäΤǡ괺Ͽ롣*/
      top = add_SkkinpSearchVector( top, hashTempBuffer, NULL, NULL ) ;
      /*  "/" Ƥ뤫顢줺Ƭ᤹ɤ*/
      ptr  = hashTempBuffer ;
      MYCHAR_SET_END_OF_STRING( *ptr ) ;
      len  = 0 ;
      /* ä vNode ʤ᤿櫓ʤ*/
      continue ;
    }
    /* θؤȿʤࡣ*/
    vNode = vNode->next ;
  }
  if( len > 0 ){
    top = add_SkkinpSearchVector( top, hashTempBuffer, NULL, NULL ) ;
  }
  return top ;
}

/*
 * ѴꤷΤ椫鸡ؿ
 */
SkkinpSearchVector *searchSudeniHenkanKakuteiShitamono
( struct myChar *henkankey, SkkinpSearchVector *top, int okuri )
{
  SkkinpHenkanKakuteiKouho *hNode, **hTable ;

  /* 겾̾Ѵ */
  hTable = ( okuri )? okuriHenkanKakuteiHash : henkanKakuteiHash ;

  /* ѴꤷΤˤΤɤĴ٤ġ*/
  hNode = sudeniHenkanKakuteiShitaNo( henkankey, hTable )  ;
  if( hNode == NULL )
    return top ;

  top = makeSkkSearchVectorFromVectorIndex( top, hNode->henkanresults ) ;
  return top ;
}

/*
 * ѴꤷΤ椫鸡ؿ
 */
SkkinpSearchVector *searchSudeniPurgeSaretamono
( struct myChar *henkankey, SkkinpSearchVector *top, int okuri )
{
  SkkinpHenkanKakuteiKouho *hNode, **hTable ;

  /* 겾̾Ѵ */
  hTable = ( okuri )? purgeSaretaOkuriKouho : purgeSaretaKouho ;

  /* ѴꤷΤˤΤɤĴ٤ġ*/
  hNode = sudeniHenkanKakuteiShitaNo( henkankey, hTable ) ;
  if( hNode == NULL )
    return top ;

  top = makeSkkSearchVectorFromVectorIndex( top, hNode->henkanresults ) ;
  return top ;
}
			       
/*
 * Ѵꤷ̤ SearchVector ηˤؿ
 */
static SkkinpSearchVector *add_CandidateToSkkinpSearchVector
( SkkinpSearchVector *top, VectorIndex *vNode )
{
  SkkinpSearchVector *node, *sNode ;
  int len = vNode->length ;
  struct myChar *dest, *src ;

  /* ̤ƬΡ */
  if( top == NULL ){
    node = top = makeNewSkkinpSearchVectorNode() ;
    node->next = NULL ;
  } else {
    node = top ;
    while( node->next != NULL )
      node = node->next ;
  }

  /* copy ν*/
  sNode = vNode->node ;
  src   = sNode->text + vNode->position ;
  dest  = node->text + node->used ;

  /* ϰ֤Ͽ롣*/
  vNode->position = node->used ;
  vNode->node     = node ;

  while( len > 0 ){
    if( node->used >= TEXTMAXLEN ){
      /* ȽüƤ*/
      MYCHAR_SET_END_OF_STRING( node->text[ TEXTMAXLEN ] ) ;
      /* Ρɤݤ롣*/
      node->next = makeNewSkkinpSearchVectorNode() ;
      node = node->next ;
      node->next = NULL ;
      node->used = 0 ;
      dest = node->text ;
    }
    if( IS_END_OF_STRING( *src ) ){
      /* ࡩ ʸ򤿤ɤ꤭ʤˤ⤦ХåեڤƤޤä *
       * 롩 */
      if( sNode->next == NULL ){
	/* ʾ copy ǤʤΤǡʤ餳ޤǤʬ  *
	 * Ĥ֤*/
	MYCHAR_SET_END_OF_STRING( *dest ) ;
	/* ĹƤʤäʬȴ*/
	vNode->length = vNode->length - len ;
	return top ;
      }
    }
    *dest ++ = *src ++ ;
    node->used ++ ;
    len -- ;
  }
  /* λ*/
  MYCHAR_SET_END_OF_STRING( *dest ) ;
  return top ;
}

/*
 * j-completion Ѥ뤿˺ǤǶѴ˻Ȥ줿ʸ󤫤Ǥ
 * Ѵ˻Ȥ줿ʸޤǳФƤʤȤʤġФ
 * 뤿˺äꥹȤˡѴؿ
 */
static void miraiKaraKakoHetoHenkanSaretaKouhoWoOberu
( SkkinpHenkanKakuteiKouho **top, SkkinpHenkanKakuteiKouho *hNode )
{
  /* ˰ֺǶ˹Ԥ줿ѴäƤդϿƤΤʤ顢*
   * Фɬפʤ*/
  if( *top == hNode )
    return ;
  /* ϸߤˤˤ̤ˤĤ̤ϰäɡФ *
   * ȤΤʤ䤸㡪 */
  if( hNode->past == NULL && hNode->future == NULL ){
    /* ѴĲ˹Ԥ줿ѴϥꥹȤƬˤ롣*/
    hNode->past = *top ;
    /* ˥ꥹȤ˲äƤΤʤ顢Ƭΰ̤ǹԤ *
     * ѴäƤΤѴǤ롣*/
    if( *top != NULL )
      ( *top )->future = hNode ;
    /* Ƭư롣*/
    *top = hNode ;
  } else {
    /* ʤä顢ǶäƻפʤȤʤ顢Ƭؤ *
     * ư롣*/
    if( hNode->past != NULL )
      ( hNode->past )->future = hNode->future ;
    if( hNode->future != NULL )
      ( hNode->future )->past = hNode->past ;
    hNode->past   = *top ;
    hNode->future = NULL ;
    /* ޤNULL äƤȤ̵Ȼפɤ͡*/
    if( *top != NULL )
      ( *top )->future = hNode ;
    /* Ƭư롣*/
    *top = hNode ;
  }
  return ;
}

/*
 * ʬڤʸ henkankey õ䤬ʤп
 * Ĥؿ
 *--------
 *  hNode ʬڤκä
 */
static SkkinpHenkanKakuteiKouho *henkanKouhoWoSagashiteNakattaraMalloc
( SkkinpHenkanKakuteiKouho *hNode, struct myChar *henkankey,
  SkkinpHenkanKakuteiKouho *stringProvideNode )
{
  int ret ;

  while( 1 ){
    /* ƱѴǤ */
    ret = cmpStringAndCandidate
      ( henkankey, hNode->henkankey, hNode->position, hNode->length ) ;
    if( ret == 0 ){
      /* ƱѴǤ*/
      break ;
    } else if( ret > 0 ){
      /* λҶ򤿤ɤ硣*/
      if( hNode->right != NULL ){
	/* λҶޤ¸ߤ硣*/
	hNode = hNode->right ;
      } else {
	/* ˤϤʾҶ¸ߤʤ硣*/
	/* դäѤãȤȤϡѴϻȤ줿 * 
	 * ȤʤäȤȡ*/
	if( stringProvideNode == NULL ){
	  hNode->right = allocate_NewHenkanKakuteiKouho
	    ( henkankey ) ;
	  hNode = hNode->right ;
	} else {
	  hNode->right = allocate_NewHenkanKakuteiKouhoSub() ;
	  hNode = hNode->right ;
	  /* ʸϴ˳ݤƤΤǡͭ롣*/
	  hNode->henkankey = stringProvideNode->henkankey ;
	  hNode->position  = stringProvideNode->position ;
	  hNode->length    = stringProvideNode->length ;
	}
	hNode->henkanresults = NULL ;
	break ;
      }
    } else {
      /* λҶ򤿤ɤ硣*/
      if( hNode->left != NULL ){
	/* λҶޤ¸ߤ硣*/
	hNode = hNode->left ;
      } else {
	/* ˤϤʾҶ¸ߤʤ硣*/
	/* դäѤãȤȤϡѴϻȤ줿 * 
	 * ȤʤäȤȡ*/
	if( stringProvideNode == NULL ){
	  hNode->left = allocate_NewHenkanKakuteiKouho
	    ( henkankey ) ;
	  hNode = hNode->left ;
	} else {
	  hNode->left = allocate_NewHenkanKakuteiKouhoSub() ;
	  hNode = hNode->left ;
	  /* ʸϴ˳ݤƤΤǡͭ롣*/
	  hNode->henkankey = stringProvideNode->henkankey ;
	  hNode->position  = stringProvideNode->position ;
	  hNode->length    = stringProvideNode->length ;
	}
	hNode->henkanresults = NULL ;
	break ;
      }
    }
  }
  return hNode ;
}

/*
 * ꤵ줿Ѵ̤¸ߤƤɤĴ٤ؿ
 */
static VectorIndex *katsuteNoHenkanKekkaWoSenkeiTansaku
( VectorIndex *maeNoHenkanKekka, VectorIndex *konkaiNoHenkanKekka )
{
  /* Ѵ줿̤֤ϥ롼סõʤʡ*/
  while( maeNoHenkanKekka != NULL ){
    /* ϿƤޤ */
    if( !cmpCandidate
	( maeNoHenkanKekka->node, maeNoHenkanKekka->position,
	  maeNoHenkanKekka->length,
	  konkaiNoHenkanKekka->node, konkaiNoHenkanKekka->position,
	  konkaiNoHenkanKekka->length ) ){
      return maeNoHenkanKekka ;
    }
    /* Ѵ̤򸫤롣*/
    maeNoHenkanKekka = maeNoHenkanKekka->next ;
  }
  return NULL ;
}

/*
 * VectorIndex Ǻ줿ꥹȤ1ꥹȤƬؤȰư
 * ؿ
 */
static void shiteisaretaVectorIndexWoListNoSentouNiMottekuru
	( VectorIndex **vTop, VectorIndex *vNode )
{
  /* Ƭʤ餳ʾä褦ˤʤ*/
  if( *vTop == vNode )
    return ;
  /* ƬʤäĤޤꥹȤ椫鳰*/
  if( vNode->prev != NULL )
    ( vNode->prev )->next = vNode->next ;
  if( vNode->next != NULL )
    ( vNode->next )->prev = vNode->prev ;
  /* ΥΡɤμΥΡɤƬΥΡɤǤ롣*/
  vNode->next = *vTop ;
  /* ΥΡɤΥΡɤ¸ߤʤ*/
  vNode->prev = NULL ;
  /* ƬΥΡɤ¸ߤƤ顢ΥΡɤΥΡ *
   * ϤΥΡɤǤ롣*/
  if( *vTop != NULL )
    ( *vTop )->prev = vNode ;
  /* ƬΡɤϤΥΡɤǤ롣*/
  *vTop = vNode ;
  /* λ*/
  return ;
}

/*
 * Ѵ˻Ȥ줿ȤѴ̾˿Ѵ
 * Ѵ̤äؿ
 */
void add_SudeniHenkanKakuteiShitamono
( struct myChar *henkankey, VectorIndex **vectorindextop,
  VectorIndex *hresult, int okuri )
{
  int ret, kanzenSairiyou = False ;
  SkkinpHenkanKakuteiKouho *hNode,  **hTop, **rhTop ;
  SkkinpHenkanKakuteiKouho *phNode, **pTop, *phpNode, **rpTop ;
  VectorIndex *vNode1, *vNode2, *pvNode ;

  /* ˻äƤ뼭Ͽ뤫顢True */
  skkinput_jisyo_dirty          = True ;
  /* ȥ֤Ԥ褦˻ؼ롣*/
  skkinput_autosave_jisyo_dirty = True ;

  vNode1 = hresult ;
  ret = henkanKakuteiHashFunction( henkankey ) ;

#ifdef DEBUG
  fprintf( stderr, "Touroku : \"%s\"\n", henkankey ) ;
  fflush( stderr ) ;
#endif
  /* 겾̾Ѵɤǧ롣*/
  if( okuri ){
    /* 겾̾Ѵäν*/
    hTop  = &okuriHenkanKakuteiHash[ ret ] ;
    pTop  = &purgeSaretaOkuriKouho[ ret ] ;
    rhTop = &recentlyOkuriariKakuteiKouho ;
    rpTop = &recentlyOkuriariPurgeKouho ;
  } else {
    /* 겾̾ѴǤʤäν*/
    hTop  = &henkanKakuteiHash[ ret ] ;
    pTop  = &purgeSaretaKouho[ ret ] ;
    rhTop = &recentlyKakuteiKouho ;
    rpTop = &recentlyPurgeKouho ;
  }

  /* Purge ꥹȤ˴ˤѴ̤äƤޤäƤΤ *
   * Τʡ ȡäʤȴǤ衩 */
  /* ѴΤ¸ߤ롩 */
  if( searchHNodeWithHenkanKeyAndResultWithVI
      ( pTop, henkankey, vNode1, &phpNode, &phNode, &pvNode ) ){
    if( pvNode == phNode->henkanresults ){
      /* ƤѴ̤줿ȤˤʤΡ */
      if( ( phNode->henkanresults = pvNode->next ) == NULL ){
	/* ʬڤ롣free Ϥʤ*/
	delete_NodeInBinaryTree
	  ( pTop, rpTop, phpNode, phNode ) ;
	kanzenSairiyou = True ;
      } else {
	( pvNode->next )->prev = NULL ;
	kanzenSairiyou = False ;
      }
    } else {
      /* ꥹȤѡ̤롣*/
      if( pvNode->next != NULL )
	( pvNode->next )->prev = pvNode->prev ;
      if( pvNode->prev != NULL )
	( pvNode->prev )->next = pvNode->next ;
      kanzenSairiyou = False ;
    }
    /* äǤϡvNode1 ΤǡvNode Ѥ̣Ϥʤ *
     * ȸȤɡvNode1 λäƤʸϤϤä *
     * äƤ顢Τ˲Ǥʤ*/
  } else {
    phNode = NULL ;
    pvNode  = NULL ;
  }

  /* ϥå夬ҥåȤɤ򸫤롣*/
  if( *hTop == NULL ){
    /* ϥå˺Τ褦ѴϿƤޤ*/
#ifdef DEBUG
    fprintf( stderr, "Hast Table is NULL.\n" ) ;
    fflush( stderr ) ;
#endif
    /* Ρɤݤ롣*/
    if( phNode != NULL ){
      /* hNode 贰˺Ѳǽʡ */
      if( kanzenSairiyou ){
	hNode = phNode ;
	hNode->left = hNode->right =
	  hNode->future = hNode->past = NULL ;
      } else {
	/* ʤä顢ؤƤ륹ȥ󥰤ͭ롣*/
	hNode = allocate_NewHenkanKakuteiKouhoSub() ;
	hNode->henkankey = phNode->henkankey ;
	hNode->position  = phNode->position ;
	hNode->length    = phNode->length ;
      }
    } else {
      /* Ȥ櫓ǡΡɤݤޤ*/
      hNode = allocate_NewHenkanKakuteiKouho( henkankey ) ;
    }
    /* ϥåơ֥⹹ޤ*/
    *hTop = hNode ;
    hNode->henkanresults = NULL ;
  } else {
    /* ʲʬõƱѴȤ줿Ȥ뤫ɤĴ *
     * ٤ޤ*/
    hNode = henkanKouhoWoSagashiteNakattaraMalloc
      ( *hTop, henkankey, phNode ) ;
    /* ǤϹ⡹ʸζͭǤޤΤǡphNodeΤϲ *
     * ޤ*/
    if( phNode != NULL && kanzenSairiyou )
      free( phNode ) ;
  }
  /* ꤵ줿ΤֽƤꥹȤ˲ä롣*/
  miraiKaraKakoHetoHenkanSaretaKouhoWoOberu( rhTop, hNode ) ;

  /* ѴФƲ˹Ԥ줿Ѵη̤򸫤롣*/
  vNode2 = katsuteNoHenkanKekkaWoSenkeiTansaku
    ( hNode->henkanresults, vNode1 ) ;
  if( vNode2 != NULL ){
    /* ⤦ϿƤä顢Ƭ˻ä롣*/
    shiteisaretaVectorIndexWoListNoSentouNiMottekuru
      ( &hNode->henkanresults, vNode2 ) ;
    /* ѡꥹȤǸդäפä롣*/
    if( pvNode != NULL )
      free( pvNode ) ;
    return ;
  }
  /* Ƭä顢ؤƤݥ󥿤⤺餹*/
  if( vNode1->prev == NULL ){
    *vectorindextop = vNode1->next ;
  } else {
    ( vNode1->prev )->next = vNode1->next ;
  }
  if( vNode1->next != NULL ){
    ( vNode1->next )->prev = vNode1->prev ;
  }
  if( vNode1 == *vectorindextop ){
    *vectorindextop = vNode1->next ;
  }
  /* ϿƤʤää顢 vNode1 ʤ *
   * vNode1 åäơSkkinpSearchVector ϼΤΤ˰ư *
   * 롣*/
  if( pvNode != NULL ){
    vNode1->node     = pvNode->node ;
    vNode1->length   = pvNode->length ;
    vNode1->position = pvNode->position ;
    /* ʸϤΤפˤʤäġ*/
    free( pvNode ) ;
  } else {
    henkanKakuteiBufferListTop = 
      add_CandidateToSkkinpSearchVector
      ( henkanKakuteiBufferListTop, vNode1 ) ;
  }
  /* vNode1 ꥹȤƬؤȻäƤ롣*/
  shiteisaretaVectorIndexWoListNoSentouNiMottekuru
    ( &hNode->henkanresults, vNode1 ) ;
  return ;
}

/*
 * Ѵ˻Ȥ줿ȤѴ̾˿Ѵ
 * Ѵ̤äؿ
 */
void add_SudeniHenkanKakuteiShitamonoByString
( struct myChar *henkankey, struct myChar *hresult, int okuri )
{
  int ret, kanzenSairiyou = False ;
  SkkinpHenkanKakuteiKouho *hNode,  **hTop, **rhTop ;
  SkkinpHenkanKakuteiKouho *phNode, **pTop, *phpNode, **rpTop ;
  VectorIndex *vNode, *pvNode ;

  /* ˻äƤ뼭Ͽ뤫顢True */
  skkinput_jisyo_dirty          = True ;
  skkinput_autosave_jisyo_dirty = True ;

  ret = henkanKakuteiHashFunction( henkankey ) ;

  /* 겾̾ѴʤΡ Ȥ㤦Ρ */
  if( okuri ){
    hTop  = &okuriHenkanKakuteiHash[ ret ] ;
    pTop  = &purgeSaretaOkuriKouho[ ret ] ;
    rhTop = &recentlyOkuriariKakuteiKouho ;
    rpTop = &recentlyOkuriariPurgeKouho ;
  } else {
    /* 겾̾Ѵʤäν*/
    hTop  = &henkanKakuteiHash[ ret ] ;
    pTop  = &purgeSaretaKouho[ ret ] ;
    rhTop = &recentlyKakuteiKouho ;
    rpTop = &recentlyPurgeKouho ;
  }

  /* Purge ꥹȤ˴ˤѴ̤äƤޤäƤΤ *
   * Τʡ ȡäʤȴǤ衩 */
  /* ѴΤ¸ߤ롩 */
  if( searchHNodeWithHenkanKeyAndResult
      ( pTop, henkankey, hresult, &phpNode, &phNode, &pvNode ) ){
    if( pvNode == phNode->henkanresults ){
      /* ƤѴ̤줿ȤˤʤΡ */
      if( ( phNode->henkanresults = pvNode->next ) == NULL ){
	/* ʬڤ롣free Ϥʤ*/
	delete_NodeInBinaryTree( pTop, rpTop, phpNode, phNode ) ;
	kanzenSairiyou = True ;
      } else {
	( pvNode->next )->prev = NULL ;
	kanzenSairiyou = False ;
      }
    } else {
      /* ꥹȤѡ̤롣*/
      if( pvNode->next != NULL )
	( pvNode->next )->prev = pvNode->prev ;
      if( pvNode->prev != NULL )
	( pvNode->prev )->next = pvNode->next ;
      kanzenSairiyou = False ;
    }
    /* ǡpvNode Ѳͤ뤫⤷ʤΤǲ˳ *
     * ݤƤ*/
  } else {
    phNode = NULL ;
    pvNode  = NULL ;
    kanzenSairiyou = False ;
  }
#ifdef DEBUG
  fprintf( stderr, "Touroku : \"%s\"\n", henkankey ) ;
  fflush( stderr ) ;
#endif
  /* Ρɤ¸ߤ뤫ݤ*/
  if( *hTop == NULL ){
    /* Ρɤ¸ߤʤäν*/
#ifdef DEBUG
    fprintf( stderr, "Hast Table is NULL.\n" ) ;
    fflush( stderr ) ;
#endif
    /* Ρɤݤ롣*/
    if( phNode != NULL ){
      /* hNode 贰˺Ѳǽʡ */
      if( kanzenSairiyou ){
	hNode = phNode ;
	hNode->left = hNode->right =
	  hNode->future = hNode->past = NULL ;
      } else {
	/* ʤä顢ؤƤ륹ȥ󥰤ͭ롣*/
	hNode = allocate_NewHenkanKakuteiKouhoSub() ;
	hNode->henkankey = phNode->henkankey ;
	hNode->position  = phNode->position ;
	hNode->length    = phNode->length ;
      }
    } else {
      /* ͭǤʤġ*/
      hNode = allocate_NewHenkanKakuteiKouho( henkankey ) ;
    }
    *hTop = hNode ;
    hNode->henkanresults = NULL ;
  } else {
    /* ʬõѤơƱѴ¸ߤ뤫ɤĴ٤롣*/
    hNode = henkanKouhoWoSagashiteNakattaraMalloc
      ( *hTop, henkankey, phNode ) ;
    if( phNode != NULL && kanzenSairiyou )
      free( phNode ) ;
  }
  /* ѴѴ줿̤򸫤롣*/
  vNode = hNode->henkanresults ;
  /* Ѵ줿̤ȤΤ¸ߤΡ ʤ顢롼ס*/
  while( vNode != NULL ){
    /* ϿƤޤ õ(^^;;; */
    if( !cmpStringAndCandidate
	( hresult, vNode->node, vNode->position, vNode->length ) ){
      /* ⤦ϿƤä顢Ƭ˻ä롣*/
      shiteisaretaVectorIndexWoListNoSentouNiMottekuru
	( &hNode->henkanresults, vNode ) ;
      /* free ƤʤΤǡ free 롣*/
      if( pvNode != NULL )
	free( pvNode ) ;
      /* λ*/
      return ;
    }
    /* Ѵ̤򸫤롣*/
    vNode = vNode->next ;
  }
  /* ꤵ줿ΤֽƤꥹȤ˲ä롣*/
  miraiKaraKakoHetoHenkanSaretaKouhoWoOberu( rhTop, hNode ) ;

  /* ˤ⺣Τ褦ѴϤʤäĤξν*/
  if( pvNode != NULL ){
    vNode = pvNode ;
  } else {
    vNode = alloc_NewVectorIndexNode() ;
    /* Ѵ̤Ф롣*/
    henkanKakuteiBufferListTop = 
      add_SkkinpSearchVector
      ( henkanKakuteiBufferListTop, hresult,
	&vNode->node, &vNode->position ) ;
    vNode->length   = myCharStrlen( hresult ) ;
  }
  /* hNode->henkanresults == vNode ǤȤȤФˤʤ*/
  vNode->next     = hNode->henkanresults ;
  vNode->prev     = NULL ;
  if( hNode->henkanresults != NULL )
    ( hNode->henkanresults )->prev = vNode ;
  hNode->henkanresults = vNode ;
  return ;
}

/*
 * δؿϴѴꤷΤΥꥹȤ椫鳺
 * Purge ꥹȤˤĤʤ򤹤ؿ
 *------
 * ϿȤϤεդǡpurgeꥹȤäѴꤷ˲
 * ȤȤ򤹤롣skkinputsearchvector ξõǤΤ
 * save Ĥäݤ⤷ʤ
 */
void purge_SudeniHenkanKakuteiShitamono( struct SKKInputNode *node )
{
  int ret, kanzenSairiyou ;
  SkkinpHenkanKakuteiKouho *hNode, *hpNode, **hTop, **rhTop ;
  SkkinpHenkanKakuteiKouho *hNodePurge, **pTop, **rpTop ;
  VectorIndex *vNodeTarget, *vNode, *vNodePurge ;
  struct myChar *henkankey ;

  /* ѡƤ⼭ѹäȤˤʤ롣*/
  skkinput_jisyo_dirty          = True ;
  skkinput_autosave_jisyo_dirty = True ;

  vNodeTarget = node->j_current_henkan_vector_index ;
  henkankey   = ( node->j_okurigana_mode )?
    node->j_henkan_key : node->j_search_key ;

#ifdef DEBUG
  printf( "purge_SudeniHenkanKakuteiShitamono: \"" ) ;
  myCharFputstring( stdout, henkankey ) ;
  printf( "\"\n" ) ;
  debug_dump_kouhotree( recentlyPurgeKouho ) ;
#endif

  ret = henkanKakuteiHashFunction( henkankey ) ;

  /* 겾̾ѴʤΡ Ȥ㤦Ρ */
  if( node->j_okurigana_mode ){
    hTop  = &okuriHenkanKakuteiHash[ ret ] ;
    pTop  = &purgeSaretaOkuriKouho[ ret ] ;
    rhTop = &recentlyOkuriariKakuteiKouho ;
    rpTop = &recentlyOkuriariPurgeKouho ; ;
  } else {
    /* 겾̾Ѵʤäν*/
    hTop  = &henkanKakuteiHash[ ret ] ;
    pTop  = &purgeSaretaKouho[ ret ] ;
    rhTop = &recentlyKakuteiKouho ;
    rpTop = &recentlyPurgeKouho ;
  }
  /* ѴΤ¸ߤ롩 */
  if( searchHNodeWithHenkanKeyAndResultWithVI
      ( hTop, henkankey, vNodeTarget, &hpNode, &hNode, &vNode ) ){
    if( vNode == hNode->henkanresults ){
      /* ƤѴ̤줿ȤˤʤΡ */
      if( ( hNode->henkanresults = vNode->next ) == NULL ){
	delete_NodeInBinaryTree
	  ( hTop, rhTop, hpNode, hNode ) ;
	kanzenSairiyou = True ;
      } else {
	( vNode->next )->prev = NULL ;
	kanzenSairiyou = False ;
      }
#ifdef DEBUG
      printf( "Hit....? \"" ) ;
      myCharFputstrning( stdout, vNode->node->text + vNode->position, vNode->length ) ;
      printf( "\"\n" ) ;
#endif
    } else {
      if( vNode->next != NULL )
	( vNode->next )->prev = vNode->prev ;
      if( vNode->prev != NULL )
	( vNode->prev )->next = vNode->next ;
      kanzenSairiyou = False ;
#ifdef DEBUG
      printf( "Hit....? \"" ) ;
      myCharFputstrning( stdout, vNode->node->text + vNode->position, vNode->length ) ;
      printf( "\"\n" ) ;
#endif
    }
  } else {
#ifdef DEBUG
    printf( "hoge?\n" ) ;
#endif
    vNode = NULL ;
    hNode = NULL ;
    kanzenSairiyou = False ;
  }
  /* ϥå夬ҥåȤɤ򸫤롣*/
  if( *pTop == NULL ){
    /* ϥå˺Τ褦ѴϿƤޤ*/
    if( hNode != NULL ){
      if( kanzenSairiyou ){
	hNodePurge = hNode ;
	hNode->left = hNode->right =
	  hNode->future = hNode->past = NULL ;
      } else {
	hNodePurge = allocate_NewHenkanKakuteiKouhoSub() ;
	/* ʸȴФ*/
	hNodePurge->henkankey = hNode->henkankey ;
	hNodePurge->position  = hNode->position ;
	hNodePurge->length    = hNode->length ;
      }
    } else {
      /* Ȥ櫓ǡΡɤݤޤ*/
      hNodePurge = allocate_NewHenkanKakuteiKouho( henkankey ) ;
    }
    /* ϥåơ֥⹹ޤ*/
    *pTop = hNodePurge ;
    hNodePurge->henkanresults = NULL ;
  } else {
    /* ʲʬõƱѴȤ줿Ȥ뤫ɤĴ *
     * ٤ޤ*/
    hNodePurge = henkanKouhoWoSagashiteNakattaraMalloc
      ( *pTop, henkankey, hNode ) ;
    if( hNode != NULL && kanzenSairiyou )
      free( hNode ) ;
  }
  /* ꤵ줿ΤֽƤꥹȤ˲ä롣*/
  miraiKaraKakoHetoHenkanSaretaKouhoWoOberu( rpTop, hNodePurge ) ;

  /* ѴѴ줿̤򸫤롣*/
  vNodePurge = katsuteNoHenkanKekkaWoSenkeiTansaku
    ( hNodePurge->henkanresults, vNodeTarget ) ;
  /* ϿƤޤ */
  if( vNodePurge != NULL ){
    /* ⤦ϿƤä顢λ*/
    if( vNode != NULL )
      free( vNode ) ;
    return ;
  }
  /* ˤ⺣Τ褦ѴϤʤäĤξν*/
  vNodePurge = vNodeTarget ;
  /* Ƭä顢ؤƤݥ󥿤⤺餹*/
  if( vNodePurge->prev == NULL ){
    node->j_henkan_vector_index_top = vNodePurge->next ;
  } else {
    ( vNodePurge->prev )->next = vNodePurge->next ;
  }
  if( vNodePurge->next != NULL ){
    ( vNodePurge->next )->prev = vNodePurge->prev ;
  }
  node->j_current_henkan_vector_index = node->j_henkan_vector_index_top ;

  if( vNode != NULL ){
    vNodePurge->node     = vNode->node ;
    vNodePurge->length   = vNode->length ;
    vNodePurge->position = vNode->position ;
    /* ʸϤΤפˤʤäġ*/
    free( vNode ) ;
  } else {
    /* Ѵ̤Ф롣*/
    henkanKakuteiBufferListTop = 
      add_CandidateToSkkinpSearchVector
      ( henkanKakuteiBufferListTop, vNodePurge ) ;
  }
  if( hNodePurge->henkanresults != NULL )
    ( hNodePurge->henkanresults )->prev = vNodePurge ;
  vNodePurge->next = hNodePurge->henkanresults ;
  vNodePurge->prev = NULL ;
  hNodePurge->henkanresults = vNodePurge ;
#ifdef DEBUG
  printf( "Hit....? \"" ) ;
  myCharFputstrning( stdout, vNodePurge->node->text + vNodePurge->position, vNodePurge->length ) ;
  printf( "\"\n" ) ;
  printf( "purge_SudeniHenkanKakuteiShitamono last: \n" ) ;
  debug_dump_kouhotree( recentlyPurgeKouho ) ;
#endif
  return ;
}

/*
 * δؿϴѴꤷΤΥꥹȤ椫鳺
 * Purge ꥹȤˤĤʤ򤹤ؿ
 *------
 * ϿȤϤεդǡpurgeꥹȤäѴꤷ˲
 * ȤȤ򤹤롣skkinputsearchvector ξõǤΤ
 * save Ĥäݤ⤷ʤ
 */
void purge_SudeniHenkanKakuteiShitamonoByString
( struct myChar *henkankey, struct myChar *hresult, int okuri )
{
  int ret, kanzenSairiyou = False ;
  SkkinpHenkanKakuteiKouho *hNode, *hpNode, **hTop, **rhTop ;
  SkkinpHenkanKakuteiKouho *hNodePurge, **pTop, **rpTop ;
  VectorIndex *vNode, *vNodePurge ;

  /* ѡƤ⼭ѹäȤˤʤ롣*/
  skkinput_jisyo_dirty          = True ;
  skkinput_autosave_jisyo_dirty = True ;

  ret = henkanKakuteiHashFunction( henkankey ) ;
  /* 겾̾ѴʤΡ Ȥ㤦Ρ */
  if( okuri ){
    hTop  = &okuriHenkanKakuteiHash[ ret ] ;
    pTop  = &purgeSaretaOkuriKouho[ ret ] ;
    rhTop = &recentlyOkuriariKakuteiKouho ;
    rpTop = &recentlyOkuriariPurgeKouho ;
  } else {
    /* 겾̾Ѵʤäν*/
    hTop  = &henkanKakuteiHash[ ret ] ;
    pTop  = &purgeSaretaKouho[ ret ] ;
    rhTop = &recentlyKakuteiKouho ;
    rpTop = &recentlyPurgeKouho ;
  }
  /* ѴΤ¸ߤ롩 */
  if( searchHNodeWithHenkanKeyAndResult
      ( hTop, henkankey, hresult, &hpNode, &hNode, &vNode ) ){
    if( vNode == hNode->henkanresults ){
      /* ƤѴ̤줿ȤˤʤΡ */
      if( ( hNode->henkanresults = vNode->next ) == NULL ){
	delete_NodeInBinaryTree
	  ( hTop, rhTop, hpNode, hNode ) ;
	kanzenSairiyou = True ;
      } else {
	( vNode->next )->prev = NULL ;
	kanzenSairiyou = False ;
      }
    } else {
      if( vNode->next != NULL )
	( vNode->next )->prev = vNode->prev ;
      if( vNode->prev != NULL )
	( vNode->prev )->next = vNode->next ;
      kanzenSairiyou = False ;
    }
  } else {
    vNode = NULL ;
    hNode = NULL ;
  }
  /* ϥå夬ҥåȤɤ򸫤롣*/
  if( *pTop == NULL ){
    /* ϥå˺Τ褦ѴϿƤޤ*/
    if( hNode != NULL ){
      if( kanzenSairiyou ){
	hNodePurge = hNode ;
	hNodePurge->left = hNodePurge->right = hNodePurge->future =
	  hNode->past = NULL ;
      } else {
	hNodePurge = allocate_NewHenkanKakuteiKouhoSub() ;
	/* ʸȴФ*/
	hNodePurge->henkankey = hNode->henkankey ;
	hNodePurge->position  = hNode->position ;
	hNodePurge->length    = hNode->length ;
      }
    } else {
      /* Ȥ櫓ǡΡɤݤޤ*/
      hNodePurge = allocate_NewHenkanKakuteiKouho( henkankey ) ;
    }
    /* ϥåơ֥⹹ޤ*/
    *pTop = hNodePurge ;
    hNodePurge->henkanresults = NULL ;
  } else {
    /* ʲʬõƱѴȤ줿Ȥ뤫ɤĴ *
     * ٤ޤ*/
    hNodePurge = henkanKouhoWoSagashiteNakattaraMalloc
      ( *pTop, henkankey, hNode ) ;
    if( hNode != NULL && kanzenSairiyou )
      free( hNode ) ;
  }
  /* ꤵ줿ΤֽƤꥹȤ˲ä롣*/
  miraiKaraKakoHetoHenkanSaretaKouhoWoOberu( rpTop, hNodePurge ) ;

  /* ѴѴ줿̤򸫤롣*/
  vNodePurge = hNodePurge->henkanresults ;
  /* Ѵ줿̤ȤΤ¸ߤΡ ʤ顢롼ס*/
  while( vNodePurge != NULL ){
    /* ϿƤޤ õ(^^;;; */
    if( !cmpStringAndCandidate
	( hresult, vNodePurge->node,
	  vNodePurge->position, vNodePurge->length ) ){
      /* ⤦ϿƤä顢λ*/
      if( vNode != NULL )
	free( vNode ) ;
      return ;
    }
    /* Ѵ̤򸫤롣*/
    vNodePurge = vNodePurge->next ;
  }
  /* ˤ⺣Τ褦ѴϤʤäĤξν*/
  if( vNode != NULL ){
    vNodePurge = vNode ;
  } else {
    /* ˤ⺣Τ褦ѴϤʤäĤξν*/
    vNodePurge = alloc_NewVectorIndexNode() ;
    /* Ѵ̤Ф롣*/
    henkanKakuteiBufferListTop = 
      add_SkkinpSearchVector( henkanKakuteiBufferListTop, hresult,
			      &vNodePurge->node, &vNodePurge->position ) ;
    vNodePurge->length   = myCharStrlen( hresult ) ;
  }
  if( hNodePurge->henkanresults != NULL )
    ( hNodePurge->henkanresults )->prev = vNodePurge ;
  vNodePurge->next = hNodePurge->henkanresults ;
  vNodePurge->prev = NULL ;
  hNodePurge->henkanresults = vNodePurge ;
  return ;
}

/*
 * ǤǶѴ˻Ȥ줿˥ե˽񤭽Фؿ
 */
unsigned long recentlyHenkanKakuteiKouhoWoFileNiKaku
( FILE *fp, FILE *motoJisyoFp, int okuri )
{
  SkkinpHenkanKakuteiKouho *hNode ;
  SkkinpSearchVector *top, *purgeTop ;
  VectorIndex *vTop, *vTopPurge ;
  int len ;
  unsigned long lines = 0 ;
  struct myChar search_key[ TRANSBUFSIZE ] ;

  /* 겾̵̾ͭˤäƸ٤ꥹȤۤʤ롣*/
  if( okuri ){
    hNode = recentlyOkuriariKakuteiKouho ;
  } else {
    hNode = recentlyKakuteiKouho ;
  }
  /* Ѵꤵ줿Ȥʤä顢Τޤ޵롣*/
  if( hNode == NULL )
    return lines ;
  /* ɽѿν*/
  vTop = vTopPurge = NULL ;
  /* ˥եػäƤ*/
  while( hNode != NULL ){
    top = NULL ;
    /* ޤѴꤷΤФơѴ̤򸫤롣*/
    top = makeSkkSearchVectorFromVectorIndex
      ( top, hNode->henkanresults ) ;
    /* ѴȴФ*/
    copyCandidate
      ( search_key,
	hNode->henkankey, hNode->position, hNode->length ) ;
    /* Ѵˤ뤫ɤĴ٤롣
     * ǤȤμΥեݥ󥿤ǤޤȤա*/
    top = j_search_skkinput_jisyo_with_fileptr
      ( search_key, top, okuri, motoJisyoFp ) ;
    /* ơĤȡ*/
    if( top != NULL ){
      /* 䤬¸ߤߤ顢ѡ¦θǤ⤷ޤ礦*/
      purgeTop = NULL ;
      purgeTop = searchSudeniPurgeSaretamono
	( search_key, purgeTop, okuri ) ;
      /* ѡ¦θ򤢤餫ϥåˤǤáߤޤ礦*/
      if( purgeTop != NULL ){
	vTopPurge = makeSearchVectorIndex( purgeTop, &len, False ) ;
      }
      /* Ф VectorIndex 롣*/
      if( ( vTop = makeSearchVectorIndex( top, &len, True ) ) != NULL ){
#ifdef DEBUG
	printf( "Search-Key..." ) ;
	myCharFputstring( stdout, search_key ) ;
	printf( "\n" ) ;
#endif
	/* Ѵ򼭽˽񤭽Ф*/
	myCharFputstring( fp, search_key ) ;
	fputc( ' ', fp ) ;
	/* VectorIndex եݤФĤοͤϺǸ'\n'  *
	 * Ƥ롣*/
	writeVectorIndexToFile( fp, vTop ) ;
	lines ++ ;
	/* ݤ롣*/
	free_VectorIndex( &vTop ) ;
      }
      free_VectorIndex( &vTopPurge ) ;
      free_SkkinpSearchVector( &top ) ;
      free_SkkinpSearchVector( &purgeTop ) ;
    }
    hNode = hNode->past ;
  }
  return lines ;
}

/*
 * ڹ¤éäơƤؿ
 *-----
 * δؿϺƵŪ˸ƤӽФ롣
 */
static void clearHenkanKakuteiHashSub( SkkinpHenkanKakuteiKouho *hNode )
{
  /* λҶ롣*/
  if( hNode->left != NULL ){
    clearHenkanKakuteiHashSub( hNode->left ) ;
    hNode->left = NULL ;
  }
  /* λҶ롣*/
  if( hNode->right != NULL ){
    clearHenkanKakuteiHashSub( hNode->right ) ;
    hNode->left = NULL ;
  }
  /* Ѵˤ֤餵äƤѴ̤ä롣*/
  free_VectorIndex( &hNode->henkanresults ) ;
  /* ޤ괺 free ɡNULL ˤƤޤ礦*/
  hNode->henkanresults = NULL ;
  hNode->henkankey     = NULL ;
  hNode->past          = NULL ;
  hNode->future        = NULL ;
  /* ʬ롣*/
  free( hNode ) ;
  return ;
}

/*
 * ϥåơ֥򥯥ꥢؿ
 */
void clearHenkanKakuteiHash( void )
{
  int i ;
  /* ϥåơ֥įơǤƼΤƤ롣*/
  for( i = 0 ; i < HENKANKAKUTEIHASHSIZE ; i ++ ){
    /* ξϻȤƤޤäƤΤʤ顢åפ롣*/
    if( okuriHenkanKakuteiHash[ i ] != NULL ){
      clearHenkanKakuteiHashSub( okuriHenkanKakuteiHash[ i ] ) ;
      /* ϥåơ֥뤫ä롣*/
      okuriHenkanKakuteiHash[ i ] = NULL ;
    }
    if( henkanKakuteiHash[ i ] != NULL ){
      clearHenkanKakuteiHashSub( henkanKakuteiHash[ i ] ) ;
      /* ϥåơ֥뤫ä롣*/
      henkanKakuteiHash[ i ] = NULL ;
    }
    if( purgeSaretaKouho[ i ] != NULL ){
      clearHenkanKakuteiHashSub( purgeSaretaKouho[ i ] ) ;
      /* ϥåơ֥뤫ä롣*/
      purgeSaretaKouho[ i ]       = NULL ;
    }
    if( purgeSaretaOkuriKouho[ i ] != NULL ){
      clearHenkanKakuteiHashSub( purgeSaretaOkuriKouho[ i ] ) ;
      /* ϥåơ֥뤫ä롣*/
      purgeSaretaOkuriKouho[ i ]  = NULL ;
    }
  }
  /* Ѵꤷ̤ƤХåե⥯ꥢ롣*/
  if( henkanKakuteiBufferListTop != NULL ){
    free_SkkinpSearchVector( &henkanKakuteiBufferListTop ) ;
    henkanKakuteiBufferListTop   = NULL ;
  }
  recentlyKakuteiKouho         = NULL ;
  recentlyOkuriariKakuteiKouho = NULL ;
  recentlyPurgeKouho           = NULL ;
  recentlyOkuriariPurgeKouho   = NULL ;
  return ;
}

/*
 * ѴǤäƥơ֥뤫鸡η̤ؿ
 */
static int searchHNodeWithHenkanKeyAndResult
( SkkinpHenkanKakuteiKouho **hTop,
  struct myChar *henkankey, struct myChar *hresult,
  SkkinpHenkanKakuteiKouho **rhpNode, SkkinpHenkanKakuteiKouho **rhNode,
  VectorIndex **rvNode )
{
  int ret ;
  SkkinpHenkanKakuteiKouho *hNode, *hpNode ;
  VectorIndex *vNode ;
  /* ϥåơ֥Ҥ*/
  hNode = *hTop ;
  /* Ρɤ¸ߤ뤫ݤ*/
  if( hNode == NULL )
    return False ;
  /* ƥΡɡ*/
  hpNode = NULL ;
  /* ʬõ롣*/
  while( 1 ){
    /* ƱѴǤ */
    ret = cmpStringAndCandidate
      ( henkankey, hNode->henkankey, hNode->position, hNode->length ) ;
    if( ret == 0 ){
      /* ƱѴǤ*/
      break ;
    } else if( ret > 0 ){
      /* λҶ򤿤ɤ硣*/
      if( hNode->right == NULL )
	return False ;
      /* ƥΡɤ¸롣*/
      hpNode = hNode ;
      /* λҶޤ¸ߤ硣*/
      hNode = hNode->right ;
    } else {
      /* λҶ򤿤ɤ硣*/
      if( hNode->left == NULL )
	return False ;
      /* ƥΡɤ¸롣*/
      hpNode = hNode ;
      /* λҶޤ¸ߤ硣*/
      hNode = hNode->left ;
    }
  }
  /* Ѵ줿̤ȤΤ¸ߤΡ ʤ顢롼ס*/
  vNode = hNode->henkanresults ;
  while( vNode != NULL ){
    /* ϿƤޤ õ(^^;;; */
    if( !cmpStringAndCandidate
	( hresult, vNode->node, vNode->position, vNode->length ) ){
      break ;
    }
    /* Ѵ̤򸫤롣*/
    vNode = vNode->next ;
  }
  /* ɺǸޤǸդʤä硣*/
  if( vNode == NULL )
    return False ;
  /* դä硣*/
  *rhpNode = hpNode ;
  *rhNode  = hNode ;
  *rvNode  = vNode ;
  return True ;
}

/*
 * ѴǤäƥơ֥뤫鸡η̤ؿ
 */
static int searchHNodeWithHenkanKeyAndResultWithVI
( SkkinpHenkanKakuteiKouho **hTop,
  struct myChar *henkankey, VectorIndex *keyVNode,
  SkkinpHenkanKakuteiKouho **rhpNode, SkkinpHenkanKakuteiKouho **rhNode,
  VectorIndex **rvNode )
{
  int ret ;
  SkkinpHenkanKakuteiKouho *hNode, *hpNode ;
  VectorIndex *vNode ;
  /* ϥåơ֥Ҥ*/
  hNode = *hTop ;
  /* Ρɤ¸ߤ뤫ݤ*/
  if( hNode == NULL )
    return False ;
  /* ƥΡɡ*/
  hpNode = NULL ;
  /* ʬõ롣*/
  while( 1 ){
    /* ƱѴǤ */
    ret = cmpStringAndCandidate
      ( henkankey, hNode->henkankey, hNode->position, hNode->length ) ;
    if( ret == 0 ){
      /* ƱѴǤ*/
      break ;
    } else if( ret > 0 ){
      /* λҶ򤿤ɤ硣*/
      if( hNode->right == NULL )
	return False ;
      /* ƥΡɤ¸롣*/
      hpNode = hNode ;
      /* λҶޤ¸ߤ硣*/
      hNode = hNode->right ;
    } else {
      /* λҶ򤿤ɤ硣*/
      if( hNode->left == NULL )
	return False ;
      /* ƥΡɤ¸롣*/
      hpNode = hNode ;
      /* λҶޤ¸ߤ硣*/
      hNode = hNode->left ;
    }
  }
  /* Ѵ줿̤ȤΤ¸ߤΡ ʤ顢롼ס*/
  vNode = hNode->henkanresults ;
  while( vNode != NULL ){
    /* ϿƤޤ õ(^^;;; */
    if( !cmpCandidate
	( keyVNode->node, keyVNode->position, keyVNode->length,
	  vNode->node, vNode->position, vNode->length ) ){
      break ;
    }
    /* Ѵ̤򸫤롣*/
    vNode = vNode->next ;
  }
  /* ɺǸޤǸդʤä硣*/
  if( vNode == NULL )
    return False ;
  *rhpNode = hpNode ;
  *rhNode  = hNode ;
  *rvNode  = vNode ;
  return True ;
}

/*
 * ϥåơ֥ʬڤĺؿ
 */
static void delete_NodeInBinaryTree
( SkkinpHenkanKakuteiKouho **top, SkkinpHenkanKakuteiKouho **rTop,
  SkkinpHenkanKakuteiKouho *parentNode, SkkinpHenkanKakuteiKouho *deleteNode )
{
  SkkinpHenkanKakuteiKouho *hNode ;
  /* ҶΤʤդäѤä硣*/
  if( deleteNode->left == NULL && deleteNode->right == NULL ){
    /* ää */
    if( parentNode == NULL )
      *top = NULL ;
    goto exit_delete_NodeInBinaryTree ;
  }
  /* λҶʤä硣*/
  if( deleteNode->left == NULL ){
    /* ääˤϡäؤݥ󥿤롣*/
    if( parentNode == NULL ){
      *top = deleteNode->right ;
    } else {
      /* äʤäˤϡοƤλҶؤݥ󥿤롣*/
      if( parentNode->right == deleteNode ){
	parentNode->right = deleteNode->right ;
      } else {
	parentNode->left = deleteNode->right ;
      }
    }
    goto exit_delete_NodeInBinaryTree ;
  }
  /* λҶʤä硣*/
  if( deleteNode->right == NULL ){
    /* ääˤϡäؤݥ󥿤롣*/
    if( parentNode == NULL ){
      *top = deleteNode->left ;
    } else {
      /* äʤäˤϡοƤλҶؤݥ󥿤 *
       * 롣*/
      if( parentNode->right == deleteNode ){
	parentNode->right = deleteNode->left ;
      } else {
	parentNode->left = deleteNode->left ;
      }
    }
    goto exit_delete_NodeInBinaryTree ;
  }
  /* λҶξˤϡĺǤ褦ȤƤ *
   * λֹ礭ʺǤᤤͤäդäѤõ*/
  hNode = deleteNode->right ;
  /* αλҶΤäȺκΡĺλҶդäѤλͤϡ *
   * 褦ȤƤκλҶͤ礭ʬڤ *
   * 꼫Ǥ롣*/
  while( hNode->left != NULL )
    hNode = hNode->left ;
  hNode->left = deleteNode->left ;
  /* 褦ȤƤοƤ⡢ɤλҶä *
   * ȤƤΡ Ȥ⺬äʤΡ */
  if( parentNode == NULL ){
    *top = hNode ;
  } else if( parentNode->right == deleteNode ){
    /* λҶõƤĤʤ*/
    parentNode->right = hNode ;
  } else {
    /* λҶõƤĤʤ*/
    parentNode->left = hNode ;
  }

exit_delete_NodeInBinaryTree:
  if( rTop != NULL ){
    /* ߲̤ΥꥹȤ롣*/
    if( *rTop == deleteNode ){
      *rTop = deleteNode->past ;
      if( deleteNode->past != NULL )
	( deleteNode->past )->future = NULL ;
    } else {
      if( deleteNode->past != NULL )
	( deleteNode->past )->future = deleteNode->future ;
      if( deleteNode->future != NULL )
	( deleteNode->future )->past = deleteNode->past ;
    }
  }
  deleteNode->past = deleteNode->future = NULL ;
#if 0
  /* ˶ͭ˻Ȥ뤫⤷ʤΤǡǲΤ»ȤΡ*/
  free( deleteNode ) ;
#endif
  return ;
}

/*
 * ѴꤵߤƤ䤫 completion 褦Ȥؿ
 */
SkkinpSearchVector *j_completion_search_sudeniKakuteiShitaKouho
( SkkinpSearchVector *top, struct myChar *completion_key )
{
  SkkinpHenkanKakuteiKouho *hNode = recentlyKakuteiKouho ;  
  VectorIndex vNode ;
  int length = myCharStrlen( completion_key ) ;

  /* 䤬Ԥޤõ硣*/
  while( hNode != NULL ){
    /* õĹʤСܤǤ롣*/
    if( hNode->length > length ){
      /* õפʤܤǤ롣*/
      if( !cmpStringAndCandidate
	  ( completion_key, hNode->henkankey, hNode->position, length ) ){
	/* դäν*/
	vNode.node     = hNode->henkankey ;
	vNode.length   = hNode->length ;
	vNode.position = hNode->position ;
	vNode.next     = NULL ;
	top = makeSkkSearchVectorFromVectorIndex( top, &vNode ) ;
      }
    }
    /* ؤõ³*/
    hNode = hNode->past ;
  }
  return top ;
}

/*
 * ѴꤵߤƤ䤫 completion 褦Ȥؿ
 */
SkkinpSearchVector *j_completion_search_sudeniPurgeSaretamono
( SkkinpSearchVector *top, struct myChar *completion_key )
{
  SkkinpHenkanKakuteiKouho *hNode = recentlyPurgeKouho ;  
  VectorIndex vNode ;
  int length = myCharStrlen( completion_key ) ;

  /* 䤬Ԥޤõ硣*/
  while( hNode != NULL ){
    /* õĹʤСܤǤ롣*/
    if( hNode->length > length ){
      /* õפʤܤǤ롣*/
      if( !cmpStringAndCandidate
	  ( completion_key, hNode->henkankey, hNode->position, length ) ){
	/* դäν*/
	vNode.node     = hNode->henkankey ;
	vNode.length   = hNode->length ;
	vNode.position = hNode->position ;
	vNode.next     = NULL ;
	top = makeSkkSearchVectorFromVectorIndex( top, &vNode ) ;
      }
    }
    /* ؤõ³*/
    hNode = hNode->past ;
  }
  return top ;
}

static void skkinputDumpVectorIndexNode
( FILE *fp, SkkinpSearchVector *sNode, int position, int length )
{
  struct myChar *ptr ;
  int i ;
  ptr   = sNode->text + position ;
#ifdef DEBUG
  printf( "Dump ... \"" ) ;
#endif
  /* 쵤˽񤭽Ф*/
  for( i = 0 ; i < length ; i ++, ptr ++, position ++ ){
    if( IS_END_OF_STRING( *ptr ) ){
      if( ( sNode = sNode->next ) == NULL )
	break ;
      ptr      = sNode->text ;
      position = 0 ;
    }
#ifdef DEBUG
    myCharFputEUCc( *ptr, stdout ) ;
#endif
    fputc( ptr->charset, fp ) ;
    fputc( ( ( ptr->chara ) & 0x00FF ), fp ) ;
    fputc( ( ( ptr->chara ) >> 8 ), fp ) ;
  }
#ifdef DEBUG
  printf( "\"\n" ) ;
#endif
  fputc( '\0', fp ) ;
  fputc( '\0', fp ) ;
  fputc( '\0', fp ) ;
  return ;
}

/*
 * ȥ֤κݤϿƤñե˽񤭽Фؿ
 */
void skkinputNoNaibuNoKouhoWoFileNiKaku
( FILE *fp, int okuri, int purge )
{
  SkkinpHenkanKakuteiKouho *hNode ;
  VectorIndex *vNode ;
  int mode ;

#ifdef DEBUG
  printf( "PurgeTree ---- \n" ) ;
  debug_dump_kouhotree( recentlyPurgeKouho ) ;
  printf( "\n" ) ;
#endif

  /* 겾̵̾ͭˤäƸ٤ꥹȤۤʤ롣*/
  if( purge ){
    if( okuri ){
      hNode = recentlyOkuriariPurgeKouho ;
      mode  = 0 ;
    } else {
      hNode = recentlyPurgeKouho ;
      mode  = 1 ;
    }
  } else {
    if( okuri ){
      hNode = recentlyOkuriariKakuteiKouho ;
      mode  = 2 ;
    } else {
      hNode = recentlyKakuteiKouho ;
      mode  = 3 ;
    }
  }
  /* Ѵꤵ줿Ȥʤä顢Τޤ޵롣*/
  if( hNode == NULL )
    return ;
#ifdef DEBUG
  printf( "autosave-mode ... %d\n", mode ) ;
#endif
  /* ˥եػäƤ*/
  while( hNode != NULL ){
    /* charset ο 255 ޤǹԤȤޤˤʤäƤ롣*/
    fputc( 0xFF, fp ) ;
    fputc( mode, fp ) ;
    fputc( '\0', fp ) ;
    /* Ѵ񤭽ФƤ롣*/
    skkinputDumpVectorIndexNode
      ( fp, hNode->henkankey, hNode->position, hNode->length ) ;
    vNode = hNode->henkanresults ; 
    while( vNode != NULL ){
      skkinputDumpVectorIndexNode
	( fp, vNode->node, vNode->position, vNode->length ) ;
      vNode = vNode->next ;
    }
    fputc( '\0', fp ) ;
    fputc( '\0', fp ) ;
    fputc( '\0', fp ) ;

    hNode = hNode->past ;
  }
  return ;
}

static int skkinputRead3ByteAndReturnMyChar
( FILE *fp, struct KanjiBuffer *kbuf )
{
  unsigned char buffer[ 3 ] ;
  struct myChar mchara ;

  while( !feof( fp ) ){
    fread( buffer, sizeof( unsigned char ), 3, fp ) ;
    if( buffer[ 0 ] == 0 &&
	buffer[ 1 ] == 0 &&
	buffer[ 2 ] == 0 )
      break ;
#ifdef DEBUG
    printf( "[%d,%d,%d] ", buffer[ 0 ], buffer[ 1 ], buffer[ 2 ] ) ;
#endif
    mchara.charset = buffer[ 0 ] ;
    mchara.chara   = ( ( unsigned short )buffer[ 1 ] |
		       ( ( ( unsigned short )buffer[ 2 ] )<< 8 ) ) ;
    add_kanjibuffer( kbuf, mchara ) ;
  }
#ifdef DEBUG
  printf( "\n" ) ;
#endif
  return True ;
}

/*
 * ȥ֥եɤñؿ
 * 餯̾ʤʤǽʴؿǤɤäƸ᤽
 */
void skkinputAutoSaveFileWoYondeFukugenSuru
( FILE *fp )
{
  struct KanjiBuffer henkankey, henkanresult ;
  unsigned char buffer[ 3 ] ;
  int map ;

  while( !feof( fp ) ){
    /* ե뤫ɤ߹ࡣ*/
    fread( buffer, sizeof( unsigned char ), 3, fp ) ;
    /* ǽɤʤȤȤϱǤ롣顼꥿*/
    if( buffer[ 0 ] != 0xFF )
      return ;
    map = buffer[ 1 ] ;

    /* Ѵڤ롣*/
    init_kanjibuffer( &henkankey ) ;
    skkinputRead3ByteAndReturnMyChar( fp, &henkankey ) ;
    if( henkankey.usage <= 0 ){
      /* Ѵ̵äϿϽʤᥪȥ֥ե뤬
       * Ƥȹͤ뤳Ȥˤ롣*/ 
      close_kanjibuffer( &henkankey ) ;
      break ;
    }
    /* Ѵڤ롣*/
    for( ; ; ){
      init_kanjibuffer( &henkanresult ) ;
      skkinputRead3ByteAndReturnMyChar( fp, &henkanresult ) ;
#ifdef DEBUG
      printf( "[ %d ]\n", henkanresult.usage ) ;
#endif
      if( henkanresult.usage <= 0 )
	break ;
#ifdef DEBUG
      printf( "Map: %d, Key :\"", map ) ;
      myCharFputstring( stdout, henkankey.buffer ) ;
      printf( "\"   Word :\"" ) ;
      myCharFputstring( stdout, henkanresult.buffer ) ;
      printf( "\"\n" ) ;
#endif
      /* 쵤Ͽ롣*/
      switch( map ){
      case 0 :
	purge_SudeniHenkanKakuteiShitamonoByString
	  ( henkankey.buffer, henkanresult.buffer, True ) ;
	break ;
      case 1 :
	purge_SudeniHenkanKakuteiShitamonoByString
	  ( henkankey.buffer, henkanresult.buffer, False ) ;
	break ;
      case 2 :
	add_SudeniHenkanKakuteiShitamonoByString
	  ( henkankey.buffer, henkanresult.buffer, True ) ;
	break ;
      case 3 :
	add_SudeniHenkanKakuteiShitamonoByString
	  ( henkankey.buffer, henkanresult.buffer, False ) ;
	break ;
      default :
	break ;
      }
      close_kanjibuffer( &henkanresult ) ;
    }
    close_kanjibuffer( &henkankey ) ;
  }
  /* ̤ؤλޤ򴹤롣
   *     ֤äơĤäȡĤɤȤʤǤ礦
   *   ֻ֤ϲĵդˤѤʤȤȤ()
   * ե꡼ֲ櫓Τ狼ʤȸäƤΤ衢ꡪ
   *   ֤줬ʬä顢ŷͤɤѿͤ()
   * ե꡼(֤ʤ͡)
   */
  skkinput_KakoToMiraiWoIrekaeru( &recentlyKakuteiKouho ) ;
  skkinput_KakoToMiraiWoIrekaeru( &recentlyOkuriariKakuteiKouho ) ;
  skkinput_KakoToMiraiWoIrekaeru( &recentlyPurgeKouho ) ;
  skkinput_KakoToMiraiWoIrekaeru( &recentlyOkuriariPurgeKouho ) ;
  return ;
}

/*
 * ֻ֤ϲĵդ̿Ѥ
 * ֱ̿äƤ㤢ʤ
 * ֥֥ڤ˵Ҥ줿ݤΤȤ
 * ʤɡϿդˤʤäƤΤǤҤä֤ؿ
 */
static void skkinput_KakoToMiraiWoIrekaeru
( SkkinpHenkanKakuteiKouho **top )
{
  SkkinpHenkanKakuteiKouho *tail, *node, *nextNode ;
  if( *top == NULL )
    return ;
  for( node = *top ; node->past != NULL ; node = node->past )
    ;
  /* դ*/
  tail = node ;
  while( node != NULL ){
    /* ̤λޤ򴹤롣*/
    nextNode     = node->future ;
    node->future = node->past ;
    node->past   = nextNode ;
    /* ֲ˼ʬϤΤǡ(Ȥ)̤ؤȤɤɬפ롣
     * 줿ϲؤλޤȤʤäƤ뤬*/
    node = nextNode ;
  }
  *top = tail ;
  return ;
}

#ifdef DEBUG
static void debug_dump_kouhotree
( SkkinpHenkanKakuteiKouho *top )
{
  VectorIndex *node ;
  if( top == NULL ){
    printf( "Empty\n" ) ;
    return ;
  }
  printf( "--- Node ---\n" ) ;
  printf( "Henkankey: " ) ;
  myCharFputstrning
    ( stdout, top->henkankey->text + top->position, top->length ) ;
  printf( "\n" ) ;
  printf( "Result: " ) ;
  for( node = top->henkanresults ; node != NULL ; node = node->next ){
    myCharFputstrning( stdout, node->node->text + node->position, node->length ) ;
    printf( "<-->" ) ;
  }
  printf( "\n" ) ;
  printf( "Past : \n" ) ;
  debug_dump_kouhotree( top->past ) ;
  return ;
}
#endif
