/* Public domain. */

#ifndef BITARRAY_H
#define BITARRAY_H

#include "gccattributes.h"
#include "gen_alloc.h"
#include "uint64alloc.h"

typedef struct bitarray { uint64alloc x ; } bitarray, *bitarray_ref ;

#define BITARRAY_ZERO { GEN_ALLOC_ZERO }

extern int bitarray_ready (bitarray *, unsigned int) ;
extern int bitarray_readyplus (bitarray *, unsigned int) ;
extern void bitarray_free (bitarray *) ;

extern void bitarray_clearsetn (bitarray *, unsigned int, unsigned int, unsigned char) ;
#define bitarray_clearn(x, start, len) bitarray_clearsetn(x, start, len, 0)
#define bitarray_setn(x, start, len)   bitarray_clearsetn(x, start, len, 1)

extern int bitarray_peek (bitarray const *, unsigned int) gccattr_pure ;
#define bitarray_isset(b, n) bitarray_peek(b, n)

extern void bitarray_clear (bitarray *, unsigned int) ;
extern void bitarray_set (bitarray *, unsigned int) ;

extern int bitarray_testandpoke (bitarray *, unsigned int, unsigned char) ;
#define bitarray_testandclear(b, n) bitarray_testandpoke(b, n, 0)
#define bitarray_testandset(b, n)   bitarray_testandpoke(b, n, 1)

extern unsigned int bitarray_firstclear (bitarray const *) gccattr_pure ;

#endif
