# encoding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997 - 2011, Ralph Amissah, All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.jus.uio.no/sisu/gpl.fsf/toc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/doc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/plain.txt>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: modules shared by the different db types, dbi, postgresql,
    sqlite

=end
module  SiSU_DB_DBI
  require_relative 'db_columns'                                             # db_columns.rb
  require_relative 'db_tests'                                               # db_tests.rb
  require_relative 'db_create'                                              # db_create.rb
  require_relative 'db_select'                                              # db_select.rb
  require_relative 'db_indexes'                                             # db_indexes.rb
  require_relative 'db_drop'                                                # db_drop.rb
  require_relative 'db_remove'                                              # db_remove.rb
  require_relative 'db_load_tuple'                                          # db_load_tuple.rb
  require_relative 'db_import'                                              # db_import.rb
  class Column_size < SiSU_DB_columns::Column_size                             # db_columns.rb
  end
  class Test < SiSU_DB_tests::Test                                             # db_tests.rb
  end
  class Create <SiSU_DB_create::Create                                         # db_create.rb
  end
  class Case <SiSU_DB_select::Case                                             # db_select.rb
  end
  class Index <SiSU_DB_index::Index                                            # db_indexes.rb
  end
  class Drop <SiSU_DB_drop::Drop                                               # db_drop.rb
  end
  class Remove <SiSU_DB_remove::Remove                                         # db_remove.rb
  end
  class Load_documents <SiSU_DB_tuple::Load_documents                          # db_load_tuple.rb
  end
  class Load_metadata <SiSU_DB_tuple::Load_metadata                            # db_load_tuple.rb
  end
  class Load_urls <SiSU_DB_tuple::Load_urls                                    # db_update urls
  end
  class Import <SiSU_DB_import::Import #<SiSU_DB::Column_size                  # db_import.rb
  end
end
__END__
