# encoding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997 - 2012, Ralph Amissah, All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.jus.uio.no/sisu/gpl.fsf/toc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/doc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/plain.txt>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: zap wipe clean previous output of the type specified

=end
module SiSU_Zap
  require_relative 'sysenv'                             # sysenv.rb
    include SiSU_Env
  pwd=Dir.pwd
  class Source
    def initialize(opt)
      @opt=opt
      @env=SiSU_Env::Info_env.new(@opt.fns)
      @zap_path="#{@env.path.output}/#{@env.fnb}"
      @zap=SiSU_Env::Clean_output.new(@opt)
    end
    def read
      if SiSU_Env::Info_settings.new.permission?('zap')
        tell=SiSU_Screen::Ansi.new(@opt.cmd,"Clean files related to processing #{@opt.cmd} ->","#{@opt.fns} -> #{@zap_path}")
        @zap.zap.main_output
        @zap.zap.site_map
        @zap.zap.epub
        @zap.zap.src
      else tell=SiSU_Screen::Ansi.new(@opt.cmd,'use of -Z (zap) has not enabled in sisurc.yml')
      end
      tell.warn unless @opt.cmd =~/q/
    end
  end
end
__END__
